import { BasicPageParams, BasicFetchResult } from '/@/api/model/baseModel';

/**
 * @description: MesBaseWarehouse分页参数 模型
 */
export interface MesBaseWarehousePageParams extends BasicPageParams {
  parentId: string;

  dataCode: string;

  dataName: string;

  warehouseType: string;

  areaType: string;

  warehouseId: string;

  areaId: string;

  manages: string;

  address: string;

  state: string;

  createUserId: string;

  createDateStart: string;
  createDateEnd: string;
}

/**
 * @description: MesBaseWarehouse分页返回值模型
 */
export interface MesBaseWarehousePageModel {
  id: string;

  parentId: string;

  dataCode: string;

  dataName: string;

  warehouseType: string;

  areaType: string;

  warehouseId: string;

  areaId: string;

  manages: string;

  address: string;

  state: string;

  createUserId: string;

  createDate: string;
}

/**
 * @description: MesBaseWarehouse表类型
 */
export interface MesBaseWarehouseModel {
  id: number;

  parentId: number;

  warehouseId: number;

  areaId: number;

  locationId: number;

  dataType: string;

  warehouseType: string;

  areaType: string;

  dataCode: string;

  dataName: string;

  address: string;

  manages: string;

  remark: string;

  state: number;

  sort: number;

  createUserId: number;

  createDate: string;

  modifyUserId: number;

  modifyDate: string;

  deleteMark: number;

  enabledMark: number;
}

/**
 * @description: MesBaseWarehouse分页返回值结构
 */
export type MesBaseWarehousePageResult = BasicFetchResult<MesBaseWarehousePageModel>;