import { defHttp } from '/@/utils/http/axios';

import { ErrorMessageMode } from '/#/axios';

/**
 * @description: 请求magicApi
 */
export const requestMagicApi = (
  { headers, query, body, method, url },
  mode: ErrorMessageMode = 'modal',
) => {
  const basicUrl = url.startsWith('/') ? '/magic-api' : '/magic-api/';
  return defHttp.request(
    {
      url: basicUrl + url,
      params: query,
      data: body,
      method,
      headers: {
        'content-type': 'application/x-www-form-urlencoded; charset=UTF-8',
        ...headers,
      },
    },
    {
      errorMessageMode: mode,
    },
  );
};
