import { defHttp } from '/@/utils/http/axios';

import { ErrorMessageMode } from '/#/axios';
import {
  ConversionPageListSearchModel,
  ConversionAddParamsModel,
  ConversionUpdateParamsModel,
  ConversionPageListResultModel,
  ConversionListAllModel,
} from './model';

enum Api {
  Page = '/caseErpUnit/caseErpUnitConvert/page',
  Conversion = '/caseErpUnit/caseErpUnitConvert',
  Info = '/caseErpUnit/caseErpUnitConvert/info',
  All = '/caseErpUnit/caseErpUnitConvert/list-all',
}

/**
 * @description: 查询单位换算列表（分页）
 */
export async function getConversionPageList(
  params?: ConversionPageListSearchModel,
  mode: ErrorMessageMode = 'modal',
) {
  return defHttp.get<ConversionPageListResultModel>(
    {
      url: Api.Page,
      params,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 新增单位换算配置
 */
export async function addConversionList(
  type: ConversionAddParamsModel,
  mode: ErrorMessageMode = 'modal',
) {
  return defHttp.post<number>(
    {
      url: Api.Conversion,
      params: type,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 修改单位换算配置
 */
export async function updateConversionList(
  type: ConversionUpdateParamsModel,
  mode: ErrorMessageMode = 'modal',
) {
  return defHttp.put<number>(
    {
      url: Api.Conversion,
      params: type,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 删除单位换算
 */
export async function deleteConversionList(id: string, mode: ErrorMessageMode = 'modal') {
  return defHttp.delete<number>(
    {
      url: Api.Conversion,
      data: id,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 查询单位换算详情
 */
export async function getConversionInfo(id: string, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<ConversionAddParamsModel>(
    {
      url: Api.Info,
      params: { id },
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 查询所有单位换算及单位换算详情
 */
export async function getConversionAll(mode: ErrorMessageMode = 'modal') {
  return defHttp.get<ConversionListAllModel[]>(
    {
      url: Api.All,
    },
    {
      errorMessageMode: mode,
    },
  );
}
