import { BasicPageParams, BasicFetchResult } from '/@/api/model/baseModel';

export interface MaterialPageListParams {
  name?: string; //物料名称
  state?: number; //状态
  startTime?: string; //开始时间
  endTime?: string; //结束时间
}

export interface MaterialAddParamsModel {
  code: string; //物料编号
  name: string; //物料名称
  unitName: string; //单位
  price: number; //采购单价
  state?: number; //状态
}

export interface MaterialUpdateParamsModel {
  id: string; //详情id
  code: string; //物料编号
  name: string; //物料名称
  unitName: string; //单位
  price: number; //采购单价
  state?: number; //状态
}

export interface MaterialListModel {
  id: string; //详情id
  code: string; //物料编号
  name: number; //物料名称
  model: string; //规格类型
  price: number; //采购单价
  unitName: string; //单位
  createDate: string; //添加时间
  state: number; //状态
  createUserName: string; //操作人
}

export type MaterialListSearchModel = BasicPageParams & MaterialPageListParams;
export type MaterialListResultModel = BasicFetchResult<MaterialListModel>;
