import { defHttp } from '/@/utils/http/axios';

import { ErrorMessageMode } from '/#/axios';
enum Api {
  Data = '/caseErpStock/caseErpInstoreLog/purchase-data',
  Price = '/caseErpStock/caseErpInstoreLog/purchase-price',
  Type = '/caseErpStock/caseErpInstoreLog/contract-types',
  Trend = '/caseErpStock/caseErpInstoreLog/supply-trends',
  Cost = '/caseErpStock/caseErpInstoreLog/cost-analysis-data',
  Deviation = '/caseErpStock/caseErpInstoreLog/deviation-analysis',
  Contract = '/caseErpStock/caseErpInstoreLog/contract-management',
}

/**
 * @description: 基础数据
 */
export async function getDataInfo(mode: ErrorMessageMode = 'modal') {
  return defHttp.get(
    {
      url: Api.Data,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 查询原材料采购价格环比
 */
export async function getPriceInfo(mode: ErrorMessageMode = 'modal') {
  return defHttp.get(
    {
      url: Api.Price,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 查询供应链趋势
 */
export async function getTrendInfo(mode: ErrorMessageMode = 'modal') {
  return defHttp.get(
    {
      url: Api.Trend,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 查询采购合同类型占比
 */
export async function getTypeInfo(mode: ErrorMessageMode = 'modal') {
  return defHttp.get(
    {
      url: Api.Type,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 查询采购成本分析
 */
export async function getCostInfo(mode: ErrorMessageMode = 'modal') {
  return defHttp.get(
    {
      url: Api.Cost,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 查询本年采购价格偏差分析
 */
export async function getDeviationInfo(mode: ErrorMessageMode = 'modal') {
  return defHttp.get(
    {
      url: Api.Deviation,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 查询采购合同管理
 */
export async function getContractInfo(mode: ErrorMessageMode = 'modal') {
  return defHttp.get(
    {
      url: Api.Contract,
    },
    {
      errorMessageMode: mode,
    },
  );
}
