import { computed, defineAsyncComponent, onMounted, ref } from 'vue';
import { storeToRefs } from 'pinia';
import { useRuleProcessStore } from '../store';
import { NodeNameByType } from '../config';
import { Edge, useVueFlow } from '@vue-flow/core';
import { RuleProcessNodeKey } from '/@/model/ruleProcessConfig';
export default function () {
  const StartNodePanel = defineAsyncComponent(() => import('./../panel/StartNode.vue'));
  const BasicNodePanel = defineAsyncComponent(() => import('./../panel/BasicNode.vue'));
  const EventNodePanel = defineAsyncComponent(() => import('./../panel/EventNode.vue'));
  const SelectNodePanel = defineAsyncComponent(() => import('./../panel/SelectNode.vue'));
  const RuleNodePanel = defineAsyncComponent(() => import('./../panel/RuleNode.vue'));
  const CycleNodePanel = defineAsyncComponent(() => import('./../panel/CycleNode.vue'));
  const WhileNodePanel = defineAsyncComponent(() => import('./../panel/WhileNode.vue'));
  const ConditionNodePanel = defineAsyncComponent(() => import('./../panel/ConditionNode.vue'));
  const DevOpsNodePanel = defineAsyncComponent(() => import('./../panel/DevOpsNode.vue'));
  const componentByType: Map<RuleProcessNodeKey, any> = new Map([
    [RuleProcessNodeKey.START_NODE, StartNodePanel],
    [RuleProcessNodeKey.EVENT_NODE, EventNodePanel],
    [RuleProcessNodeKey.RULE_NODE, RuleNodePanel],
    [RuleProcessNodeKey.SELECT_NODE, SelectNodePanel],
    [RuleProcessNodeKey.CONDITION_NODE, ConditionNodePanel],
    [RuleProcessNodeKey.FOR_NODE, CycleNodePanel],
    [RuleProcessNodeKey.WHILE_NODE, WhileNodePanel],
    [RuleProcessNodeKey.DEV_OPS_NODE, DevOpsNodePanel],
  ]);

  //
  const iconByType: Map<RuleProcessNodeKey, string> = new Map([
    [RuleProcessNodeKey.START_NODE, 'rule-icon-start'],
    [RuleProcessNodeKey.EVENT_NODE, 'rule-icon-event'],
    [RuleProcessNodeKey.RULE_NODE, 'rule-icon-rule'],
    [RuleProcessNodeKey.SELECT_NODE, 'rule-icon-select'],
    [RuleProcessNodeKey.CONDITION_NODE, 'rule-icon-if'],
    [RuleProcessNodeKey.FOR_NODE, 'rule-icon-for'],
    [RuleProcessNodeKey.WHILE_NODE, 'rule-icon-while'],
    [RuleProcessNodeKey.DEV_OPS_NODE, 'rule-icon-fuwuqi'],
  ]);
  const store = useRuleProcessStore();
  const { infoId } = store;
  const { info } = storeToRefs(store);
  const showPanel = ref(false);
  const formInfo = ref();

  const { updateNode } = useVueFlow();
  function updateElementName() {
    updateNode(formInfo.value.id, { data: { ...formInfo.value, label: formInfo.value.label } });
  }
  onMounted(() => {
    if (infoId) {
      formInfo.value = info.value.get(infoId);
      showPanel.value = true;
    }
  });
  const nodeType = computed(() => {
    return formInfo.value.type;
  });
  const componentName = computed(() => {
    return componentByType.has(nodeType.value)
      ? componentByType.get(nodeType.value)
      : BasicNodePanel;
  });

  const nodeName = computed(() => {
    if (formInfo.value && formInfo.value.type) {
      const labelName = NodeNameByType.has(formInfo.value.type)
        ? NodeNameByType.get(formInfo.value.type)
        : '节点';
      return labelName;
    }
    return '节点';
  });

  const nodeIcon = computed(() => {
    if (formInfo.value && formInfo.value.type) {
      const labelName = iconByType.has(formInfo.value.type)
        ? iconByType.get(formInfo.value.type)
        : 'rule-icon-start';
      return labelName;
    }
    return 'rule-icon-start';
  });
  function getNextEdges() {
    const { toObject } = useVueFlow();
    let edgesArr: Edge[] = [];
    const demoVal = toObject();
    if (demoVal.edges && demoVal.edges.length > 0) {
      edgesArr = demoVal.edges.filter((ele) => {
        ele.label = ele.data.label;
        return ele.target == infoId;
      });
    }

    return edgesArr;
  }
  return {
    formInfo,
    nodeName,
    nodeType,
    nodeIcon,
    showPanel,
    updateElementName,
    getNextEdges,
    componentName,
  };
}
