import { FormProps, FormSchema } from '/@/components/Form';
import { BasicColumn } from '/@/components/Table';

export const searchFormSchema: FormSchema[] = [
  {
    field: 'dataDate',
    label: '日期',
    component: 'RangePicker',
    componentProps: {
      format: 'YYYY-MM-DD',
      style: { width: '100%' },
      getPopupContainer: () => document.body,
    },
    colProps: { span: 8 },
  },

  {
    field: 'keyword',
    label: '',
    component: 'Input',
    componentProps: {
      pplaceholder: '请输入产品编码或名称',
    },
    colProps: { span: 8 },
  },
];

export const columns: BasicColumn[] = [
  {
    dataIndex: 'materialNo',
    title: '缺陷产品编码',
    componentType: 'date',

    sorter: true,
  },

  {
    dataIndex: 'materialName',
    title: '缺陷产品名称',
    componentType: 'input',

    sorter: true,
  },

  {
    dataIndex: 'planNum',
    title: '缺陷类型',
    componentType: 'select',

    sorter: true,
  },
  {
    dataIndex: 'realNum',
    title: '产品名称',
    componentType: 'select',

    sorter: true,
  },
  {
    dataIndex: 'samplingNum',
    title: '产品型号',
    componentType: 'input',
    sorter: true,
    align: 'right',
  },
  {
    dataIndex: 'errorNum',
    title: '产品分类',
    componentType: 'user',

    sorter: true,
  },

  {
    dataIndex: 'errorRate',
    title: '缺陷产品数量',
    componentType: 'textarea',

    sorter: true,
  },
];
