import { FormProps, FormSchema } from '/@/components/Form';
import { BasicColumn } from '/@/components/Table';

export const searchFormSchema: FormSchema[] = [
  {
    field: 'code',
    label: '仓库类型编号',
    component: 'Input',
    colProps: { span: 8 },
  },
  {
    field: 'name',
    label: '仓库类型名称',
    component: 'Input',
    colProps: { span: 8 },
  },
  {
    field: 'state',
    label: '类型状态',
    component: 'Select',
    componentProps: {
      getPopupContainer: () => document.body,
      options: [
        {
          label: '开',
          value: 1,
        },
        {
          label: '关',
          value: 0,
        },
      ],
    },
    colProps: { span: 8 },
  },
];

export const columns: BasicColumn[] = [
  {
    dataIndex: 'code',
    title: '仓库类型编号',
    componentType: 'input',

    sorter: true,
  },

  {
    dataIndex: 'name',
    title: '仓库类型名称',
    componentType: 'input',

    sorter: true,
  },

  {
    dataIndex: 'state',
    title: '类型状态',
    componentType: 'switch',

    sorter: true,
  },

  {
    dataIndex: 'remark',
    title: '备注',
    componentType: 'textarea',

    sorter: true,
  },

  {
    dataIndex: 'createDate',
    title: '创建时间',
    componentType: 'info',

    sorter: true,
  },

  {
    dataIndex: 'createUserId',
    title: '创建人',
    componentType: 'info',

    sorter: true,
  },
];

export const formProps: FormProps = {
  labelCol: { span: 4, offset: 0 },
  labelAlign: 'right',
  layout: 'horizontal',
  size: 'default',
  schemas: [
    {
      key: '05429955382d4ba9b40372535052b79e',
      field: 'code',
      label: '仓库类型编号',
      type: 'input',
      component: 'Input',
      colProps: { span: 24 },
      defaultValue: '',
      componentProps: {
        width: '100%',
        span: '',
        defaultValue: '',
        placeholder: '请输入',
        maxlength: 200,
        prefix: '',
        suffix: '',
        addonBefore: '',
        addonAfter: '',
        disabled: false,
        allowClear: false,
        showLabel: true,
        required: true,
        rules: [],
        events: {},
        style: { width: '100%' },
      },
    },
    {
      key: '794ffc026024457eae768e0f0a1c3a5e',
      field: 'name',
      label: '仓库类型名称',
      type: 'input',
      component: 'Input',
      colProps: { span: 24 },
      defaultValue: '',
      componentProps: {
        width: '100%',
        span: '',
        defaultValue: '',
        placeholder: '请输入',
        maxlength: 200,
        prefix: '',
        suffix: '',
        addonBefore: '',
        addonAfter: '',
        disabled: false,
        allowClear: false,
        showLabel: true,
        required: true,
        rules: [],
        events: {},
        style: { width: '100%' },
      },
    },
    {
      key: 'b28bd69fed234ec9a4d1cb1e35d50f53',
      field: 'sort',
      label: '类型排序',
      type: 'number',
      component: 'InputNumber',
      colProps: { span: 24 },
      defaultValue: 0,
      componentProps: {
        width: '100%',
        span: '',
        defaultValue: 0,
        min: 0,
        //max: 100,
        step: 1,
        maxlength: null,
        disabled: false,
        showLabel: true,
        controls: true,
        required: false,
        subTotal: false,
        rules: [],
        events: {},
        style: { width: '100%' },
      },
    },
    {
      key: '894a09006adc4b90af5455a55fc8ec70',
      field: 'state',
      label: '类型状态',
      type: 'switch',
      component: 'Switch',
      colProps: { span: 24 },
      defaultValue: 1,
      componentProps: {
        span: '',
        defaultValue: 1,
        checkedChildren: '',
        unCheckedChildren: '',
        checkedColor: '#5e95ff',
        unCheckedColor: '#bbbdbf',
        showLabel: true,
        disabled: false,
        events: {},
        style: {},
      },
    },
    {
      key: '6361ce6efbe6404abf5fd3fb84c4145e',
      field: 'remark',
      label: '备注',
      type: 'textarea',
      component: 'InputTextArea',
      colProps: { span: 24 },
      defaultValue: '',
      componentProps: {
        width: '100%',
        span: '',
        defaultValue: '',
        placeholder: '请输入',
        maxlength: null,
        rows: 4,
        autoSize: false,
        showCount: false,
        disabled: false,
        showLabel: true,
        allowClear: false,
        required: false,
        rules: [],
        events: {},
        style: { width: '100%' },
      },
    },
    // {
    //   key: '7a4c7dcae4864d6983d71dd92d19a772',
    //   field: 'createUserId',
    //   label: '创建人',
    //   type: 'info',
    //   component: 'Info',
    //   colProps: { span: 24 },
    //   componentProps: {
    //     span: '',
    //     width: '100%',
    //     placeholder: '',
    //     infoType: 0,
    //     loadAgain: false,
    //     showLabel: true,
    //     disabled: true,
    //     style: { width: '100%' },
    //   },
    // },
    // {
    //   key: '0ae882a4256f4839b453f3c55bf2262a',
    //   field: 'createDate',
    //   label: '创建时间',
    //   type: 'info',
    //   component: 'Info',
    //   colProps: { span: 24 },
    //   componentProps: {
    //     span: '',
    //     width: '100%',
    //     placeholder: '',
    //     infoType: 2,
    //     loadAgain: false,
    //     showLabel: true,
    //     disabled: true,
    //     style: { width: '100%' },
    //   },
    // },
  ],
  showActionButtonGroup: false,
  buttonLocation: 'center',
  actionColOptions: { span: 24 },
  showResetButton: false,
  showSubmitButton: false,
  hiddenComponent: [],
};
