import { requestMagicApi } from '/@/api/magicApi';
import { useUserStore } from '/@/store/modules/user';
import { dataFromType } from '/@/views/system/pagedesign/types';

export async function apiConfigPageDesignFunc(apiConfig, formModel) {
  if (!apiConfig?.path) return [];
  const queryParam = {};
  const headerParam = {};
  const bodyParam = {};
  if (apiConfig?.apiParams) {
    for (const param of apiConfig.apiParams) {
      //queryString
      if (param.key === '1' && param.tableInfo && param.tableInfo.length) {
        for (const query of param.tableInfo) {
          queryParam[query.name] = getRequestData(query, formModel);
        }
      }
      //header
      if (param.key === '2' && param.tableInfo && param.tableInfo.length) {
        for (const head of param.tableInfo) {
          headerParam[head.name] = getRequestData(head, formModel, true);
        }
      }
      //body
      if (param.key === '3' && param.tableInfo && param.tableInfo.length) {
        for (const body of param.tableInfo) {
          bodyParam[body.name] = getRequestData(body, formModel);
          console.log('formModel', formModel, bodyParam);
        }
      }
    }
  }

  const res = await requestMagicApi({
    method: apiConfig?.method,
    url: apiConfig.path,
    headers: headerParam,
    body: bodyParam,
    query: queryParam,
  });
  if (res && Array.isArray(res)) return res; //不分页接口
  if (res && Array.isArray(res.list)) {
    return res.list;
  } //分页接口
  return res;
}

export function getRequestData(
  element,
  widgetFormModel,
  isHeaders: Boolean = false,
  bindType = 'bindType',
) {
  if (element[bindType] == dataFromType.table) {
    const el = JSON.parse(element.value);
    if (el && widgetFormModel && widgetFormModel[el.parentKey]) {
      const val = widgetFormModel[el.parentKey][el.dataIndex];
      return val;
    } else {
      return '';
    }
  }
  if (element[bindType] == dataFromType.search) {
    const el = JSON.parse(element.value);

    if (el && widgetFormModel && widgetFormModel[el.parentKey]) {
      const val = widgetFormModel[el.parentKey][el.bindField];
      return val;
    } else {
      return '';
    }
  }
  if (element[bindType] == dataFromType.info) {
    const userStore = useUserStore();
    return isHeaders
      ? encodeURIComponent(userStore.getUserInfo[element.value])
      : userStore.getUserInfo[element.value];
  }
  if (element[bindType] == dataFromType.tree) {
    const el = JSON.parse(element.value);
    if (el && widgetFormModel && widgetFormModel[el.parentKey]) {
      const val = widgetFormModel[el.parentKey][el.value];
      return Array.isArray(val) ? val.join(',') : val;
    } else {
      return '';
    }
  }
  if (element[bindType] == dataFromType.form) {
    const el = JSON.parse(element.value);

    if (el && widgetFormModel && widgetFormModel[el.parentKey]) {
      const val = widgetFormModel[el.parentKey][el.bindField];
      return val;
    } else {
      return '';
    }
  }
  return element.value;
}
