import 'virtual:windi-base.css';
import 'virtual:windi-components.css';
import 'virtual:windi-utilities.css';
// Register icon sprite
import 'virtual:svg-icons-register';
import App from './App.vue';
import { createApp } from 'vue';
import { initAppConfigStore } from '/@/logics/initAppConfig';
import { setupErrorHandle } from '/@/logics/error-handle';
import { router, setupRouter } from '/@/router';
import { setupRouterGuard } from '/@/router/guard';
import { setupStore } from '/@/store';
import { setupGlobDirectives } from '/@/directives';
import { setupI18n } from '/@/locales/setupI18n';
import { registerGlobComp } from '/@/components/registerGlobComp';
import axios from 'axios';
import VueGridLayout from 'vue-grid-layout';
import Antd from 'ant-design-vue';
import { Modal } from 'ant-design-vue';
import 'ant-design-vue/dist/antd.less';
import '/@/design/index.less';
//如果需要使用葡萄城报表   放开代码注释
// import { Core } from '@grapecity/activereports';

async function bootstrap() {
  const app = createApp(App);
  // Configure store
  // 配置 store
  setupStore(app);

  // Initialize internal system configuration
  // 初始化内部系统配置
  initAppConfigStore();

  // Register global components
  // 注册全局组件
  registerGlobComp(app);

  // Multilingual configuration
  // 多语言配置
  // Asynchronous case: language files may be obtained from the server side
  // 异步案例：语言文件可能从服务器端获取
  await setupI18n(app);

  // Configure routing
  // 配置路由
  setupRouter(app);

  // router-guard
  // 路由守卫
  setupRouterGuard(router);

  // Register global directive
  // 注册全局指令
  setupGlobDirectives(app);

  // Configure global error handling
  // 配置全局错误处理
  setupErrorHandle(app);

  //keycloak
  // setupKeycloak(app);

  //全局挂载axios
  app.config.globalProperties.$axios = axios;
  //取消点击esc关闭弹窗
  Modal.props.keyboard.default = false;

  // https://next.router.vuejs.org/api/#isready
  // await router.isReady();
  app.use(Antd);

  app.use(VueGridLayout);

  //如果需要使用葡萄城报表   放开代码注释
  //这里是viewer的key
  //详情参考 ：https://demo.grapecity.com.cn/activereportsjs/docs/GettingStarted/Licensing
  // Core.setLicenseKey('YOUR LICENSE KEY GOES HERE');

  app.mount('#app');
}

bootstrap();
