import {
  StoreAppPageParams,
  StoreManagePageModel,
  StoreManagePageParams,
  StoreManagePageResult,
} from './model/StoreManageModel';
import { defHttp } from '/@/utils/http/axios';
import { ErrorMessageMode } from '/#/axios';

enum Api {
  Page = '/version/storemanage/page',
  List = '/version/storemanage/list',
  Info = '/version/storemanage/info',
  StoreManage = '/version/storemanage',
  AppList = '/version/app-store/page',
  AppDowload = '/version/app-store/download',
}

/**
 * @description: 查询StoreManage分页列表
 */
export async function getStoreManagePage(
  params: StoreManagePageParams,
  mode: ErrorMessageMode = 'modal',
) {
  return defHttp.get<StoreManagePageResult>(
    {
      url: Api.Page,
      params,
    },
    {
      errorMessageMode: mode,
    },
  );
}
/**
 * @description: 查询应用分页列表
 */
export async function getAppListPage(params: StoreAppPageParams, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<{ data: StoreManagePageResult }>(
    {
      url: Api.AppList,
      params,
    },
    {
      errorMessageMode: mode,
    },
  );
}
/**
 * @description: 下载应用
 */
export async function postAppDowload(params, mode: ErrorMessageMode = 'modal') {
  return defHttp.post(
    {
      url: Api.AppDowload,
      params,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 查询StoreManage不分页列表
 */
export async function getStoreManageList(mode: ErrorMessageMode = 'modal') {
  return defHttp.get<Array<StoreManagePageModel>>(
    {
      url: Api.List,
    },
    {
      errorMessageMode: mode,
    },
  );
}
/**
 * @description: 获取StoreManage信息
 */
export async function getStoreManage(id: String, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<StoreManagePageModel>(
    {
      url: Api.Info,
      params: { id },
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 新增StoreManage
 */
export async function addStoreManage(storeManage: Recordable, mode: ErrorMessageMode = 'modal') {
  return defHttp.post<boolean>(
    {
      url: Api.StoreManage,
      params: storeManage,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 更新StoreManage
 */
export async function updateStoreManage(storeManage: Recordable, mode: ErrorMessageMode = 'modal') {
  return defHttp.put<boolean>(
    {
      url: Api.StoreManage,
      params: storeManage,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 删除StoreManage（批量删除）
 */
export async function deleteStoreManage(ids: string[], mode: ErrorMessageMode = 'modal') {
  return defHttp.delete<boolean>(
    {
      url: Api.StoreManage,
      data: ids,
    },
    {
      errorMessageMode: mode,
    },
  );
}
