import { OperationType } from '/@/enums/workflowEnum';

export interface OperationManagementListModel {
  id?: string; // 主键
  code: string;
  configJson?: string;
  name: string;
  remark: string;
}
export interface OperationManagementParamItem {
  id: number | string;
  name: string;
  type: OperationType;
  value: string;
  apiConfig: {
    id: string;
    name: string;
    method: string;
    requestParamsConfigs: Array<InputParamItem>; //Query Params 输入参数
    requestHeaderConfigs: Array<InputParamItem>; //Header 输入参数
    requestBodyConfigs: Array<InputParamItem>; //Body 输入参数
  };
}

export interface InputParamItem {
  name: string; //API入参名称
  dataType: string; //API入参类型
  assignmentType: string; //赋值类型
  value: string; //值
  config: string; //赋值配置
}

export interface OperationManagementToRule {
  id: string;
  name: string;
  configs: Array<OperationManagementToRuleItem>;
}
export interface OperationManagementToRuleItem {
  name: string; //变量名称
  type: string; //变量类型
  value: string; //值
}

// 参数类型
export enum OperationManagementToRuleType {
  VALUE = 0, //值
  RULE, //规则流程变量
  API, //APi
}
