import { MesProGroupModel, MesProGroupPageParams, MesProGroupPageResult } from './model/MesProGroupModel';
import { defHttp } from '/@/utils/http/axios';
import { ErrorMessageMode } from '/#/axios';

enum Api {
  Page = '/mes/mesprogroup/page',
  List = '/mes/mesprogroup/list',
  Info = '/mes/mesprogroup/info',
  MesProGroup = '/mes/mesprogroup',
  
  
}

/**
 * @description: 查询MesProGroup分页列表
 */
export async function getMesProGroupPage(params: MesProGroupPageParams, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<MesProGroupPageResult>(
    {
      url: Api.Page,
      params,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 获取MesProGroup信息
 */
export async function getMesProGroup(id: String, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<MesProGroupModel>(
    {
      url: Api.Info,
      params: { id },
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 新增MesProGroup
 */
export async function addMesProGroup(mesProGroup: Recordable, mode: ErrorMessageMode = 'modal') {
  return defHttp.post<boolean>(
    {
      url: Api.MesProGroup,
      params: mesProGroup,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 更新MesProGroup
 */
export async function updateMesProGroup(mesProGroup: Recordable, mode: ErrorMessageMode = 'modal') {
  return defHttp.put<boolean>(
    {
      url: Api.MesProGroup,
      params: mesProGroup,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 删除MesProGroup（批量删除）
 */
export async function deleteMesProGroup(ids: string[], mode: ErrorMessageMode = 'modal') {
  return defHttp.delete<boolean>(
    {
      url: Api.MesProGroup,
      data: ids,
    },
    {
      errorMessageMode: mode,
    },
  );
}