import { MesQlIncheckreportModel, MesQlIncheckreportPageParams, MesQlIncheckreportPageResult } from './model/MesIncheckreportModel';
import { defHttp } from '/@/utils/http/axios';
import { ErrorMessageMode } from '/#/axios';

enum Api {
  Page = '/mes/mesincheckreport/page',
  List = '/mes/mesincheckreport/list',
  Info = '/mes/mesincheckreport/info',
  MesQlIncheckreport = '/mes/mesincheckreport',
  
  
}

/**
 * @description: 查询MesQlIncheckreport分页列表
 */
export async function getMesQlIncheckreportPage(params: MesQlIncheckreportPageParams, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<MesQlIncheckreportPageResult>(
    {
      url: Api.Page,
      params,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 获取MesQlIncheckreport信息
 */
export async function getMesQlIncheckreport(id: String, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<MesQlIncheckreportModel>(
    {
      url: Api.Info,
      params: { id },
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 新增MesQlIncheckreport
 */
export async function addMesQlIncheckreport(mesQlIncheckreport: Recordable, mode: ErrorMessageMode = 'modal') {
  return defHttp.post<boolean>(
    {
      url: Api.MesQlIncheckreport,
      params: mesQlIncheckreport,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 更新MesQlIncheckreport
 */
export async function updateMesQlIncheckreport(mesQlIncheckreport: Recordable, mode: ErrorMessageMode = 'modal') {
  return defHttp.put<boolean>(
    {
      url: Api.MesQlIncheckreport,
      params: mesQlIncheckreport,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 删除MesQlIncheckreport（批量删除）
 */
export async function deleteMesQlIncheckreport(ids: string[], mode: ErrorMessageMode = 'modal') {
  return defHttp.delete<boolean>(
    {
      url: Api.MesQlIncheckreport,
      data: ids,
    },
    {
      errorMessageMode: mode,
    },
  );
}