import { BasicPageParams, BasicFetchResult } from '/@/api/model/baseModel';

/**
 * @description: MesDevRepair分页参数 模型
 */
export interface MesDevRepairPageParams extends BasicPageParams {
  state: string;

  errorTime: string;

  repairCode: string;

  devCode: string;

  devName: string;

  devType: string;
}

/**
 * @description: MesDevRepair分页返回值模型
 */
export interface MesDevRepairPageModel {
  id: string;

  repairCode: string;

  devCode: string;

  devName: string;

  state: string;

  devManage: string;

  errorTime: string;

  errorRemark: string;

  repairRemark: string;

  createUserId: string;

  createDate: string;
}

/**
 * @description: MesDevRepair表类型
 */
export interface MesDevRepairModel {
  id: number;

  repairCode: string;

  devId: string;

  devCode: string;

  devName: string;

  devType: string;

  devPhone: string;

  devManage: string;

  errorTime: string;

  urgency: string;

  state: string;

  errorRemark: string;

  errorFile: string;

  errorFile2: string;

  repairUser: string;

  repairDate: string;

  repairStarttime: string;

  repairEndtime: string;

  repairDuration: string;

  repairErrorRmk: string;

  repairRemark: string;

  repairFile: string;

  sort: number;

  createUserId: number;

  createDate: string;

  modifyUserId: number;

  modifyDate: string;

  deleteMark: number;

  enabledMark: number;
}

/**
 * @description: MesDevRepair分页返回值结构
 */
export type MesDevRepairPageResult = BasicFetchResult<MesDevRepairPageModel>;