import { MesDevModel, MesDevPageParams, MesDevPageResult } from './model/DevDataModel';
import { defHttp } from '/@/utils/http/axios';
import { ErrorMessageMode } from '/#/axios';

enum Api {
  Page = '/mes/devdata/page',
  List = '/mes/devdata/list',
  Info = '/mes/devdata/info',
  MesDev = '/mes/devdata',

  Export = '/mes/devdata/export',
}

/**
 * @description: 查询MesDev分页列表
 */
export async function getMesDevPage(params: MesDevPageParams, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<MesDevPageResult>(
    {
      url: Api.Page,
      params,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 获取MesDev信息
 */
export async function getMesDev(id: String, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<MesDevModel>(
    {
      url: Api.Info,
      params: { id },
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 新增MesDev
 */
export async function addMesDev(mesDev: Recordable, mode: ErrorMessageMode = 'modal') {
  return defHttp.post<boolean>(
    {
      url: Api.MesDev,
      params: mesDev,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 更新MesDev
 */
export async function updateMesDev(mesDev: Recordable, mode: ErrorMessageMode = 'modal') {
  return defHttp.put<boolean>(
    {
      url: Api.MesDev,
      params: mesDev,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 删除MesDev（批量删除）
 */
export async function deleteMesDev(ids: string[], mode: ErrorMessageMode = 'modal') {
  return defHttp.delete<boolean>(
    {
      url: Api.MesDev,
      data: ids,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 导出MesDev
 */
export async function exportMesDev(params?: object, mode: ErrorMessageMode = 'modal') {
  return defHttp.download(
    {
      url: Api.Export,
      method: 'GET',
      params,
      responseType: 'blob',
    },
    {
      errorMessageMode: mode,
    },
  );
}
