import {
  MesBaseFactoryModel,
  MesBaseFactoryPageParams,
  MesBaseFactoryPageResult,
} from './model/BaseFactoryModel';
import { defHttp } from '/@/utils/http/axios';
import { ErrorMessageMode } from '/#/axios';

enum Api {
  Page = '/mes/basefactory/page',
  List = '/mes/basefactory/list',
  Info = '/mes/basefactory/info',
  MesBaseFactory = '/mes/basefactory',

  Export = '/mes/basefactory/export',
}

/**
 * @description: 查询MesBaseFactory分页列表
 */
export async function getMesBaseFactoryPage(
  params: MesBaseFactoryPageParams,
  mode: ErrorMessageMode = 'modal',
) {
  return defHttp.get<MesBaseFactoryPageResult>(
    {
      url: Api.Page,
      params,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 获取MesBaseFactory信息
 */
export async function getMesBaseFactory(id: String, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<MesBaseFactoryModel>(
    {
      url: Api.Info,
      params: { id },
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 新增MesBaseFactory
 */
export async function addMesBaseFactory(
  mesBaseFactory: Recordable,
  mode: ErrorMessageMode = 'modal',
) {
  return defHttp.post<boolean>(
    {
      url: Api.MesBaseFactory,
      params: mesBaseFactory,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 更新MesBaseFactory
 */
export async function updateMesBaseFactory(
  mesBaseFactory: Recordable,
  mode: ErrorMessageMode = 'modal',
) {
  return defHttp.put<boolean>(
    {
      url: Api.MesBaseFactory,
      params: mesBaseFactory,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 删除MesBaseFactory（批量删除）
 */
export async function deleteMesBaseFactory(ids: string[], mode: ErrorMessageMode = 'modal') {
  return defHttp.delete<boolean>(
    {
      url: Api.MesBaseFactory,
      data: ids,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 导出MesBaseFactory
 */
export async function exportMesBaseFactory(params?: object, mode: ErrorMessageMode = 'modal') {
  return defHttp.download(
    {
      url: Api.Export,
      method: 'GET',
      params,
      responseType: 'blob',
    },
    {
      errorMessageMode: mode,
    },
  );
}
