import {
  MesBaseAreatypeModel,
  MesBaseAreatypePageParams,
  MesBaseAreatypePageResult,
} from './model/BaseAreatypeModel';
import { defHttp } from '/@/utils/http/axios';
import { ErrorMessageMode } from '/#/axios';

enum Api {
  Page = '/mes/baseareatype/page',
  List = '/mes/baseareatype/list',
  Info = '/mes/baseareatype/info',
  MesBaseAreatype = '/mes/baseareatype',

  Export = '/mes/baseareatype/export',
}

/**
 * @description: 查询MesBaseAreatype分页列表
 */
export async function getMesBaseAreatypePage(
  params: MesBaseAreatypePageParams,
  mode: ErrorMessageMode = 'modal',
) {
  return defHttp.get<MesBaseAreatypePageResult>(
    {
      url: Api.Page,
      params,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 获取MesBaseAreatype信息
 */
export async function getMesBaseAreatype(id: String, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<MesBaseAreatypeModel>(
    {
      url: Api.Info,
      params: { id },
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 新增MesBaseAreatype
 */
export async function addMesBaseAreatype(
  mesBaseAreatype: Recordable,
  mode: ErrorMessageMode = 'modal',
) {
  return defHttp.post<boolean>(
    {
      url: Api.MesBaseAreatype,
      params: mesBaseAreatype,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 更新MesBaseAreatype
 */
export async function updateMesBaseAreatype(
  mesBaseAreatype: Recordable,
  mode: ErrorMessageMode = 'modal',
) {
  return defHttp.put<boolean>(
    {
      url: Api.MesBaseAreatype,
      params: mesBaseAreatype,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 删除MesBaseAreatype（批量删除）
 */
export async function deleteMesBaseAreatype(ids: string[], mode: ErrorMessageMode = 'modal') {
  return defHttp.delete<boolean>(
    {
      url: Api.MesBaseAreatype,
      data: ids,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 导出MesBaseAreatype
 */
export async function exportMesBaseAreatype(params?: object, mode: ErrorMessageMode = 'modal') {
  return defHttp.download(
    {
      url: Api.Export,
      method: 'GET',
      params,
      responseType: 'blob',
    },
    {
      errorMessageMode: mode,
    },
  );
}
