import { BasicPageParams, BasicFetchResult } from '/@/api/model/baseModel';

export interface DevicePageListParams {
  typeId?: string; //设备类型id
  name?: string; //设备名称
  address?: string; //设备位置
}

export interface DeviceAddParamsModel {
  typeId: string; //设备类型id
  number: string; //设备编号
  name: string; //设备名称
  model: string; //规格型号
  supplierId?: string; //供应商
  buyDate?: string; //购买日期
  maintainDate: string; //维保日期
  scrapDate: string; //报废日期
  principalIds: string; //负责人id
  address?: string; //设备位置
}

export interface DeviceUpdateParamsModel {
  id: string; //详情id
  typeId: string; //设备类型id
  number: string; //设备编号
  name: string; //设备名称
  model: string; //规格型号
  supplierId?: string; //供应商
  buyDate?: string; //购买日期
  maintainDate: string; //维保日期
  scrapDate: string; //报废日期
  principalIds: string; //负责人id
  address?: string; //设备位置
}

export interface DeviceListModel {
  id: string; //详情id
  number: string; //设备编号
  name: string; //设备名称
  typeName: string; //设备类型
  supplierName: number; //供应商
  address: string; //设备位置
  model: string; //规格型号
  principalNames: string; //负责人
  buyDate: string; //购买日期
  maintianDate: string; //维保日期0
  scrapDate: string; //报废日期
  state: number; //状态 0-异常 1-正常
}

export type DevicePageListSearchModel = BasicPageParams & DevicePageListParams;
export type DevicePageListResultModel = BasicFetchResult<DeviceListModel>;
