import { FormProps, FormSchema } from '/@/components/Form';
import { BasicColumn } from '/@/components/Table';

export const searchFormSchema: FormSchema[] = [
  {
    field: 'scheNo',
    label: '编码',
    component: 'Input',
    colProps: { span: 8 },
  },
  {
    field: 'scheName',
    label: '名称',
    component: 'Input',
    colProps: { span: 8 },
  },
  {
    field: 'publishState',
    label: '发布状态',
    component: 'XjrSelect',
    componentProps: {
      datasourceType: 'staticData',
      staticOptions: [
        { key: 1, label: '未发布', value: '0' },
        { key: 2, label: '已发布', value: '1' },
      ],
      labelField: 'label',
      valueField: 'value',

      getPopupContainer: () => document.body,
    },
    colProps: { span: 8 },
  },
  // {
  //   field: 'finishState',
  //   label: '完成状态',
  //   component: 'XjrSelect',
  //   componentProps: {
  //     datasourceType: 'staticData',
  //     staticOptions: [
  //       { key: 1, label: '', value: '' },
  //       { key: 2, label: '未完成', value: '0' },
  //       { key: 3, label: '已完成', value: '1' },
  //     ],
  //     labelField: 'label',
  //     valueField: 'value',

  //     getPopupContainer: () => document.body,
  //   },
  //   colProps: { span: 8 },
  // },
  {
    field: 'createDate',
    label: '制表日期',
    component: 'RangePicker',
    componentProps: {
      format: 'YYYY-MM-DD HH:mm:ss',
      style: { width: '100%' },
      getPopupContainer: () => document.body,
    },
    colProps: { span: 8 },
  },

  {
    field: 'createUserId',
    label: '制表人',
    component: 'User',
    componentProps: {
      suffix: 'ant-design:setting-outlined',
      placeholder: '请选择',
    },
    colProps: { span: 8 },
  },

  {
    field: 'remark',
    label: '备注',
    component: 'Input',
    colProps: { span: 8 },
  },
];

export const columns: BasicColumn[] = [
  {
    dataIndex: 'scheNo',
    title: '编码',
    componentType: 'auto-code',

    sorter: true,
  },

  {
    dataIndex: 'scheName',
    title: '名称',
    componentType: 'input',

    sorter: true,
  },

  {
    dataIndex: 'createUserId',
    title: '制表人',
    componentType: 'info',

    sorter: true,
  },

  {
    dataIndex: 'createDate',
    title: '制表日期',
    componentType: 'date',
    customRender: ({ record }) => {
      return record.createDateWeek;
    },
    sorter: true,
  },

  {
    dataIndex: 'publishState',
    title: '发布状态',
    componentType: 'select',

    customRender: ({ record }) => {
      const staticOptions = [
        { key: 1, label: '未发布', value: '0' },
        { key: 2, label: '已发布', value: '1' },
      ];
      return staticOptions.filter((x) => x.value === record.publishState)[0]?.label;
    },
    sorter: true,
  },

  // {
  //   dataIndex: 'finishState',
  //   title: '完成状态',
  //   componentType: 'select',

  //   customRender: ({ record }) => {
  //     const staticOptions = [
  //       { key: 1, label: '', value: '' },
  //       { key: 2, label: '未完成', value: '0' },
  //       { key: 3, label: '已完成', value: '1' },
  //     ];
  //     return staticOptions.filter((x) => x.value === record.finishState)[0]?.label;
  //   },
  //   sorter: true,
  // },

  {
    dataIndex: 'remark',
    title: '备注',
    componentType: 'textarea',

    sorter: true,
  },
];

export const formProps: FormProps = {
  labelWidth: '100px',
  labelAlign: 'right',
  layout: 'horizontal',
  size: 'default',
  schemas: [
    {
      key: '76cdde2a0eed4a0da8f7e3a8d8f9e567',
      field: 'scheNo',
      label: '编码',
      type: 'auto-code',
      component: 'AutoCodeRule',
      colProps: { span: 8 },
      ifShow: true,
      componentProps: {
        width: '100%',
        span: '',
        placeholder: '编码编码编码请输入编码',
        prefix: '',
        suffix: '',
        addonBefore: '',
        addonAfter: '',
        showLabel: true,
        autoCodeRule: 'mesProSchedule',
        required: true,
        col: 8,
        style: { width: '100%' },
      },
    },
    {
      key: '19e70128555442318c8e80c4c40315e3',
      field: 'isSysNum',
      label: '',
      type: 'checkbox',
      component: 'ApiCheckboxGroup',
      colProps: { span: 4 },
      ifShow: true,
      componentProps: {
        span: '',
        showLabel: true,
        disabled: false,
        staticOptions: [{ key: 1, label: '用系统编号', value: '1' }],
        datasourceType: 'staticData',
        defaultSelect: '1',
        labelField: 'label',
        valueField: 'value',
        apiConfig: {},
        dicOptions: [],
        required: false,
        rules: [],
        events: {
          change:
            "//是否使用系统编号事件：\nconst code='scheNo';//编码字段名\nif(formModel.isSysNum==1){\n\tformModel[code]=formModel.codeTemp; formActionType.updateSchema({field:code,componentProps: {readonly:true}});\n}else{\n  formModel.codeTemp=formModel[code];\n  formModel[code]='';\nformActionType.updateSchema({field:code,componentProps: {readonly:false}});\n}",
        },
        col: 4,
        style: {},
      },
    },
    {
      key: '90aaa877dd594eda983c64a9a294edbd',
      field: 'scheName',
      label: '名称',
      type: 'input',
      component: 'Input',
      colProps: { span: 24 },
      ifShow: true,
      defaultValue: '',
      componentProps: {
        width: '100%',
        span: '',
        defaultValue: '',
        placeholder: '请输入名称',
        maxlength: null,
        prefix: '',
        suffix: '',
        addonBefore: '',
        addonAfter: '',
        disabled: false,
        allowClear: false,
        showLabel: true,
        required: true,
        rules: [],
        events: {},
        style: { width: '100%' },
      },
    },
    {
      key: 'cd9ff34c334f49838af3249cc74b26e4',
      field: 'createUserId',
      label: '制表人',
      type: 'info',
      component: 'Info',
      colProps: { span: 12 },
      ifShow: true,
      componentProps: {
        span: '',
        width: '100%',
        placeholder: '',
        infoType: 0,
        loadAgain: false,
        showLabel: true,
        disabled: true,
        col: 12,
        style: { width: '100%' },
      },
    },
    {
      key: '13c5c8740dd94e9b9b6e98c3116e23e0',
      field: 'createDate',
      label: '制表日期',
      type: 'date',
      component: 'DatePicker',
      colProps: { span: 12 },
      ifShow: true,
      defaultValue: '',
      componentProps: {
        span: '',
        defaultValue:
          new Date().getFullYear() +
          '-' +
          (new Date().getMonth() + 1 < 10
            ? '0' + (new Date().getMonth() + 1)
            : new Date().getMonth() + 1) +
          '-' +
          (new Date().getDate() < 10 ? '0' + new Date().getDate() : new Date().getDate()),
        width: '100%',
        placeholder: '请选择制表日期',
        format: 'YYYY-MM-DD',
        showLabel: true,
        allowClear: true,
        disabled: false,
        required: true,
        rules: [],
        events: {},
        col: 12,
        style: { width: '100%' },
      },
    },
    {
      key: '1d73f2fdab78463ab138b43f2ce638cf',
      field: 'remark',
      label: '备注',
      type: 'textarea',
      component: 'InputTextArea',
      colProps: { span: 24 },
      ifShow: true,
      defaultValue: '',
      componentProps: {
        width: '100%',
        span: '',
        defaultValue: '',
        placeholder: '请输入备注',
        maxlength: null,
        rows: 4,
        autoSize: false,
        showCount: false,
        disabled: false,
        showLabel: true,
        allowClear: false,
        required: false,
        rules: [],
        events: {},
        style: { width: '100%' },
      },
    },
    {
      key: '18414df732ba476bad7b4f5a43430123',
      field: 'publishState',
      label: '发布状态',
      type: 'select',
      component: 'XjrSelect',
      colProps: { span: 12 },
      ifShow: false,
      componentProps: {
        width: '100%',
        span: '',
        placeholder: '请选择',
        showLabel: true,
        showSearch: false,
        clearable: false,
        disabled: false,
        staticOptions: [
          { key: 1, label: '未发布', value: '0' },
          { key: 2, label: '已发布', value: '1' },
        ],
        defaultSelect: '0',
        datasourceType: 'staticData',
        params: null,
        labelField: 'label',
        valueField: 'value',
        apiConfig: {},
        dicOptions: [],
        required: false,
        rules: [],
        events: {},
        col: 12,
        style: { width: '100%' },
      },
    },
    {
      key: 'f23a117e67354492a035a5883e178f88',
      field: 'finishState',
      label: '完成状态',
      type: 'select',
      component: 'XjrSelect',
      colProps: { span: 12 },
      ifShow: false,
      componentProps: {
        width: '100%',
        span: '',
        placeholder: '请选择',
        showLabel: true,
        showSearch: false,
        clearable: false,
        disabled: false,
        staticOptions: [
          { key: 1, label: '', value: '' },
          { key: 2, label: '未完成', value: '0' },
          { key: 3, label: '已完成', value: '1' },
        ],
        defaultSelect: '',
        datasourceType: 'staticData',
        params: null,
        labelField: 'label',
        valueField: 'value',
        apiConfig: {},
        dicOptions: [],
        required: false,
        rules: [],
        events: {},
        col: 12,
        style: { width: '100%' },
      },
    },
  ],
  showActionButtonGroup: false,
  buttonLocation: 'center',
  actionColOptions: { span: 24 },
  showResetButton: false,
  showSubmitButton: false,
  hiddenComponent: [],
};
