import { FormProps, FormSchema } from '/@/components/Form';
import { BasicColumn } from '/@/components/Table';

export const searchFormSchema: FormSchema[] = [
  {
    field: 'groupNo',
    label: '班组编码',
    component: 'Input',
    colProps: { span: 8 },
  },
  {
    field: 'groupName',
    label: '班组名称',
    component: 'Input',
    colProps: { span: 8 },
  },
  {
    field: 'state',
    label: '状态',
    component: 'Select',
    componentProps: {
      getPopupContainer: () => document.body,
      options: [
        {
          label: '开',
          value: 1,
        },
        {
          label: '关',
          value: 0,
        },
      ],
    },
    colProps: { span: 8 },
  },

  {
    field: 'carId',
    label: '所属车间',
    component: 'XjrSelect',
    componentProps: {
      datasourceType: 'api',
      apiConfig: {
        method: 'GET',
        script:
          'var condition="";\r\nif(factory_type!=null&&factory_type!=""){ //0-工厂、1-车间、2产线,3-工位\r\n    condition+=" and factory_type=#{factory_type}";\r\n}\r\nif(factory_id!=null&&factory_id!=""){ \r\n    condition+=" and factory_id=#{factory_id}";\r\n}\r\nif(car_id!=null&&car_id!=""){ \r\n    condition+=" and car_id=#{car_id}";\r\n}\r\nif(parent_id!=null&&parent_id!=""){ \r\n    condition+=" and parent_id=#{parent_id}";\r\n}\r\n\r\nreturn db.select("SELECT id AS `key` ,id AS `value`,CONCAT(factory_code,\'-\',factory_name) AS label FROM mes_base_factory where 1=1 "+condition)',
        apiParams: [
          {
            tableInfo: [
              {
                dataType: 'String',
                bindType: 'value',
                required: false,
                name: 'factory_type',
                value: '1',
              },
              { dataType: 'String', bindType: '', required: false, name: 'factory_id', value: '' },
              { dataType: 'String', bindType: '', required: false, name: 'car_id', value: '' },
              { dataType: 'String', bindType: '', required: false, name: 'parent_id', value: '' },
            ],
            title: 'Query Params',
            key: '1',
          },
          { tableInfo: [], title: 'Header', key: '2' },
          { title: 'Body', key: '3' },
        ],
        path: '/mes/mesFactory',
        apiId: '6b4b40b3db664831b709f56bc98a7f04',
      },
      labelField: 'label',
      valueField: 'value',

      getPopupContainer: () => document.body,
    },
    colProps: { span: 8 },
  },
  {
    field: 'remark',
    label: '备注',
    component: 'Input',
    colProps: { span: 8 },
  },
];

export const columns: BasicColumn[] = [
  {
    dataIndex: 'groupNo',
    title: '班组编码',
    componentType: 'auto-code',

    sorter: true,
  },

  {
    dataIndex: 'groupName',
    title: '班组名称',
    componentType: 'input',

    sorter: true,
  },

  {
    dataIndex: 'leaderUser',
    title: '班组长',
    componentType: 'input',

    sorter: true,
  },

  {
    dataIndex: 'userCount',
    title: '班组人数',
    componentType: 'input',

    sorter: true,
  },

  {
    dataIndex: 'carId',
    title: '所属车间',
    componentType: 'select',

    sorter: true,
  },

  {
    dataIndex: 'lineId',
    title: '所属生产线',
    componentType: 'select',

    sorter: true,
  },

  {
    dataIndex: 'state',
    title: '状态',
    componentType: 'switch',

    sorter: true,
  },

  {
    dataIndex: 'createUserId',
    title: '创建人',
    componentType: 'info',

    sorter: true,
  },

  {
    dataIndex: 'createDate',
    title: '创建时间',
    componentType: 'info',

    sorter: true,
  },

  {
    dataIndex: 'remark',
    title: '备注',
    componentType: 'textarea',

    sorter: true,
  },
];

export const formProps: FormProps = {
  // labelCol: { offset: 0, span: 3 },
  labelWidth: '100px',
  labelAlign: 'right',
  layout: 'horizontal',
  size: 'default',
  schemas: [
    {
      key: '530cf536287f4171b090e4a2b2ea1836',
      field: 'groupNo',
      label: '班组编码',
      type: 'auto-code',
      component: 'AutoCodeRule',
      colProps: { span: 8 },
      componentProps: {
        prefix: '',
        suffix: '',
        addonAfter: '',
        showLabel: true,
        required: true,
        width: '100%',
        placeholder: '请输入班组编码',
        addonBefore: '',
        autoCodeRule: 'mesTeamGroupNo',
        span: '',
        style: { width: '100%' },
      },
    },
    {
      key: 'c4c67d80768c44dd9e90b3abc93f716f',
      field: 'isSysNum',
      label: '',
      type: 'checkbox',
      component: 'ApiCheckboxGroup',
      colProps: { span: 4 },
      componentProps: {
        defaultSelect: '1',
        rules: [],
        valueField: 'value',
        showLabel: false,
        required: false,
        labelField: 'label',
        datasourceType: 'staticData',
        dicOptions: [],
        apiConfig: {},
        disabled: false,
        staticOptions: [{ label: '用系统编码', value: '1', key: 1 }],
        events: {
          change:
            "if(formModel.isSysNum==1){\n\tformModel.groupNo=formModel.groupNo1; formActionType.updateSchema({field:'groupNo'       ,componentProps: {readonly:true}});\n}else{\n  formModel.groupNo1=formModel.groupNo;\n  formModel.groupNo='';\nformActionType.updateSchema({field:'groupNo'       ,componentProps: {readonly:false}});\n}",
        },
        span: '',
        style: {},
      },
    },
    {
      key: '8d24c7db01a7417493cc1facf367ffbf',
      field: 'groupName',
      label: '班组名称',
      type: 'input',
      component: 'Input',
      colProps: { span: 12 },
      defaultValue: '',
      componentProps: {
        defaultValue: '',
        prefix: '',
        rules: [],
        suffix: '',
        addonAfter: '',
        showLabel: true,
        required: true,
        width: '100%',
        disabled: false,
        placeholder: '请输入班组名称',
        allowClear: true,
        addonBefore: '',
        events: {},
        style: { width: '100%' },
      },
    },
    {
      key: '4dd6e2989986405498e11545649c61af',
      field: 'leaderUser',
      label: '班组长',
      type: 'input',
      component: 'Input',
      colProps: { span: 0 },
      defaultValue: '',
      // ifShow: false,
      componentProps: {
        defaultValue: '',
        prefix: '',
        rules: [],
        suffix: '',
        addonAfter: '',
        showLabel: true,
        required: false,
        width: '100%',
        disabled: false,
        placeholder: '请输入班组长',
        allowClear: true,
        addonBefore: '',
        events: {},
        style: { width: '100%' },
      },
    },
    {
      key: '1f4df6e98e0c45958aa5b8dfa452c780',
      field: 'userCount',
      label: '班组人数',
      type: 'input',
      component: 'Input',
      colProps: { span: 0 },
      defaultValue: '',
      // ifShow: false,
      componentProps: {
        defaultValue: '',
        prefix: '',
        rules: [],
        suffix: '',
        addonAfter: '',
        showLabel: true,
        required: false,
        width: '100%',
        disabled: false,
        placeholder: '请输入班组人数',
        allowClear: true,
        addonBefore: '',
        events: {},
        style: { width: '100%' },
      },
    },
    {
      key: 'c32e0976c2264746aefab5943fc62e0a',
      field: 'state',
      label: '状态',
      type: 'switch',
      component: 'Switch',
      colProps: { span: 24 },
      defaultValue: 1,
      componentProps: {
        defaultValue: 1,
        unCheckedChildren: '',
        unCheckedColor: '#bbbdbf',
        checkedChildren: '',
        showLabel: true,
        checkedColor: '#5e95ff',
        disabled: false,
        events: {},
        style: {},
      },
    },
    {
      key: 'f568070f5908450f80005392ca2fd516',
      field: 'carId',
      label: '所属车间',
      type: 'select',
      component: 'XjrSelect',
      colProps: { span: 12 },
      componentProps: {
        clearable: false,
        defaultSelect: '',
        rules: [],
        valueField: 'value',
        showLabel: true,
        required: true,
        labelField: 'label',
        datasourceType: 'api',
        dicOptions: [],
        showSearch: true,
        width: '100%',
        apiConfig: {
          method: 'GET',
          script:
            'var condition="";\r\nif(factory_type!=null&&factory_type!=""){ //0-工厂、1-车间、2产线,3-工位\r\n    condition+=" and factory_type=#{factory_type}";\r\n}\r\nif(factory_id!=null&&factory_id!=""){ \r\n    condition+=" and factory_id=#{factory_id}";\r\n}\r\nif(car_id!=null&&car_id!=""){ \r\n    condition+=" and car_id=#{car_id}";\r\n}\r\nif(parent_id!=null&&parent_id!=""){ \r\n    condition+=" and parent_id=#{parent_id}";\r\n}\r\n\r\nreturn db.select("SELECT id AS `key` ,id AS `value`,CONCAT(factory_code,\'-\',factory_name) AS label FROM mes_base_factory where 1=1 "+condition)',
          apiParams: [
            {
              tableInfo: [
                {
                  dataType: 'String',
                  bindType: 'value',
                  required: false,
                  name: 'factory_type',
                  value: '1',
                },
                {
                  dataType: 'String',
                  bindType: '',
                  required: false,
                  name: 'factory_id',
                  value: '',
                },
                { dataType: 'String', bindType: '', required: false, name: 'car_id', value: '' },
                { dataType: 'String', bindType: '', required: false, name: 'parent_id', value: '' },
              ],
              title: 'Query Params',
              key: '1',
            },
            { tableInfo: [], title: 'Header', key: '2' },
            { title: 'Body', key: '3' },
          ],
          path: '/mes/mesFactory',
          apiId: '6b4b40b3db664831b709f56bc98a7f04',
        },
        disabled: false,
        placeholder: '请选择所属车间',
        staticOptions: [
          { label: 'Option 1', value: 'Option 1', key: 1 },
          { label: 'Option 2', value: 'Option 2', key: 2 },
          { label: 'Option 3', value: 'Option 3', key: 3 },
        ],
        events: { change: "formModel.lineId='';\nformActionType.refreshAPI('lineId')\n" },
        span: '',
        style: { width: '100%' },
      },
    },
    {
      key: '7240fa18189647beb89f5aa8929ee146',
      field: 'lineId',
      label: '所属生产线',
      type: 'select',
      component: 'XjrSelect',
      colProps: { span: 12 },
      componentProps: {
        clearable: false,
        defaultSelect: '',
        rules: [],
        valueField: 'value',
        showLabel: true,
        required: true,
        labelField: 'label',
        datasourceType: 'api',
        dicOptions: [],
        showSearch: true,
        width: '100%',
        apiConfig: {
          method: 'GET',
          script:
            'var condition="";\r\nif(factory_type!=null&&factory_type!=""){ //0-工厂、1-车间、2产线,3-工位\r\n    condition+=" and factory_type=#{factory_type}";\r\n}\r\nif(factory_id!=null&&factory_id!=""){ \r\n    condition+=" and factory_id=#{factory_id}";\r\n}\r\nif(car_id!=null&&car_id!=""){ \r\n    condition+=" and car_id=#{car_id}";\r\n}\r\nif(parent_id!=null&&parent_id!=""){ \r\n    condition+=" and parent_id=#{parent_id}";\r\n}\r\n\r\nreturn db.select("SELECT id AS `key` ,id AS `value`,CONCAT(factory_code,\'-\',factory_name) AS label FROM mes_base_factory where 1=1 "+condition)',
          apiParams: [
            {
              tableInfo: [
                {
                  dataType: 'String',
                  bindType: 'value',
                  required: false,
                  name: 'factory_type',
                  value: '2',
                },
                {
                  dataType: 'String',
                  bindType: '',
                  required: false,
                  name: 'factory_id',
                  value: '',
                },
                {
                  dataType: 'String',
                  bindType: 'data',
                  required: false,
                  name: 'car_id',
                  value: 'car_id',
                },
                { dataType: 'String', bindType: '', required: false, name: 'parent_id', value: '' },
              ],
              title: 'Query Params',
              key: '1',
            },
            { tableInfo: [], title: 'Header', key: '2' },
            { title: 'Body', key: '3' },
          ],
          path: '/mes/mesFactory',
          apiId: '6b4b40b3db664831b709f56bc98a7f04',
        },
        disabled: false,
        placeholder: '请选择所属生产线',
        staticOptions: [
          { label: 'Option 1', value: 'Option 1', key: 1 },
          { label: 'Option 2', value: 'Option 2', key: 2 },
          { label: 'Option 3', value: 'Option 3', key: 3 },
        ],
        events: {},
        span: '',
        style: { width: '100%' },
      },
    },
    {
      key: '8fca7468b7154aeca8a7cb8144ee938c',
      field: 'remark',
      label: '备注',
      type: 'textarea',
      component: 'InputTextArea',
      colProps: { span: 24 },
      defaultValue: '',
      componentProps: {
        defaultValue: '',
        rules: [],
        rows: 4,
        showLabel: true,
        required: false,
        autoSize: false,
        showCount: true,
        width: '100%',
        disabled: false,
        placeholder: '请输入备注',
        allowClear: true,
        events: {},
        span: '',
        style: { width: '100%' },
      },
    },
    {
      key: '90cd2b16823b4000a6200f3537e58760',
      field: 'createUserId',
      label: '创建人',
      type: 'info',
      component: 'Info',
      ifShow: false,
      colProps: { span: 24 },
      componentProps: {
        showLabel: true,
        infoType: 0,
        width: '100%',
        disabled: true,
        placeholder: '',
        loadAgain: false,
        span: '',
        style: { width: '100%' },
      },
    },
    {
      key: '0e1265bafe6249f8bd4168b6da21346f',
      field: 'createDate',
      label: '创建时间',
      type: 'info',
      ifShow: false,
      component: 'Info',
      colProps: { span: 24 },
      componentProps: {
        showLabel: true,
        infoType: 0,
        width: '100%',
        disabled: true,
        placeholder: '',
        loadAgain: false,
        span: '',
        style: { width: '100%' },
      },
    },
    {
      key: '9095cbe550b8409eba1997a70c46e951',
      label: '班组人员',
      field: 'mesProGroupuserList',
      type: 'form',
      component: 'SubForm',
      required: true,
      colProps: { span: 24 },
      ifShow: true,
      slot: 'mesProGroupuserList',
      componentProps: {
        mainKey: 'mesProGroupuserList',
        columns: [
          {
            key: '1d7ab6ac9cad4de6bc06ccad877b83d9',
            title: '员工',
            dataIndex: 'userId',
            componentType: 'MultiplePopup',
            componentProps: {
              popupType: 'associate',
              rules: [],
              valueField: 'value',
              showLabel: true,
              required: true,
              labelField: 'label',
              prestrainField: 'id',
              datasourceType: 'api',
              dicOptions: [],
              width: '100%',
              apiConfig: {
                method: 'GET',
                script:
                  'var condition="";\r\n\r\nreturn db.select("SELECT * FROM xjr_user  "+condition)',
                apiParams: [
                  {
                    tableInfo: [
                      {
                        dataType: 'String',
                        bindType: 'value',
                        required: false,
                        name: 'keyword',
                        value: '',
                      },
                    ],
                    title: 'Query Params',
                    key: '1',
                  },
                  { tableInfo: [], title: 'Header', key: '2' },
                  { title: 'Body', key: '3' },
                ],
                path: '/mes/getUserList',
                outputParams: [
                  {
                    show: true,
                    bindField: 'userName',
                    name: 'name',
                    width: 150,
                    tableTitle: '姓名',
                  },
                  {
                    show: false,
                    bindField: 'user_dept_id',
                    name: 'dept_id',
                    width: 150,
                    tableTitle: '所属部门ID',
                  },
                  {
                    show: true,
                    bindField: 'user_dept',
                    name: 'dept_name',
                    width: 150,
                    tableTitle: '所属部门',
                  },
                  {
                    show: true,
                    bindField: 'user_phone',
                    name: 'mobile',
                    width: 150,
                    tableTitle: '手机号',
                  },
                ],
                apiId: 'copy1690962533901d40821',
              },
              disabled: true,
              placeholder: '请选择员工',
              events: {},
              span: '',
            },
          },
          {
            key: '066ed4053a1b4cd5b9cb3fbbbe690d02',
            title: '姓名',
            dataIndex: 'userName',
            componentType: 'Input',
            defaultValue: '',
            componentProps: {
              defaultValue: '',
              prefix: '',
              rules: [],
              suffix: '',
              addonAfter: '',
              showLabel: true,
              required: false,
              width: '100%',
              disabled: true,
              placeholder: '',
              prestrainField: 'name',
              allowClear: false,
              addonBefore: '',
              events: {},
              span: '',
            },
          },
          {
            key: '066ed4053a1b4cd5b9cb3fbbbe690d02',
            title: '所属部门ID',
            dataIndex: 'userDeptId',
            componentType: 'Input',
            defaultValue: '',
            show: false,
            componentProps: {
              defaultValue: '',
              prefix: '',
              rules: [],
              suffix: '',
              addonAfter: '',
              showLabel: true,
              required: false,
              width: '100%',
              disabled: true,
              placeholder: '请输入所属部门',
              allowClear: false,
              prestrainField: 'dept_id',
              addonBefore: '',
              events: {},
              span: '',
            },
          },
          {
            key: '066ed4053a1b4cd5b9cb3fbbbe690d02',
            title: '所属部门',
            dataIndex: 'userDept',
            componentType: 'Dept',
            defaultValue: '',
            componentProps: {
              defaultValue: '',
              prefix: '',
              rules: [],
              suffix: '',
              addonAfter: '',
              showLabel: true,
              required: false,
              width: '100%',
              disabled: true,
              placeholder: '请输入所属部门',
              allowClear: false,
              prestrainField: 'dept_id',
              addonBefore: '',
              events: {},
              span: '',
            },
          },
          {
            key: 'da8e9960e41247eea8556126e0e7eda6',
            title: '手机号码',
            dataIndex: 'userPhone',
            componentType: 'Input',
            defaultValue: '',
            componentProps: {
              defaultValue: '',
              prefix: '',
              rules: [],
              suffix: '',
              addonAfter: '',
              showLabel: true,
              required: false,
              width: '100%',
              disabled: true,
              placeholder: '请输入手机号码',

              prestrainField: 'mobile',
              allowClear: false,
              addonBefore: '',
              events: {},
              span: '',
            },
          },
          {
            key: '5e4cea42dbb641f6b58c2a809f568d6a',
            title: '班组长',
            dataIndex: 'leaderFlag',
            componentType: 'ApiCheckboxGroup',
            componentProps: {
              defaultSelect: '1',
              rules: [],
              valueField: 'value',
              showLabel: true,
              required: false,
              labelField: 'label',
              optionType: 'default',
              datasourceType: 'staticData',
              dicOptions: [],
              apiConfig: {},
              disabled: false,
              staticOptions: [{ label: '', value: '1', key: 1 }],
              events: {
                change:
                  'formModel.mesProGroupuserList.forEach(e => {\n' +
                  "console.log('chg===',e,index,scope);\n" +
                  '});\n',
              },
              span: '',
            },
          },
          { title: '操作', key: 'action', fixed: 'right', width: '50px' },
        ],
        buttonName: '选择',
        showIndex: false,
        useSelectButton: true,
        useAddButton: false,
        preloadType: 'api',
        showLabel: true,
        itemId: '',
        multipleHeads: [],
        dicOptions: [],
        showComponentBorder: true,
        apiConfig: {
          method: 'GET',
          script: 'var condition="";\r\n\r\nreturn db.select("SELECT * FROM xjr_user  "+condition)',
          apiParams: [
            {
              tableInfo: [
                {
                  dataType: 'String',
                  bindType: 'value',
                  required: false,
                  name: 'keyword',
                  value: '',
                },
              ],
              title: 'Query Params',
              key: '1',
            },
            { tableInfo: [], title: 'Header', key: '2' },
            { title: 'Body', key: '3' },
          ],
          path: '/mes/getUserList',
          outputParams: [
            {
              show: true,
              bindField: 'userName',
              name: 'name',
              width: 150,
              tableTitle: '姓名',
            },
            {
              show: false,
              bindField: 'user_dept_id',
              name: 'dept_id',
              width: 150,
              tableTitle: '所属部门ID',
            },
            {
              show: true,
              bindField: 'user_dept',
              name: 'dept_name',
              width: 150,
              tableTitle: '所属部门',
            },
            {
              show: true,
              bindField: 'user_phone',
              name: 'mobile',
              width: 150,
              tableTitle: '手机号',
            },
          ],
          apiId: 'copy1690962533901d40821',
        },
        showFormBorder: true,
        span: '24',
      },
    },
  ],
  showActionButtonGroup: false,
  buttonLocation: 'center',
  actionColOptions: { span: 24 },
  showResetButton: false,
  showSubmitButton: false,
  hiddenComponent: [],
};
