import {
  MesWarehouseChgModel,
  MesWarehouseChgPageParams,
  MesWarehouseChgPageResult,
} from './model/WarehouseChgModel';
import { defHttp } from '/@/utils/http/axios';
import { ErrorMessageMode } from '/#/axios';

enum Api {
  Page = '/mes/warehousechg/page',
  List = '/mes/warehousechg/list',
  Info = '/mes/warehousechg/info',
  MesWarehouseChg = '/mes/warehousechg',

  Export = '/mes/warehousechg/export',
}

/**
 * @description: 查询MesWarehouseChg分页列表
 */
export async function getMesWarehouseChgPage(
  params: MesWarehouseChgPageParams,
  mode: ErrorMessageMode = 'modal',
) {
  return defHttp.get<MesWarehouseChgPageResult>(
    {
      url: Api.Page,
      params,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 获取MesWarehouseChg信息
 */
export async function getMesWarehouseChg(id: String, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<MesWarehouseChgModel>(
    {
      url: Api.Info,
      params: { id },
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 新增MesWarehouseChg
 */
export async function addMesWarehouseChg(
  mesWarehouseChg: Recordable,
  mode: ErrorMessageMode = 'modal',
) {
  return defHttp.post<boolean>(
    {
      url: Api.MesWarehouseChg,
      params: mesWarehouseChg,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 更新MesWarehouseChg
 */
export async function updateMesWarehouseChg(
  mesWarehouseChg: Recordable,
  mode: ErrorMessageMode = 'modal',
) {
  return defHttp.put<boolean>(
    {
      url: Api.MesWarehouseChg,
      params: mesWarehouseChg,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 删除MesWarehouseChg（批量删除）
 */
export async function deleteMesWarehouseChg(ids: string[], mode: ErrorMessageMode = 'modal') {
  return defHttp.delete<boolean>(
    {
      url: Api.MesWarehouseChg,
      data: ids,
    },
    {
      errorMessageMode: mode,
    },
  );
}

export async function finishMesWarehouseChg(id: string, mode: ErrorMessageMode = 'modal') {
  return defHttp.post<boolean>(
    {
      url: '/mes/warehousechg/finish/' + id,
    },
    {
      errorMessageMode: mode,
    },
  );
}
/**
 * @description: 导出MesWarehouseChg
 */
export async function exportMesWarehouseChg(params?: object, mode: ErrorMessageMode = 'modal') {
  return defHttp.download(
    {
      url: Api.Export,
      method: 'GET',
      params,
      responseType: 'blob',
    },
    {
      errorMessageMode: mode,
    },
  );
}
