import { FormProps, FormSchema } from '/@/components/Form';
import { BasicColumn } from '/@/components/Table';
import { uploadApi } from '/@/api/sys/upload';

export const searchFormSchema: FormSchema[] = [
  {
    field: 'mjbh',
    label: '模具编号',
    defaultValue: undefined,
    component: 'Input',
  },
  {
    field: 'mjxh',
    label: '模具型号',
    defaultValue: undefined,
    component: 'Input',
  },
  {
    field: 'mjzt',
    label: '模具状态',
    defaultValue: undefined,
    component: 'XjrSelect',
    componentProps: {
      datasourceType: 'dic',
      params: { itemId: '2008005005054803969' },
      labelField: 'name',
      valueField: 'value',
      mode: 'multiple',
      showSearch: true,
      getPopupContainer: () => document.body,
    },
  },
];

export const columns: BasicColumn[] = [
  {
    resizable: true,
    dataIndex: 'mjbh',
    title: '模具编号',
    componentType: 'input',

    fixed: false,
    sorter: true,

    styleConfig: undefined,
    listStyle: '',
  },

  {
    resizable: true,
    dataIndex: 'mjxh',
    title: '模具型号',
    componentType: 'input',

    fixed: false,
    sorter: true,

    styleConfig: undefined,
    listStyle: '',
  },

  {
    resizable: true,
    dataIndex: 'mjzt',
    title: '模具状态',
    componentType: 'select',

    fixed: false,
    sorter: true,

    styleConfig: undefined,
    listStyle: undefined,
  },

  {
    resizable: true,
    dataIndex: 'cszl',
    title: '初始重量',
    componentType: 'number',

    fixed: false,
    sorter: true,

    styleConfig: undefined,
    listStyle: undefined,
  },

  {
    resizable: true,
    dataIndex: 'syxc',
    title: '适用型材',
    componentType: 'input',

    fixed: false,
    sorter: true,

    styleConfig: undefined,
    listStyle: '',
  },

  {
    resizable: true,
    dataIndex: 'sycz',
    title: '适用材质',
    componentType: 'input',

    fixed: false,
    sorter: true,

    styleConfig: undefined,
    listStyle: '',
  },
];
//表头合并配置
export const headerMergingData = [];
//表单事件
export const formEventConfigs = {
  0: [
    {
      type: 'circle',
      color: '#2774ff',
      text: '开始节点',
      icon: '#icon-kaishi',
      bgcColor: '#D8E5FF',
      isUserDefined: false,
    },
    {
      color: '#F6AB01',
      icon: '#icon-chushihua',
      text: '初始化表单',
      bgcColor: '#f9f5ea',
      isUserDefined: false,
      nodeInfo: { processEvent: [] },
    },
  ],
  1: [
    {
      color: '#B36EDB',
      icon: '#icon-shujufenxi',
      text: '获取表单数据',
      detail: '(新增无此操作)',
      bgcColor: '#F8F2FC',
      isUserDefined: false,
      nodeInfo: { processEvent: [] },
    },
  ],
  2: [
    {
      color: '#F8625C',
      icon: '#icon-jiazai',
      text: '加载表单',
      bgcColor: '#FFF1F1',
      isUserDefined: false,
      nodeInfo: { processEvent: [] },
    },
  ],
  3: [
    {
      color: '#6C6AE0',
      icon: '#icon-jsontijiao',
      text: '提交表单',
      bgcColor: '#F5F4FF',
      isUserDefined: false,
      nodeInfo: { processEvent: [] },
    },
  ],
  4: [
    {
      type: 'circle',
      color: '#F8625C',
      text: '结束节点',
      icon: '#icon-jieshuzhiliao',
      bgcColor: '#FFD6D6',
      isLast: true,
      isUserDefined: false,
    },
  ],
};
export const formProps: FormProps = {
  labelCol: { span: 2, offset: 0 },
  labelAlign: 'right',
  layout: 'horizontal',
  size: 'default',
  schemas: [
    {
      key: '36422a2b75f94d7fa2e7ae0b3f422f9a',
      field: '',
      label: '',
      type: 'grid',
      colProps: { span: 24 },
      component: 'Grid',
      children: [
        {
          span: 6,
          list: [
            {
              key: '1f9b6e7246a541e6aac296b87cdf879d',
              field: 'mjbh',
              label: '模具编号',
              type: 'input',
              component: 'Input',
              colProps: { span: 24 },
              defaultValue: '',
              componentProps: {
                width: '100%',
                span: 7,
                defaultValue: '',
                placeholder: '请输入模具编号',
                prefix: '',
                suffix: '',
                addonBefore: '',
                addonAfter: '',
                disabled: false,
                allowClear: false,
                showLabel: true,
                required: false,
                rules: [],
                events: {},
                listStyle: '',
                isSave: false,
                isShow: true,
                scan: false,
                bordered: true,
                isShowAi: false,
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
          ],
        },
        {
          span: 6,
          list: [
            {
              key: '980fb788d2604a49a12639f8aa236713',
              field: 'mjxh',
              label: '模具型号',
              type: 'input',
              component: 'Input',
              colProps: { span: 24 },
              defaultValue: '',
              componentProps: {
                width: '100%',
                span: 7,
                defaultValue: '',
                placeholder: '请输入模具型号',
                prefix: '',
                suffix: '',
                addonBefore: '',
                addonAfter: '',
                disabled: false,
                allowClear: false,
                showLabel: true,
                required: false,
                rules: [],
                events: {},
                listStyle: '',
                isSave: false,
                isShow: true,
                scan: false,
                bordered: true,
                isShowAi: false,
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
          ],
        },
        {
          span: 6,
          list: [
            {
              key: '782f3477401f403a9e821ea4bfb425aa',
              field: 'mjzt',
              label: '模具状态',
              type: 'select',
              component: 'XjrSelect',
              colProps: { span: 24 },
              componentProps: {
                width: '100%',
                span: 7,
                placeholder: '请选择下拉选择',
                showLabel: true,
                showSearch: false,
                isMultiple: false,
                clearable: false,
                disabled: false,
                staticOptions: [
                  { key: 1, label: 'Option 1', value: 'Option 1' },
                  { key: 2, label: 'Option 2', value: 'Option 2' },
                  { key: 3, label: 'Option 3', value: 'Option 3' },
                ],
                datasourceType: 'dic',
                params: { itemId: '2008005005054803969' },
                labelField: 'name',
                valueField: 'value',
                apiConfig: {
                  path: 'CodeGeneration/selection',
                  method: 'GET',
                  apiId: '93d735dcb7364a0f8102188ec4d77ac7',
                },
                dicOptions: [],
                required: false,
                rules: [],
                events: {},
                isShow: true,
                tooltipConfig: { visible: false, title: '提示文本' },
                itemId: '2008005005054803969',
                style: { width: '100%' },
              },
            },
          ],
        },
        {
          span: 6,
          list: [
            {
              key: '088b42e2609642fe9abb0df275583ced',
              field: 'syxc',
              label: '适用型材',
              type: 'input',
              component: 'Input',
              colProps: { span: 24 },
              defaultValue: '',
              componentProps: {
                width: '100%',
                span: 7,
                defaultValue: '',
                placeholder: '请输入适用型材',
                prefix: '',
                suffix: '',
                addonBefore: '',
                addonAfter: '',
                disabled: false,
                allowClear: false,
                showLabel: true,
                required: false,
                rules: [],
                events: {},
                listStyle: '',
                isSave: false,
                isShow: true,
                scan: false,
                bordered: true,
                isShowAi: false,
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
          ],
        },
        {
          span: 6,
          list: [
            {
              key: '03133d4790cb486588a656269512865a',
              field: 'sycz',
              label: '适用材质',
              type: 'input',
              component: 'Input',
              colProps: { span: 24 },
              defaultValue: '',
              componentProps: {
                width: '100%',
                span: 7,
                defaultValue: '',
                placeholder: '请输入适用材质',
                prefix: '',
                suffix: '',
                addonBefore: '',
                addonAfter: '',
                disabled: false,
                allowClear: false,
                showLabel: true,
                required: false,
                rules: [],
                events: {},
                listStyle: '',
                isSave: false,
                isShow: true,
                scan: false,
                bordered: true,
                isShowAi: false,
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
          ],
        },
        {
          span: 6,
          list: [
            {
              key: '27a2013d5c414099b981bf0e51ec07f7',
              field: 'sssm',
              label: '设计寿命',
              type: 'input',
              component: 'Input',
              colProps: { span: 24 },
              defaultValue: '',
              componentProps: {
                width: '100%',
                span: 7,
                defaultValue: '',
                placeholder: '请输入设计寿命',
                prefix: '',
                suffix: '',
                addonBefore: '',
                addonAfter: '',
                disabled: false,
                allowClear: false,
                showLabel: true,
                required: false,
                rules: [],
                events: {},
                listStyle: '',
                isSave: false,
                isShow: true,
                scan: false,
                bordered: true,
                isShowAi: false,
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
          ],
        },
        {
          span: 6,
          list: [
            {
              key: '3430222f9260433fa12448617bca67c9',
              field: 'gycs',
              label: '供应厂商',
              type: 'input',
              component: 'Input',
              colProps: { span: 24 },
              defaultValue: '',
              componentProps: {
                width: '100%',
                span: 7,
                defaultValue: '',
                placeholder: '请输入供应厂商',
                prefix: '',
                suffix: '',
                addonBefore: '',
                addonAfter: '',
                disabled: false,
                allowClear: false,
                showLabel: true,
                required: false,
                rules: [],
                events: {},
                listStyle: '',
                isSave: false,
                isShow: true,
                scan: false,
                bordered: true,
                isShowAi: false,
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
          ],
        },
        {
          span: 6,
          list: [
            {
              key: 'fa6bd86a6c5c4a7e92b131fcec54570c',
              field: 'cszl',
              label: '初始重量',
              type: 'number',
              component: 'InputNumber',
              colProps: { span: 24 },
              defaultValue: 0,
              componentProps: {
                width: '100%',
                span: 7,
                defaultValue: 0,
                min: 0,
                step: 1,
                disabled: false,
                showLabel: true,
                controls: true,
                required: false,
                subTotal: false,
                isShow: true,
                rules: [],
                events: {},
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
          ],
        },
        {
          span: 6,
          list: [
            {
              key: 'ca2bbcb231694715a85efa46baad4cfa',
              field: 'smzqlx',
              label: '生命周期类型',
              type: 'input',
              component: 'Input',
              colProps: { span: 24 },
              defaultValue: '',
              componentProps: {
                width: '100%',
                span: 7,
                defaultValue: '',
                placeholder: '请输入生命周期类型',
                prefix: '',
                suffix: '',
                addonBefore: '',
                addonAfter: '',
                disabled: false,
                allowClear: false,
                showLabel: true,
                required: false,
                rules: [],
                events: {},
                listStyle: '',
                isSave: false,
                isShow: true,
                scan: false,
                bordered: true,
                isShowAi: false,
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
          ],
        },
        {
          span: 6,
          list: [
            {
              key: '63b75d3782954952acab6cf8f3c201c4',
              field: 'bzsmzq',
              label: '标准生命周期',
              type: 'input',
              component: 'Input',
              colProps: { span: 24 },
              defaultValue: '',
              componentProps: {
                width: '100%',
                span: 7,
                defaultValue: '',
                placeholder: '请输入标准生命周期',
                prefix: '',
                suffix: '',
                addonBefore: '',
                addonAfter: '',
                disabled: false,
                allowClear: false,
                showLabel: true,
                required: false,
                rules: [],
                events: {},
                listStyle: '',
                isSave: false,
                isShow: true,
                scan: false,
                bordered: true,
                isShowAi: false,
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
          ],
        },
        {
          span: 6,
          list: [
            {
              key: 'b269d23d359d4f16ba32cbeec89aa393',
              field: 'xhsmzq',
              label: '消耗生命周期',
              type: 'input',
              component: 'Input',
              colProps: { span: 24 },
              defaultValue: '',
              componentProps: {
                width: '100%',
                span: 7,
                defaultValue: '',
                placeholder: '请输入消耗生命周期',
                prefix: '',
                suffix: '',
                addonBefore: '',
                addonAfter: '',
                disabled: false,
                allowClear: false,
                showLabel: true,
                required: false,
                rules: [],
                events: {},
                listStyle: '',
                isSave: false,
                isShow: true,
                scan: false,
                bordered: true,
                isShowAi: false,
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
          ],
        },
        {
          span: 6,
          list: [
            {
              key: '6b182cc5427c49aa8d42fd3a1c489813',
              field: 'sysmzq',
              label: '剩余生命周期',
              type: 'input',
              component: 'Input',
              colProps: { span: 24 },
              defaultValue: '',
              componentProps: {
                width: '100%',
                span: 7,
                defaultValue: '',
                placeholder: '请输入剩余生命周期',
                prefix: '',
                suffix: '',
                addonBefore: '',
                addonAfter: '',
                disabled: false,
                allowClear: false,
                showLabel: true,
                required: false,
                rules: [],
                events: {},
                listStyle: '',
                isSave: false,
                isShow: true,
                scan: false,
                bordered: true,
                isShowAi: false,
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
          ],
        },
        {
          span: 6,
          list: [
            {
              key: 'd1277eff49004cbaaeef91a733d26833',
              field: 'ysbg',
              label: '验收报告',
              type: 'upload',
              component: 'Upload',
              colProps: { span: 24 },
              componentProps: {
                api: uploadApi,
                span: 7,
                defaultValue: '',
                accept: '',
                maxNumber: 5,
                maxSize: 5,
                showLabel: true,
                multiple: false,
                disabled: false,
                required: false,
                isShow: true,
                events: {},
                listType: 'text',
                sourceType: 'album,camera',
                tooltipConfig: { visible: false, title: '提示文本' },
              },
            },
          ],
        },
        {
          span: 6,
          list: [
            {
              key: '1d46f7fbade54824b82fbc696318bc93',
              field: 'id',
              label: '单行文本',
              type: 'input',
              component: 'Input',
              colProps: { span: 24 },
              defaultValue: '',
              componentProps: {
                width: '100%',
                span: 7,
                defaultValue: '',
                placeholder: '请输入单行文本',
                prefix: '',
                suffix: '',
                addonBefore: '',
                addonAfter: '',
                disabled: true,
                allowClear: false,
                showLabel: true,
                required: false,
                rules: [],
                events: {},
                listStyle: '',
                isSave: false,
                isShow: false,
                scan: false,
                bordered: true,
                isShowAi: false,
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
          ],
        },
      ],
      componentProps: {
        gutter: 16,
        justify: 'start',
        align: 'top',
        isShow: true,
        showBorder: false,
        bordercolor: '#d9d9d9',
        bordershowtype: [true, true, true, true],
        borderwidth: 1,
        padding: '10px',
        margin: '10px',
      },
    },
    {
      key: 'fc39552c1e304ddbb801187927b44a7f',
      field: '',
      label: '',
      type: 'tab',
      colProps: { span: 24 },
      component: 'Tab',
      children: [
        {
          span: 0,
          name: '领用记录',
          list: [
            {
              key: '70c13974080f4260b42060738457c5e6',
              label: '',
              field: 'mesMoldLogLyList',
              type: 'form',
              component: 'SubForm',
              required: true,
              colProps: { span: 24 },
              componentProps: {
                mainKey: 'mesMoldLogLyList',
                columns: [
                  {
                    key: '396cd979e5404df5893b5cd38544eac9',
                    title: '领用单号',
                    dataIndex: 'lydh',
                    componentType: 'Input',
                    defaultValue: '',
                    componentProps: {
                      width: '100%',
                      span: '',
                      defaultValue: '',
                      placeholder: '',
                      prefix: '',
                      suffix: '',
                      addonBefore: '',
                      addonAfter: '',
                      disabled: true,
                      allowClear: false,
                      showLabel: true,
                      required: false,
                      rules: [],
                      events: {},
                      listStyle: '',
                      isSave: false,
                      isShow: true,
                      scan: false,
                      bordered: true,
                      isShowAi: false,
                      tooltipConfig: { visible: false, title: '提示文本' },
                      prestrainField: 'lydh',
                    },
                  },
                  {
                    key: '79968f79a2e745eda789be427a6bbb47',
                    title: '领用人',
                    dataIndex: 'lyr',
                    componentType: 'XjrSelect',
                    componentProps: {
                      width: '100%',
                      span: '',
                      placeholder: '',
                      showLabel: true,
                      showSearch: false,
                      isMultiple: false,
                      clearable: false,
                      disabled: true,
                      staticOptions: [
                        { key: 1, label: 'Option 1', value: 'Option 1' },
                        { key: 2, label: 'Option 2', value: 'Option 2' },
                        { key: 3, label: 'Option 3', value: 'Option 3' },
                      ],
                      defaultSelect: '',
                      datasourceType: 'api',
                      labelField: 'label',
                      valueField: 'value',
                      apiConfig: {
                        path: '/bmxx/getEmployeeList',
                        method: 'GET',
                        apiId: 'copy1765432049337d61208',
                        apiParams: [
                          { key: '1', title: 'Query Params', tableInfo: [] },
                          { key: '2', title: 'Header', tableInfo: [] },
                          { key: '3', title: 'Body' },
                        ],
                        script:
                          'var sql="select *,id as value,name as label from roke_employee where active = 1 and delete_mark = 0";\r\nreturn db.select(sql);',
                      },
                      dicOptions: [],
                      required: false,
                      rules: [],
                      events: {},
                      isShow: true,
                      tooltipConfig: { visible: false, title: '提示文本' },
                      prestrainField: 'lyr',
                      listStyle: "return 'border: 0'",
                    },
                  },
                  {
                    key: '67ad6b792505452cb7c29cd55b7f0c10',
                    title: '领用数量',
                    dataIndex: 'lysl',
                    componentType: 'InputNumber',
                    defaultValue: 0,
                    componentProps: {
                      width: '100%',
                      span: '',
                      defaultValue: 0,
                      min: 0,
                      step: 1,
                      disabled: true,
                      showLabel: true,
                      controls: true,
                      required: false,
                      subTotal: false,
                      isShow: true,
                      rules: [],
                      events: {},
                      tooltipConfig: { visible: false, title: '提示文本' },
                      prestrainField: 'lysl',
                      listStyle: "return 'width:100%'",
                    },
                  },
                  {
                    key: '64115fda4ce743aa99d425ddd5d461db',
                    title: '领用时间',
                    dataIndex: 'lysj',
                    componentType: 'DatePicker',
                    defaultValue: '',
                    componentProps: {
                      span: '',
                      defaultValue: '',
                      width: '100%',
                      placeholder: '',
                      format: 'YYYY-MM-DD HH:mm:ss',
                      showLabel: true,
                      allowClear: false,
                      disabled: true,
                      required: false,
                      isShow: true,
                      rules: [],
                      events: {},
                      isGetCurrent: false,
                      tooltipConfig: { visible: false, title: '提示文本' },
                      searchType: 'time',
                      prestrainField: 'lysj',
                    },
                  },
                  {
                    key: '036606651a81407a8f35fd96aeda1f53',
                    title: '领用交接人',
                    dataIndex: 'lyjjr',
                    componentType: 'XjrSelect',
                    componentProps: {
                      width: '100%',
                      span: '',
                      placeholder: '',
                      showLabel: true,
                      showSearch: false,
                      isMultiple: false,
                      clearable: false,
                      disabled: true,
                      staticOptions: [
                        { key: 1, label: 'Option 1', value: 'Option 1' },
                        { key: 2, label: 'Option 2', value: 'Option 2' },
                        { key: 3, label: 'Option 3', value: 'Option 3' },
                      ],
                      defaultSelect: '',
                      datasourceType: 'api',
                      labelField: 'label',
                      valueField: 'value',
                      apiConfig: {
                        path: '/bmxx/getEmployeeList',
                        method: 'GET',
                        apiId: 'copy1765432049337d61208',
                        apiParams: [
                          { key: '1', title: 'Query Params', tableInfo: [] },
                          { key: '2', title: 'Header', tableInfo: [] },
                          { key: '3', title: 'Body' },
                        ],
                        script:
                          'var sql="select *,id as value,name as label from roke_employee where active = 1 and delete_mark = 0";\r\nreturn db.select(sql);',
                      },
                      dicOptions: [],
                      required: false,
                      rules: [],
                      events: {},
                      isShow: true,
                      tooltipConfig: { visible: false, title: '提示文本' },
                      prestrainField: 'lyjjr',
                      listStyle: "return 'border: 0'",
                    },
                  },
                  {
                    key: '4cd6fff8e7be4d2eb11d320778c875a7',
                    title: '领用部门',
                    dataIndex: 'lybm',
                    componentType: 'XjrSelect',
                    componentProps: {
                      width: '100%',
                      span: '',
                      placeholder: '',
                      showLabel: true,
                      showSearch: false,
                      isMultiple: false,
                      clearable: false,
                      disabled: true,
                      staticOptions: [
                        { key: 1, label: 'Option 1', value: 'Option 1' },
                        { key: 2, label: 'Option 2', value: 'Option 2' },
                        { key: 3, label: 'Option 3', value: 'Option 3' },
                      ],
                      defaultSelect: '',
                      datasourceType: 'api',
                      labelField: 'label',
                      valueField: 'value',
                      apiConfig: {
                        path: '/bmxx/getList',
                        method: 'GET',
                        apiId: '484584e786864e0f90ec8e4eb84fa93a',
                        apiParams: [
                          { key: '1', title: 'Query Params', tableInfo: [] },
                          { key: '2', title: 'Header', tableInfo: [] },
                          { key: '3', title: 'Body' },
                        ],
                        script:
                          'var sql="select id as value,name as label from roke_department";\r\nreturn db.select(sql);',
                      },
                      dicOptions: [],
                      required: false,
                      rules: [],
                      events: {},
                      isShow: true,
                      tooltipConfig: { visible: false, title: '提示文本' },
                      prestrainField: 'lybm',
                      listStyle: "return 'border: 0'",
                    },
                  },
                  {
                    key: '75230ae8f7bb4203a7360c9e092a48d1',
                    title: '领用说明',
                    dataIndex: 'lysm',
                    componentType: 'Input',
                    defaultValue: '',
                    componentProps: {
                      width: '100%',
                      span: '',
                      defaultValue: '',
                      placeholder: '',
                      prefix: '',
                      suffix: '',
                      addonBefore: '',
                      addonAfter: '',
                      disabled: true,
                      allowClear: false,
                      showLabel: true,
                      required: false,
                      rules: [],
                      events: {},
                      listStyle: '',
                      isSave: false,
                      isShow: true,
                      scan: false,
                      bordered: true,
                      isShowAi: false,
                      tooltipConfig: { visible: false, title: '提示文本' },
                      prestrainField: 'lysm',
                    },
                  },
                  {
                    key: '8e829e7d135643cfbc2f51979d8beda0',
                    title: '领用状态',
                    dataIndex: 'lyzt',
                    componentType: 'XjrSelect',
                    componentProps: {
                      width: '100%',
                      span: '',
                      placeholder: '',
                      showLabel: true,
                      showSearch: false,
                      isMultiple: false,
                      clearable: false,
                      disabled: true,
                      staticOptions: [
                        { key: 1, label: 'Option 1', value: 'Option 1' },
                        { key: 2, label: 'Option 2', value: 'Option 2' },
                        { key: 3, label: 'Option 3', value: 'Option 3' },
                      ],
                      datasourceType: 'dic',
                      params: { itemId: '2008007833840222210' },
                      labelField: 'name',
                      valueField: 'value',
                      apiConfig: {
                        path: 'CodeGeneration/selection',
                        method: 'GET',
                        apiId: '93d735dcb7364a0f8102188ec4d77ac7',
                      },
                      dicOptions: [],
                      required: false,
                      rules: [],
                      events: {},
                      isShow: true,
                      tooltipConfig: { visible: false, title: '提示文本' },
                      itemId: '2008007833840222210',
                      prestrainField: 'lyzt',
                      listStyle: "return 'border: 0'",
                    },
                  },
                ],
                span: '24',
                preloadType: 'api',
                apiConfig: {
                  path: '/mjgl//jcxx/getMoldLogLy',
                  method: 'GET',
                  apiId: '',
                  apiParams: [
                    {
                      key: '1',
                      title: 'Query Params',
                      tableInfo: [
                        {
                          name: 'mjid',
                          value: '{"bindField":"id","fieldKey":"1d46f7fbade54824b82fbc696318bc93"}',
                          required: false,
                          bindType: 'data',
                        },
                      ],
                    },
                    { key: '2', title: 'Header', tableInfo: [] },
                    { key: '3', title: 'Body' },
                  ],
                  script:
                    'return db.select("select * from mes_mold_log_ly where delete_mark = 0 and mjid = #{mjid}")',
                },
                itemId: '',
                dicOptions: [],
                useSelectButton: false,
                buttonName: '选择数据',
                showLabel: true,
                showComponentBorder: true,
                showBorder: false,
                bordercolor: '#f0f0f0',
                bordershowtype: [true, true, true, true],
                borderwidth: 1,
                showIndex: false,
                isShow: true,
                multipleHeads: [],
                buttonList: [],
                topButtonList: [],
                isExport: false,
                isImport: false,
                isDeleteSelected: false,
                isListView: false,
                viewList: [],
                isShowAdd: false,
                isShowDelete: false,
                hasCheckedCol: false,
                events: {},
                showPagenation: true,
                widths: [
                  {
                    key: '396cd979e5404df5893b5cd38544eac9',
                    name: '领用单号',
                    bindField: 'lydh',
                    resizable: false,
                    isEdit: true,
                  },
                  {
                    key: '79968f79a2e745eda789be427a6bbb47',
                    name: '领用人',
                    bindField: 'lyr',
                    resizable: false,
                    isEdit: true,
                  },
                  {
                    key: '67ad6b792505452cb7c29cd55b7f0c10',
                    name: '领用数量',
                    bindField: 'lysl',
                    resizable: false,
                    isEdit: true,
                  },
                  {
                    key: '64115fda4ce743aa99d425ddd5d461db',
                    name: '领用时间',
                    bindField: 'lysj',
                    resizable: false,
                    isEdit: true,
                  },
                  {
                    key: '036606651a81407a8f35fd96aeda1f53',
                    name: '领用交接人',
                    bindField: 'lyjjr',
                    resizable: false,
                    isEdit: true,
                  },
                  {
                    key: '4cd6fff8e7be4d2eb11d320778c875a7',
                    name: '领用部门',
                    bindField: 'lybm',
                    resizable: false,
                    isEdit: true,
                  },
                  {
                    key: '75230ae8f7bb4203a7360c9e092a48d1',
                    name: '领用说明',
                    bindField: 'lysm',
                    resizable: false,
                    isEdit: true,
                  },
                  {
                    key: '8e829e7d135643cfbc2f51979d8beda0',
                    name: '领用状态',
                    bindField: 'lyzt',
                    resizable: false,
                    isEdit: true,
                  },
                ],
              },
            },
          ],
        },
        {
          span: 24,
          name: '使用记录',
          prefix: '',
          suffix: '',
          activeColor: '#1c8dff',
          folderId: '',
          imageUrl: '',
          conFolderId: '',
          conImageUrl: '',
          list: [
            {
              key: '11eeb5cf00804b4f8de619fe48366522',
              label: '',
              field: 'mesMoldLogSyList',
              type: 'form',
              component: 'SubForm',
              required: true,
              colProps: { span: 24 },
              componentProps: {
                mainKey: 'mesMoldLogSyList',
                columns: [
                  {
                    key: 'f4be91d342b94edcb68c59bb85b5dc95',
                    title: '使用单号',
                    dataIndex: 'sydh',
                    componentType: 'Input',
                    defaultValue: '',
                    componentProps: {
                      width: '100%',
                      span: '',
                      defaultValue: '',
                      placeholder: '',
                      prefix: '',
                      suffix: '',
                      addonBefore: '',
                      addonAfter: '',
                      disabled: true,
                      allowClear: false,
                      showLabel: true,
                      required: false,
                      rules: [],
                      events: {},
                      listStyle: '',
                      isSave: false,
                      isShow: true,
                      scan: false,
                      bordered: true,
                      isShowAi: false,
                      tooltipConfig: { visible: false, title: '提示文本' },
                      prestrainField: 'sydh',
                    },
                  },
                  {
                    key: '37946563c6b549aea820b4d17a650a38',
                    title: '使用人',
                    dataIndex: 'syr',
                    componentType: 'Input',
                    defaultValue: '',
                    componentProps: {
                      width: '100%',
                      span: '',
                      defaultValue: '',
                      placeholder: '',
                      prefix: '',
                      suffix: '',
                      addonBefore: '',
                      addonAfter: '',
                      disabled: true,
                      allowClear: false,
                      showLabel: true,
                      required: false,
                      rules: [],
                      events: {},
                      listStyle: '',
                      isSave: false,
                      isShow: true,
                      scan: false,
                      bordered: true,
                      isShowAi: false,
                      tooltipConfig: { visible: false, title: '提示文本' },
                      prestrainField: 'syr',
                    },
                  },
                  {
                    key: '8b3bff18b36844518adf9827106e9e95',
                    title: '使用设备',
                    dataIndex: 'sysb',
                    componentType: 'Input',
                    defaultValue: '',
                    componentProps: {
                      width: '100%',
                      span: '',
                      defaultValue: '',
                      placeholder: '',
                      prefix: '',
                      suffix: '',
                      addonBefore: '',
                      addonAfter: '',
                      disabled: true,
                      allowClear: false,
                      showLabel: true,
                      required: false,
                      rules: [],
                      events: {},
                      listStyle: '',
                      isSave: false,
                      isShow: true,
                      scan: false,
                      bordered: true,
                      isShowAi: false,
                      tooltipConfig: { visible: false, title: '提示文本' },
                      prestrainField: 'sysb',
                    },
                  },
                  {
                    key: '06669ce89b5949039ef998f4e1002e98',
                    title: '消耗生命周期',
                    dataIndex: 'xhsmyz',
                    componentType: 'InputNumber',
                    defaultValue: 0,
                    componentProps: {
                      width: '100%',
                      span: '',
                      defaultValue: 0,
                      min: 0,
                      max: 100,
                      step: 1,
                      disabled: true,
                      showLabel: true,
                      controls: true,
                      required: false,
                      subTotal: false,
                      isShow: true,
                      rules: [],
                      events: {},
                      tooltipConfig: { visible: false, title: '提示文本' },
                      prestrainField: 'xhsmzq',
                      listStyle: "return 'width:100%'",
                    },
                  },
                  {
                    key: '67a7b7dba74d4968af4918bcd12a742b',
                    title: '使用方式',
                    dataIndex: 'syfs',
                    componentType: 'Input',
                    defaultValue: '',
                    componentProps: {
                      width: '100%',
                      span: '',
                      defaultValue: '',
                      placeholder: '',
                      prefix: '',
                      suffix: '',
                      addonBefore: '',
                      addonAfter: '',
                      disabled: true,
                      allowClear: false,
                      showLabel: true,
                      required: false,
                      rules: [],
                      events: {},
                      listStyle: '',
                      isSave: false,
                      isShow: true,
                      scan: false,
                      bordered: true,
                      isShowAi: false,
                      tooltipConfig: { visible: false, title: '提示文本' },
                      prestrainField: 'syfs',
                    },
                  },
                  {
                    key: '26ea7eaa29df466dbe8b6880d90ab703',
                    title: '使用时间',
                    dataIndex: 'sysj',
                    componentType: 'DatePicker',
                    defaultValue: '',
                    componentProps: {
                      span: '',
                      defaultValue: '',
                      width: '100%',
                      placeholder: '',
                      format: 'YYYY-MM-DD HH:mm:ss',
                      showLabel: true,
                      allowClear: false,
                      disabled: true,
                      required: false,
                      isShow: true,
                      rules: [],
                      events: {},
                      isGetCurrent: false,
                      tooltipConfig: { visible: false, title: '提示文本' },
                      searchType: 'time',
                      prestrainField: 'sysj',
                    },
                  },
                  {
                    key: '209037118f074d55b5dd5ada3fbd667e',
                    title: '使用说明',
                    dataIndex: 'sysm',
                    componentType: 'Input',
                    defaultValue: '',
                    componentProps: {
                      width: '100%',
                      span: '',
                      defaultValue: '',
                      placeholder: '',
                      prefix: '',
                      suffix: '',
                      addonBefore: '',
                      addonAfter: '',
                      disabled: true,
                      allowClear: false,
                      showLabel: true,
                      required: false,
                      rules: [],
                      events: {},
                      listStyle: '',
                      isSave: false,
                      isShow: true,
                      scan: false,
                      bordered: true,
                      isShowAi: false,
                      tooltipConfig: { visible: false, title: '提示文本' },
                      prestrainField: 'sysm',
                    },
                  },
                ],
                span: '24',
                preloadType: 'api',
                apiConfig: {
                  path: '/mjgl//jcxx/getMoldLogSy',
                  method: 'GET',
                  apiId: '',
                  apiParams: [
                    {
                      key: '1',
                      title: 'Query Params',
                      tableInfo: [
                        {
                          name: 'mjid',
                          value: '{"bindField":"id","fieldKey":"1d46f7fbade54824b82fbc696318bc93"}',
                          required: false,
                          bindType: 'data',
                        },
                      ],
                    },
                    { key: '2', title: 'Header', tableInfo: [] },
                    { key: '3', title: 'Body' },
                  ],
                  script:
                    'return db.select("select * from mes_mold_log_sy where delete_mark = 0 and mjid = #{mjid}")',
                },
                itemId: '',
                dicOptions: [],
                useSelectButton: false,
                buttonName: '选择数据',
                showLabel: true,
                showComponentBorder: true,
                showBorder: false,
                bordercolor: '#f0f0f0',
                bordershowtype: [true, true, true, true],
                borderwidth: 1,
                showIndex: false,
                isShow: true,
                multipleHeads: [],
                buttonList: [],
                topButtonList: [],
                isExport: false,
                isImport: false,
                isDeleteSelected: false,
                isListView: false,
                viewList: [],
                isShowAdd: false,
                isShowDelete: false,
                hasCheckedCol: false,
                events: {},
                showPagenation: true,
                widths: [
                  {
                    key: 'f4be91d342b94edcb68c59bb85b5dc95',
                    name: '使用单号',
                    bindField: 'sydh',
                    resizable: false,
                    isEdit: true,
                  },
                  {
                    key: '37946563c6b549aea820b4d17a650a38',
                    name: '使用人',
                    bindField: 'syr',
                    resizable: false,
                    isEdit: true,
                  },
                  {
                    key: '8b3bff18b36844518adf9827106e9e95',
                    name: '使用设备',
                    bindField: 'sysb',
                    resizable: false,
                    isEdit: true,
                  },
                  {
                    key: '06669ce89b5949039ef998f4e1002e98',
                    name: '消耗生命周期',
                    bindField: 'xhsmyz',
                    resizable: false,
                    isEdit: true,
                  },
                  {
                    key: '67a7b7dba74d4968af4918bcd12a742b',
                    name: '使用方式',
                    bindField: 'syfs',
                    resizable: false,
                    isEdit: true,
                  },
                  {
                    key: '26ea7eaa29df466dbe8b6880d90ab703',
                    name: '使用时间',
                    bindField: 'sysj',
                    resizable: false,
                    isEdit: true,
                  },
                  {
                    key: '209037118f074d55b5dd5ada3fbd667e',
                    name: '使用说明',
                    bindField: 'sysm',
                    resizable: false,
                    isEdit: true,
                  },
                ],
              },
            },
          ],
        },
        {
          span: 0,
          name: '蚀洗记录',
          list: [
            {
              key: 'a727a4a4d3cc4654b041c8b36b03ed17',
              label: '',
              field: 'mesMoldLogSxList',
              type: 'form',
              component: 'SubForm',
              required: true,
              colProps: { span: 24 },
              componentProps: {
                mainKey: 'mesMoldLogSxList',
                columns: [
                  {
                    key: 'aa542f9c2dae4aebb36144bb84dc3d0e',
                    title: '蚀洗单号',
                    dataIndex: 'sxdh',
                    componentType: 'Input',
                    defaultValue: '',
                    componentProps: {
                      width: '100%',
                      span: '',
                      defaultValue: '',
                      placeholder: '',
                      prefix: '',
                      suffix: '',
                      addonBefore: '',
                      addonAfter: '',
                      disabled: true,
                      allowClear: false,
                      showLabel: true,
                      required: false,
                      rules: [],
                      events: {},
                      listStyle: '',
                      isSave: false,
                      isShow: true,
                      scan: false,
                      bordered: true,
                      isShowAi: false,
                      tooltipConfig: { visible: false, title: '提示文本' },
                      prestrainField: 'sxdh',
                    },
                  },
                  {
                    key: '46ee355b9c8f495c8bbec05d1d26e9a9',
                    title: '蚀洗人',
                    dataIndex: 'sxr',
                    componentType: 'XjrSelect',
                    componentProps: {
                      width: '100%',
                      span: '',
                      placeholder: '',
                      showLabel: true,
                      showSearch: false,
                      isMultiple: false,
                      clearable: false,
                      disabled: true,
                      staticOptions: [
                        { key: 1, label: 'Option 1', value: 'Option 1' },
                        { key: 2, label: 'Option 2', value: 'Option 2' },
                        { key: 3, label: 'Option 3', value: 'Option 3' },
                      ],
                      defaultSelect: '',
                      datasourceType: 'api',
                      labelField: 'label',
                      valueField: 'value',
                      apiConfig: {
                        path: '/bmxx/getEmployeeList',
                        method: 'GET',
                        apiId: 'copy1765432049337d61208',
                        apiParams: [
                          { key: '1', title: 'Query Params', tableInfo: [] },
                          { key: '2', title: 'Header', tableInfo: [] },
                          { key: '3', title: 'Body' },
                        ],
                        script:
                          'var sql="select *,id as value,name as label from roke_employee where active = 1 and delete_mark = 0";\r\nreturn db.select(sql);',
                      },
                      dicOptions: [],
                      required: false,
                      rules: [],
                      events: {},
                      isShow: true,
                      tooltipConfig: { visible: false, title: '提示文本' },
                      prestrainField: 'sxr',
                      listStyle: "return 'border: 0'",
                    },
                  },
                  {
                    key: 'e18c3b6439584207afab0ba9f729d233',
                    title: '蚀洗前重量',
                    dataIndex: 'sxqzl',
                    componentType: 'InputNumber',
                    defaultValue: 0,
                    componentProps: {
                      width: '100%',
                      span: '',
                      defaultValue: 0,
                      min: 0,
                      step: 1,
                      disabled: true,
                      showLabel: true,
                      controls: true,
                      required: false,
                      subTotal: false,
                      isShow: true,
                      rules: [],
                      events: {},
                      tooltipConfig: { visible: false, title: '提示文本' },
                      prestrainField: 'sxqzl',
                      listStyle: "return 'width:100%'",
                    },
                  },
                  {
                    key: 'ce4648737af54285a1aa65295f05ade2',
                    title: '蚀洗后重量',
                    dataIndex: 'sxhzl',
                    componentType: 'InputNumber',
                    defaultValue: 0,
                    componentProps: {
                      width: '100%',
                      span: '',
                      defaultValue: 0,
                      min: 0,
                      step: 1,
                      disabled: true,
                      showLabel: true,
                      controls: true,
                      required: false,
                      subTotal: false,
                      isShow: true,
                      rules: [],
                      events: {},
                      tooltipConfig: { visible: false, title: '提示文本' },
                      prestrainField: 'sxhzl',
                      listStyle: "return 'width:100%'",
                    },
                  },
                  {
                    key: '1447bacdf0bb40d29b28a89d50da23c7',
                    title: '蚀洗产物重量',
                    dataIndex: 'sxcwzl',
                    componentType: 'InputNumber',
                    defaultValue: 0,
                    componentProps: {
                      width: '100%',
                      span: '',
                      defaultValue: 0,
                      min: 0,
                      step: 1,
                      disabled: true,
                      showLabel: true,
                      controls: true,
                      required: false,
                      subTotal: false,
                      isShow: true,
                      rules: [],
                      events: {},
                      tooltipConfig: { visible: false, title: '提示文本' },
                      prestrainField: 'sxcwzl',
                      listStyle: "return 'width:100%'",
                    },
                  },
                  {
                    key: '60efa000f52b4587b461179fa18a6dbf',
                    title: '蚀洗时间',
                    dataIndex: 'sxsj',
                    componentType: 'DatePicker',
                    defaultValue: '',
                    componentProps: {
                      span: '',
                      defaultValue: '',
                      width: '100%',
                      placeholder: '',
                      format: 'YYYY-MM-DD HH:mm:ss',
                      showLabel: true,
                      allowClear: false,
                      disabled: true,
                      required: false,
                      isShow: true,
                      rules: [],
                      events: {},
                      isGetCurrent: false,
                      tooltipConfig: { visible: false, title: '提示文本' },
                      searchType: 'time',
                      prestrainField: 'sxsj',
                    },
                  },
                  {
                    key: 'a009e37c185740108ce8c93b9d58cf63',
                    title: '蚀洗说明',
                    dataIndex: 'sxsm',
                    componentType: 'Input',
                    defaultValue: '',
                    componentProps: {
                      width: '100%',
                      span: '',
                      defaultValue: '',
                      placeholder: '',
                      prefix: '',
                      suffix: '',
                      addonBefore: '',
                      addonAfter: '',
                      disabled: true,
                      allowClear: false,
                      showLabel: true,
                      required: false,
                      rules: [],
                      events: {},
                      listStyle: '',
                      isSave: false,
                      isShow: true,
                      scan: false,
                      bordered: true,
                      isShowAi: false,
                      tooltipConfig: { visible: false, title: '提示文本' },
                      prestrainField: 'sxsm',
                    },
                  },
                ],
                span: '24',
                preloadType: 'api',
                apiConfig: {
                  path: '/mjgl//jcxx/getMoldLogSx',
                  method: 'GET',
                  apiId: '',
                  apiParams: [
                    {
                      key: '1',
                      title: 'Query Params',
                      tableInfo: [
                        {
                          name: 'mjid',
                          value: '{"bindField":"id","fieldKey":"1d46f7fbade54824b82fbc696318bc93"}',
                          required: false,
                          bindType: 'data',
                        },
                      ],
                    },
                    { key: '2', title: 'Header', tableInfo: [] },
                    { key: '3', title: 'Body' },
                  ],
                  script:
                    'return db.select("select * from mes_mold_log_sx where delete_mark = 0 and mjid = #{mjid}")',
                },
                itemId: '',
                dicOptions: [],
                useSelectButton: false,
                buttonName: '选择数据',
                showLabel: true,
                showComponentBorder: true,
                showBorder: false,
                bordercolor: '#f0f0f0',
                bordershowtype: [true, true, true, true],
                borderwidth: 1,
                showIndex: false,
                isShow: true,
                multipleHeads: [],
                buttonList: [],
                topButtonList: [],
                isExport: false,
                isImport: false,
                isDeleteSelected: false,
                isListView: false,
                viewList: [],
                isShowAdd: false,
                isShowDelete: false,
                hasCheckedCol: false,
                events: {},
                showPagenation: true,
                widths: [
                  {
                    key: 'aa542f9c2dae4aebb36144bb84dc3d0e',
                    name: '蚀洗单号',
                    bindField: 'sxdh',
                    resizable: false,
                    isEdit: true,
                  },
                  {
                    key: '46ee355b9c8f495c8bbec05d1d26e9a9',
                    name: '蚀洗人',
                    bindField: 'sxr',
                    resizable: false,
                    isEdit: true,
                  },
                  {
                    key: 'e18c3b6439584207afab0ba9f729d233',
                    name: '蚀洗前重量',
                    bindField: 'sxqzl',
                    resizable: false,
                    isEdit: true,
                  },
                  {
                    key: 'ce4648737af54285a1aa65295f05ade2',
                    name: '蚀洗后重量',
                    bindField: 'sxhzl',
                    resizable: false,
                    isEdit: true,
                  },
                  {
                    key: '1447bacdf0bb40d29b28a89d50da23c7',
                    name: '蚀洗产物重量',
                    bindField: 'sxcwzl',
                    resizable: false,
                    isEdit: true,
                  },
                  {
                    key: '60efa000f52b4587b461179fa18a6dbf',
                    name: '蚀洗时间',
                    bindField: 'sxsj',
                    resizable: false,
                    isEdit: true,
                  },
                  {
                    key: 'a009e37c185740108ce8c93b9d58cf63',
                    name: '蚀洗说明',
                    bindField: 'sxsm',
                    resizable: false,
                    isEdit: true,
                  },
                ],
              },
            },
          ],
        },
        {
          span: 0,
          name: '归还记录',
          list: [
            {
              key: 'da32ec24ec98433f9a69f89d5e833d76',
              label: '',
              field: 'mesMoldLogGhList',
              type: 'form',
              component: 'SubForm',
              required: true,
              colProps: { span: 24 },
              componentProps: {
                mainKey: 'mesMoldLogGhList',
                columns: [
                  {
                    key: '68ba276455814b7d8196087da7e1c47e',
                    title: '归还单号',
                    dataIndex: 'ghdh',
                    componentType: 'Input',
                    defaultValue: '',
                    componentProps: {
                      width: '100%',
                      span: '',
                      defaultValue: '',
                      placeholder: '',
                      prefix: '',
                      suffix: '',
                      addonBefore: '',
                      addonAfter: '',
                      disabled: true,
                      allowClear: false,
                      showLabel: true,
                      required: false,
                      rules: [],
                      events: {},
                      listStyle: '',
                      isSave: false,
                      isShow: true,
                      scan: false,
                      bordered: true,
                      isShowAi: false,
                      tooltipConfig: { visible: false, title: '提示文本' },
                      prestrainField: 'ghdh',
                    },
                  },
                  {
                    key: 'bf962e9d32274af5947b16c73efc8de7',
                    title: '归还人',
                    dataIndex: 'ghr',
                    componentType: 'XjrSelect',
                    componentProps: {
                      width: '100%',
                      span: '',
                      placeholder: '',
                      showLabel: true,
                      showSearch: false,
                      isMultiple: false,
                      clearable: false,
                      disabled: true,
                      staticOptions: [
                        { key: 1, label: 'Option 1', value: 'Option 1' },
                        { key: 2, label: 'Option 2', value: 'Option 2' },
                        { key: 3, label: 'Option 3', value: 'Option 3' },
                      ],
                      defaultSelect: '',
                      datasourceType: 'api',
                      labelField: 'label',
                      valueField: 'value',
                      apiConfig: {
                        path: '/bmxx/getEmployeeList',
                        method: 'GET',
                        apiId: 'copy1765432049337d61208',
                        apiParams: [
                          { key: '1', title: 'Query Params', tableInfo: [] },
                          { key: '2', title: 'Header', tableInfo: [] },
                          { key: '3', title: 'Body' },
                        ],
                        script:
                          'var sql="select *,id as value,name as label from roke_employee where active = 1 and delete_mark = 0";\r\nreturn db.select(sql);',
                      },
                      dicOptions: [],
                      required: false,
                      rules: [],
                      events: {},
                      isShow: true,
                      tooltipConfig: { visible: false, title: '提示文本' },
                      prestrainField: 'ghr',
                      listStyle: "return 'border: 0'",
                    },
                  },
                  {
                    key: '25aa6e51d69744d1adb3b6e8a656863e',
                    title: '归还数量',
                    dataIndex: 'ghsl',
                    componentType: 'InputNumber',
                    defaultValue: 0,
                    componentProps: {
                      width: '100%',
                      span: '',
                      defaultValue: 0,
                      min: 0,
                      step: 1,
                      disabled: true,
                      showLabel: true,
                      controls: true,
                      required: false,
                      subTotal: false,
                      isShow: true,
                      rules: [],
                      events: {},
                      tooltipConfig: { visible: false, title: '提示文本' },
                      prestrainField: 'ghsl',
                      listStyle: "return 'width:100%'",
                    },
                  },
                  {
                    key: 'a6a0bb437d6f4d60b429177917542c22',
                    title: '归还时间',
                    dataIndex: 'ghsj',
                    componentType: 'DatePicker',
                    defaultValue: '',
                    componentProps: {
                      span: '',
                      defaultValue: '',
                      width: '100%',
                      placeholder: '',
                      format: 'YYYY-MM-DD HH:mm:ss',
                      showLabel: true,
                      allowClear: false,
                      disabled: true,
                      required: false,
                      isShow: true,
                      rules: [],
                      events: {},
                      isGetCurrent: false,
                      tooltipConfig: { visible: false, title: '提示文本' },
                      searchType: 'time',
                      prestrainField: 'ghsj',
                    },
                  },
                  {
                    key: 'cbd9109005744bf09a527c2a2d8d7cfa',
                    title: '归还状态',
                    dataIndex: 'ghzt',
                    componentType: 'XjrSelect',
                    componentProps: {
                      width: '100%',
                      span: '',
                      placeholder: '',
                      showLabel: true,
                      showSearch: false,
                      isMultiple: false,
                      clearable: false,
                      disabled: true,
                      staticOptions: [
                        { key: 1, label: 'Option 1', value: 'Option 1' },
                        { key: 2, label: 'Option 2', value: 'Option 2' },
                        { key: 3, label: 'Option 3', value: 'Option 3' },
                      ],
                      datasourceType: 'dic',
                      params: { itemId: '2008042042516537346' },
                      labelField: 'name',
                      valueField: 'value',
                      apiConfig: {
                        path: 'CodeGeneration/selection',
                        method: 'GET',
                        apiId: '93d735dcb7364a0f8102188ec4d77ac7',
                      },
                      dicOptions: [],
                      required: false,
                      rules: [],
                      events: {},
                      isShow: true,
                      tooltipConfig: { visible: false, title: '提示文本' },
                      prestrainField: 'ghzt',
                      itemId: '2008042042516537346',
                      listStyle: "return 'border: 0'",
                    },
                  },
                ],
                span: '24',
                preloadType: 'api',
                apiConfig: {
                  path: '/mjgl//jcxx/getMoldLogGh',
                  method: 'GET',
                  apiId: '',
                  apiParams: [
                    {
                      key: '1',
                      title: 'Query Params',
                      tableInfo: [
                        {
                          name: 'mjid',
                          value: '{"bindField":"id","fieldKey":"1d46f7fbade54824b82fbc696318bc93"}',
                          required: false,
                          bindType: 'data',
                        },
                      ],
                    },
                    { key: '2', title: 'Header', tableInfo: [] },
                    { key: '3', title: 'Body' },
                  ],
                  script:
                    'return db.select("select * from mes_mold_log_gh where delete_mark = 0 and mjid = #{mjid}")',
                },
                itemId: '',
                dicOptions: [],
                useSelectButton: false,
                buttonName: '选择数据',
                showLabel: true,
                showComponentBorder: true,
                showBorder: false,
                bordercolor: '#f0f0f0',
                bordershowtype: [true, true, true, true],
                borderwidth: 1,
                showIndex: false,
                isShow: true,
                multipleHeads: [],
                buttonList: [],
                topButtonList: [],
                isExport: false,
                isImport: false,
                isDeleteSelected: false,
                isListView: false,
                viewList: [],
                isShowAdd: false,
                isShowDelete: false,
                hasCheckedCol: false,
                events: {},
                showPagenation: true,
                widths: [
                  {
                    key: '68ba276455814b7d8196087da7e1c47e',
                    name: '归还单号',
                    bindField: 'ghdh',
                    resizable: false,
                    isEdit: true,
                  },
                  {
                    key: 'bf962e9d32274af5947b16c73efc8de7',
                    name: '归还人',
                    bindField: 'ghr',
                    resizable: false,
                    isEdit: true,
                  },
                  {
                    key: '25aa6e51d69744d1adb3b6e8a656863e',
                    name: '归还数量',
                    bindField: 'ghsl',
                    resizable: false,
                    isEdit: true,
                  },
                  {
                    key: 'a6a0bb437d6f4d60b429177917542c22',
                    name: '归还时间',
                    bindField: 'ghsj',
                    resizable: false,
                    isEdit: true,
                  },
                  {
                    key: 'cbd9109005744bf09a527c2a2d8d7cfa',
                    name: '归还状态',
                    bindField: 'ghzt',
                    resizable: false,
                    isEdit: true,
                  },
                ],
              },
            },
          ],
        },
        {
          span: 24,
          name: '维修记录',
          prefix: '',
          suffix: '',
          activeColor: '#1c8dff',
          folderId: '',
          imageUrl: '',
          conFolderId: '',
          conImageUrl: '',
          list: [
            {
              key: '9a8c273b3bc64867a265b086e2073f63',
              label: '',
              field: 'mesMoldLogWxList',
              type: 'form',
              component: 'SubForm',
              required: true,
              colProps: { span: 24 },
              componentProps: {
                mainKey: 'mesMoldLogWxList',
                columns: [
                  {
                    key: '7a5e61fa7c884f1a95c6ab9878b1e2aa',
                    title: '报修单号',
                    dataIndex: 'bxdh',
                    componentType: 'Input',
                    defaultValue: '',
                    componentProps: {
                      width: '100%',
                      span: '',
                      defaultValue: '',
                      placeholder: '',
                      prefix: '',
                      suffix: '',
                      addonBefore: '',
                      addonAfter: '',
                      disabled: true,
                      allowClear: false,
                      showLabel: true,
                      required: false,
                      rules: [],
                      events: {},
                      listStyle: '',
                      isSave: false,
                      isShow: true,
                      scan: false,
                      bordered: true,
                      isShowAi: false,
                      tooltipConfig: { visible: false, title: '提示文本' },
                      prestrainField: 'bxdh',
                    },
                  },
                  {
                    key: 'f9baa1a6c6154bc5b299b31bec153f16',
                    title: '报修人',
                    dataIndex: 'bxr',
                    componentType: 'XjrSelect',
                    componentProps: {
                      width: '100%',
                      span: '',
                      placeholder: '',
                      showLabel: true,
                      showSearch: false,
                      isMultiple: false,
                      clearable: false,
                      disabled: true,
                      staticOptions: [
                        { key: 1, label: 'Option 1', value: 'Option 1' },
                        { key: 2, label: 'Option 2', value: 'Option 2' },
                        { key: 3, label: 'Option 3', value: 'Option 3' },
                      ],
                      defaultSelect: '',
                      datasourceType: 'api',
                      labelField: 'label',
                      valueField: 'value',
                      apiConfig: {
                        path: '/bmxx/getEmployeeList',
                        method: 'GET',
                        apiId: 'copy1765432049337d61208',
                        apiParams: [
                          { key: '1', title: 'Query Params', tableInfo: [] },
                          { key: '2', title: 'Header', tableInfo: [] },
                          { key: '3', title: 'Body' },
                        ],
                        script:
                          'var sql="select *,id as value,name as label from roke_employee where active = 1 and delete_mark = 0";\r\nreturn db.select(sql);',
                      },
                      dicOptions: [],
                      required: false,
                      rules: [],
                      events: {},
                      isShow: true,
                      tooltipConfig: { visible: false, title: '提示文本' },
                      prestrainField: 'bxr',
                      listStyle: "return 'border: 0'",
                    },
                  },
                  {
                    key: '455b258077ab4a02bd8f4ea4735ee077',
                    title: '报修时间',
                    dataIndex: 'bxsj',
                    componentType: 'DatePicker',
                    defaultValue: '',
                    componentProps: {
                      span: '',
                      defaultValue: '',
                      width: '100%',
                      placeholder: '',
                      format: 'YYYY-MM-DD HH:mm:ss',
                      showLabel: true,
                      allowClear: false,
                      disabled: true,
                      required: false,
                      isShow: true,
                      rules: [],
                      events: {},
                      isGetCurrent: false,
                      tooltipConfig: { visible: false, title: '提示文本' },
                      searchType: 'time',
                      prestrainField: 'bxsj',
                    },
                  },
                  {
                    key: '494d3999acfb47518d07363fee4420aa',
                    title: '故障描述',
                    dataIndex: 'gzms',
                    componentType: 'Input',
                    defaultValue: '',
                    componentProps: {
                      width: '100%',
                      span: '',
                      defaultValue: '',
                      placeholder: '',
                      prefix: '',
                      suffix: '',
                      addonBefore: '',
                      addonAfter: '',
                      disabled: true,
                      allowClear: false,
                      showLabel: true,
                      required: false,
                      rules: [],
                      events: {},
                      listStyle: '',
                      isSave: false,
                      isShow: true,
                      scan: false,
                      bordered: true,
                      isShowAi: false,
                      tooltipConfig: { visible: false, title: '提示文本' },
                      prestrainField: 'gzms',
                    },
                  },
                  {
                    key: 'c12e85a0648a414aa8a155f0a147729e',
                    title: '维修指派人',
                    dataIndex: 'zpr',
                    componentType: 'XjrSelect',
                    componentProps: {
                      width: '100%',
                      span: '',
                      placeholder: '',
                      showLabel: true,
                      showSearch: false,
                      isMultiple: false,
                      clearable: false,
                      disabled: true,
                      staticOptions: [
                        { key: 1, label: 'Option 1', value: 'Option 1' },
                        { key: 2, label: 'Option 2', value: 'Option 2' },
                        { key: 3, label: 'Option 3', value: 'Option 3' },
                      ],
                      defaultSelect: '',
                      datasourceType: 'api',
                      labelField: 'label',
                      valueField: 'value',
                      apiConfig: {
                        path: '/bmxx/getEmployeeList',
                        method: 'GET',
                        apiId: 'copy1765432049337d61208',
                        apiParams: [
                          { key: '1', title: 'Query Params', tableInfo: [] },
                          { key: '2', title: 'Header', tableInfo: [] },
                          { key: '3', title: 'Body' },
                        ],
                        script:
                          'var sql="select *,id as value,name as label from roke_employee where active = 1 and delete_mark = 0";\r\nreturn db.select(sql);',
                      },
                      dicOptions: [],
                      required: false,
                      rules: [],
                      events: {},
                      isShow: true,
                      tooltipConfig: { visible: false, title: '提示文本' },
                      prestrainField: 'zpr',
                      listStyle: "return 'border: 0'",
                    },
                  },
                  {
                    key: '05d27e0f95664465a5605dcf99964e2d',
                    title: '维修人',
                    dataIndex: 'wxr',
                    componentType: 'XjrSelect',
                    componentProps: {
                      width: '100%',
                      span: '',
                      placeholder: '',
                      showLabel: true,
                      showSearch: false,
                      isMultiple: false,
                      clearable: false,
                      disabled: true,
                      staticOptions: [
                        { key: 1, label: 'Option 1', value: 'Option 1' },
                        { key: 2, label: 'Option 2', value: 'Option 2' },
                        { key: 3, label: 'Option 3', value: 'Option 3' },
                      ],
                      defaultSelect: '',
                      datasourceType: 'api',
                      labelField: 'label',
                      valueField: 'value',
                      apiConfig: {
                        path: '/bmxx/getEmployeeList',
                        method: 'GET',
                        apiId: 'copy1765432049337d61208',
                        apiParams: [
                          { key: '1', title: 'Query Params', tableInfo: [] },
                          { key: '2', title: 'Header', tableInfo: [] },
                          { key: '3', title: 'Body' },
                        ],
                        script:
                          'var sql="select *,id as value,name as label from roke_employee where active = 1 and delete_mark = 0";\r\nreturn db.select(sql);',
                      },
                      dicOptions: [],
                      required: false,
                      rules: [],
                      events: {},
                      isShow: true,
                      tooltipConfig: { visible: false, title: '提示文本' },
                      prestrainField: 'wxr',
                      listStyle: "return 'border: 0'",
                    },
                  },
                  {
                    key: 'bfec8db130c64e38821416763afbab56',
                    title: '维修状态',
                    dataIndex: 'wxzt',
                    componentType: 'XjrSelect',
                    componentProps: {
                      width: '100%',
                      span: '',
                      placeholder: '',
                      showLabel: true,
                      showSearch: false,
                      isMultiple: false,
                      clearable: false,
                      disabled: true,
                      staticOptions: [
                        { key: 1, label: 'Option 1', value: 'Option 1' },
                        { key: 2, label: 'Option 2', value: 'Option 2' },
                        { key: 3, label: 'Option 3', value: 'Option 3' },
                      ],
                      datasourceType: 'dic',
                      params: { itemId: '2008025127878361090' },
                      labelField: 'name',
                      valueField: 'value',
                      apiConfig: {
                        path: 'CodeGeneration/selection',
                        method: 'GET',
                        apiId: '93d735dcb7364a0f8102188ec4d77ac7',
                      },
                      dicOptions: [],
                      required: false,
                      rules: [],
                      events: {},
                      isShow: true,
                      tooltipConfig: { visible: false, title: '提示文本' },
                      itemId: '2008025127878361090',
                      prestrainField: 'wxzt',
                      listStyle: "return 'border: 0'",
                    },
                  },
                  {
                    key: 'ca60dbd885874d4484cbb8d75f2e89c0',
                    title: '维修完成时间',
                    dataIndex: 'wxsj',
                    componentType: 'DatePicker',
                    defaultValue: '',
                    componentProps: {
                      span: '',
                      defaultValue: '',
                      width: '100%',
                      placeholder: '',
                      format: 'YYYY-MM-DD HH:mm:ss',
                      showLabel: true,
                      allowClear: false,
                      disabled: true,
                      required: false,
                      isShow: true,
                      rules: [],
                      events: {},
                      isGetCurrent: false,
                      tooltipConfig: { visible: false, title: '提示文本' },
                      searchType: 'time',
                      prestrainField: 'wxsj',
                    },
                  },
                  {
                    key: '06b0d5b992f045979949308f72e777fb',
                    title: '维修结果',
                    dataIndex: 'wxjg',
                    componentType: 'Input',
                    defaultValue: '',
                    componentProps: {
                      width: '100%',
                      span: '',
                      defaultValue: '',
                      placeholder: '',
                      prefix: '',
                      suffix: '',
                      addonBefore: '',
                      addonAfter: '',
                      disabled: true,
                      allowClear: false,
                      showLabel: true,
                      required: false,
                      rules: [],
                      events: {},
                      listStyle: '',
                      isSave: false,
                      isShow: true,
                      scan: false,
                      bordered: true,
                      isShowAi: false,
                      tooltipConfig: { visible: false, title: '提示文本' },
                      prestrainField: 'wxjg',
                    },
                  },
                ],
                span: '24',
                preloadType: 'api',
                apiConfig: {
                  path: '/mjgl//jcxx/getMoldLogWx',
                  method: 'GET',
                  apiId: '',
                  apiParams: [
                    {
                      key: '1',
                      title: 'Query Params',
                      tableInfo: [
                        {
                          name: 'mjid',
                          value: '{"bindField":"id","fieldKey":"1d46f7fbade54824b82fbc696318bc93"}',
                          required: false,
                          bindType: 'data',
                        },
                      ],
                    },
                    { key: '2', title: 'Header', tableInfo: [] },
                    { key: '3', title: 'Body' },
                  ],
                  script:
                    'return db.select("select * from mes_mold_log_wx where delete_mark = 0 and mjid = #{mjid}")',
                },
                itemId: '',
                dicOptions: [],
                useSelectButton: false,
                buttonName: '选择数据',
                showLabel: true,
                showComponentBorder: true,
                showBorder: false,
                bordercolor: '#f0f0f0',
                bordershowtype: [true, true, true, true],
                borderwidth: 1,
                showIndex: false,
                isShow: true,
                multipleHeads: [],
                buttonList: [],
                topButtonList: [],
                isExport: false,
                isImport: false,
                isDeleteSelected: false,
                isListView: false,
                viewList: [],
                isShowAdd: false,
                isShowDelete: false,
                hasCheckedCol: false,
                events: {},
                showPagenation: true,
                widths: [
                  {
                    key: '7a5e61fa7c884f1a95c6ab9878b1e2aa',
                    name: '报修单号',
                    bindField: 'bxdh',
                    resizable: false,
                    isEdit: true,
                  },
                  {
                    key: 'f9baa1a6c6154bc5b299b31bec153f16',
                    name: '报修人',
                    bindField: 'bxr',
                    resizable: false,
                    isEdit: true,
                  },
                  {
                    key: '455b258077ab4a02bd8f4ea4735ee077',
                    name: '报修时间',
                    bindField: 'bxsj',
                    resizable: false,
                    isEdit: true,
                  },
                  {
                    key: '494d3999acfb47518d07363fee4420aa',
                    name: '故障描述',
                    bindField: 'gzms',
                    resizable: false,
                    isEdit: true,
                  },
                  {
                    key: 'c12e85a0648a414aa8a155f0a147729e',
                    name: '维修指派人',
                    bindField: 'zpr',
                    resizable: false,
                    isEdit: true,
                  },
                  {
                    key: '05d27e0f95664465a5605dcf99964e2d',
                    name: '维修人',
                    bindField: 'wxr',
                    resizable: false,
                    isEdit: true,
                  },
                  {
                    key: 'bfec8db130c64e38821416763afbab56',
                    name: '维修状态',
                    bindField: 'wxzt',
                    resizable: false,
                    isEdit: true,
                  },
                  {
                    key: 'ca60dbd885874d4484cbb8d75f2e89c0',
                    name: '维修完成时间',
                    bindField: 'wxsj',
                    resizable: false,
                    isEdit: true,
                  },
                  {
                    key: '06b0d5b992f045979949308f72e777fb',
                    name: '维修结果',
                    bindField: 'wxjg',
                    resizable: false,
                    isEdit: true,
                  },
                ],
              },
            },
          ],
        },
      ],
      componentProps: { tabPosition: 'top', size: 'default', type: 'line', isShow: true },
    },
  ],
  showActionButtonGroup: false,
  buttonLocation: 'center',
  actionColOptions: { span: 24 },
  showResetButton: false,
  showSubmitButton: false,
  hiddenComponent: [],
};

export const formButtons = [
  {
    key: 'confirm',
    code: 'confirm',
    name: '确定',
    style: 'primary',
    event: [],
    isShow: true,
    index: 2,
    type: 1,
  },
  {
    key: 'cancel',
    code: 'cancel',
    name: '取消',
    style: 'default',
    event: [],
    isShow: true,
    index: 1,
    type: 1,
  },
  {
    key: 'reset',
    code: 'reset',
    name: '重置',
    style: 'default',
    event: [],
    isShow: true,
    index: 0,
    type: 1,
  },
];
