
import { MesDyxunjianSchemePageModel, MesDyxunjianSchemePageParams, MesDyxunjianSchemePageResult } from './model/YyydxjfaModel';
import { defHttp } from '/@/utils/http/axios';
import { ErrorMessageMode } from '/#/axios';

enum Api {
  Page = '/jcsj/yyydxjfa/page',
  List = '/jcsj/yyydxjfa/list',
  Info = '/jcsj/yyydxjfa/info',
  MesDyxunjianScheme = '/jcsj/yyydxjfa',
  
  
  
}

/**
 * @description: 查询MesDyxunjianScheme分页列表
 */
export async function getMesDyxunjianSchemePage(params: MesDyxunjianSchemePageParams, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<MesDyxunjianSchemePageResult>(
    {
      url: Api.Page,
      params,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 获取MesDyxunjianScheme信息
 */
export async function getMesDyxunjianScheme(id: String, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<MesDyxunjianSchemePageModel>(
    {
      url: Api.Info,
      params: { id },
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 新增MesDyxunjianScheme
 */
export async function addMesDyxunjianScheme(mesDyxunjianScheme: Recordable, mode: ErrorMessageMode = 'modal') {
  return defHttp.post<boolean>(
    {
      url: Api.MesDyxunjianScheme,
      params: mesDyxunjianScheme,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 更新MesDyxunjianScheme
 */
export async function updateMesDyxunjianScheme(mesDyxunjianScheme: Recordable, mode: ErrorMessageMode = 'modal') {
  return defHttp.put<boolean>(
    {
      url: Api.MesDyxunjianScheme,
      params: mesDyxunjianScheme,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 删除MesDyxunjianScheme（批量删除）
 */
export async function deleteMesDyxunjianScheme(ids: string[], mode: ErrorMessageMode = 'modal') {
  return defHttp.delete<boolean>(
    {
      url: Api.MesDyxunjianScheme,
      data: ids,
    },
    {
      errorMessageMode: mode,
    },
  );
}




