import { BasicPageParams, BasicFetchResult } from '/@/api/model/baseModel';

/**
 * @description: MesAlloyStandard分页参数 模型
 */
export interface MesAlloyStandardPageParams extends BasicPageParams {
  code: string;

  name: string;

  kh: string;

  cp: string;

  version: string;

  remark: string;
}

/**
 * @description: MesAlloyStandard分页返回值模型
 */
export interface MesAlloyStandardPageModel {
  id: string;

  code: string;

  name: string;

  remark: string;

  kh: string;

  cp: string;

  version: string;
}

/**
 * @description: MesAlloyStandard表类型
 */
export interface MesAlloyStandardModel {
  id: string;

  deleteMark: string;

  code: string;

  name: string;

  remark: string;

  p1: string;

  p2: string;

  p3: string;

  p4: string;

  p5: string;

  p6: string;

  p7: string;

  p8: string;

  p9: string;

  p10: string;

  createDate: string;

  createUserId: string;

  modifyDate: string;

  modifyUserId: string;

  kh: string;

  cp: string;

  version: string;

  mesAlloyStandardDetailsList?: MesAlloyStandardDetailsModel;
}

/**
 * @description: MesAlloyStandardDetails表类型
 */
export interface MesAlloyStandardDetailsModel {
  id: string;

  deleteMark: string;

  standardId: string;

  productId: string;

  name: string;

  code: string;

  customerStandard: string;

  customerUpperLimit: string;

  customerLowerLimit: string;

  internalStandard: string;

  internalUpperLimit: string;

  internalLowerLimit: string;

  remark: string;

  p1: string;

  p2: string;

  p3: string;

  p4: string;

  p5: string;

  p6: string;

  p7: string;

  p8: string;

  p9: string;

  p10: string;

  createDate: string;

  createUserId: string;

  modifyDate: string;

  modifyUserId: string;
}

/**
 * @description: MesAlloyStandard分页返回值结构
 */
export type MesAlloyStandardPageResult = BasicFetchResult<MesAlloyStandardPageModel>;
