
import { MesWarehouseProfitandlossPageModel, MesWarehouseProfitandlossPageParams, MesWarehouseProfitandlossPageResult } from './model/KcykModel';
import { defHttp } from '/@/utils/http/axios';
import { ErrorMessageMode } from '/#/axios';

enum Api {
  Page = '/ckgl/kcyk/page',
  List = '/ckgl/kcyk/list',
  Info = '/ckgl/kcyk/info',
  MesWarehouseProfitandloss = '/ckgl/kcyk',
  
  
  
}

/**
 * @description: 查询MesWarehouseProfitandloss分页列表
 */
export async function getMesWarehouseProfitandlossPage(params: MesWarehouseProfitandlossPageParams, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<MesWarehouseProfitandlossPageResult>(
    {
      url: Api.Page,
      params,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 获取MesWarehouseProfitandloss信息
 */
export async function getMesWarehouseProfitandloss(id: String, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<MesWarehouseProfitandlossPageModel>(
    {
      url: Api.Info,
      params: { id },
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 新增MesWarehouseProfitandloss
 */
export async function addMesWarehouseProfitandloss(mesWarehouseProfitandloss: Recordable, mode: ErrorMessageMode = 'modal') {
  return defHttp.post<boolean>(
    {
      url: Api.MesWarehouseProfitandloss,
      params: mesWarehouseProfitandloss,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 更新MesWarehouseProfitandloss
 */
export async function updateMesWarehouseProfitandloss(mesWarehouseProfitandloss: Recordable, mode: ErrorMessageMode = 'modal') {
  return defHttp.put<boolean>(
    {
      url: Api.MesWarehouseProfitandloss,
      params: mesWarehouseProfitandloss,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 删除MesWarehouseProfitandloss（批量删除）
 */
export async function deleteMesWarehouseProfitandloss(ids: string[], mode: ErrorMessageMode = 'modal') {
  return defHttp.delete<boolean>(
    {
      url: Api.MesWarehouseProfitandloss,
      data: ids,
    },
    {
      errorMessageMode: mode,
    },
  );
}




