import {
  InventoryFilterParams,
  InventoryItem,
  MesWarehouseInventoryPageModel,
  MesWarehouseInventoryPageParams,
  MesWarehouseInventoryPageResult,
} from './model/KcpdModel';
import { defHttp } from '/@/utils/http/axios';
import { ErrorMessageMode } from '/#/axios';

enum Api {
  Page = '/ckgl/kcpd/page',
  List = '/ckgl/kcpd/list',
  Info = '/ckgl/kcpd/info',
  MesWarehouseInventory = '/ckgl/kcpd',
  Inventory = '/ckgl/kczb/Inventory',
  Export = '/ckgl/kcpd/export',
  
}

export async function getMesWarehouseInventoryPage(
  params: MesWarehouseInventoryPageParams,
  mode: ErrorMessageMode = 'modal',
) {
  return defHttp.get<MesWarehouseInventoryPageResult>(
    {
      url: Api.Page,
      params,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 获取MesWarehouseInventory信息
 */
export async function getMesWarehouseInventory(id: String, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<MesWarehouseInventoryPageModel>(
    {
      url: Api.Info,
      params: { id },
    },
    {
      errorMessageMode: mode,
    },
  );
}

export async function addMesWarehouseInventory(
  mesWarehouseInventory: Recordable,
  mode: ErrorMessageMode = 'modal',
) {
  return defHttp.post<boolean>(
    {
      url: Api.MesWarehouseInventory,
      params: mesWarehouseInventory,
    },
    {
      errorMessageMode: mode,
    },
  );
}

export async function updateMesWarehouseInventory(
  mesWarehouseInventory: Recordable,
  mode: ErrorMessageMode = 'modal',
) {
  return defHttp.put<boolean>(
    {
      url: Api.MesWarehouseInventory,
      params: mesWarehouseInventory,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 删除MesWarehouseInventory（批量删除）
 */
export async function deleteMesWarehouseInventory(ids: string[], mode: ErrorMessageMode = 'modal') {
  return defHttp.delete<boolean>(
    {
      url: Api.MesWarehouseInventory,
      data: ids,
    },
    {
      errorMessageMode: mode,
    },
  );
}

export async function exportMesWarehouseInventory(
  params?: object, 
  mode: ErrorMessageMode = 'modal'
) {
  return defHttp.download(
    {
      url: Api.Export,
      method: 'GET',
      params,
      responseType: 'blob',
    },
    {
      errorMessageMode: mode,
    },
  );
}
  

export async function getInventoryByFilter(
  params: InventoryFilterParams,
  mode: ErrorMessageMode = 'modal',
) {
  return defHttp.post<{ data: InventoryItem[]; success: boolean; msg?: string; code?: number }>(
    {
      url: Api.Inventory,
      data: params,
    },
    {
      errorMessageMode: mode,
    },
  );
}
