import { defHttp } from '/@/utils/http/axios';

import { ErrorMessageMode } from '/#/axios';
import {
  BiReleaseList,
  BiListParams,
  BiReleaseModel,
  BiReleaseListResultModel,
  BiListResultModel,
} from './model/index';

enum Api {
  Page = '/xjr-visual/relation/page',
  List = '/xjr-visual/visual/list-all',
  BiRelease = '/xjr-visual/relation',
  Info = '/xjr-visual/relation/info',
  BILIST = '/xjr-visual/visual/list',
  BiMenu = '/xjr-visual/relation/menu-together-delete',
}

/**
 * @description: 查询所有模板 （不分页）
 */
export async function getBiListAll(params?: BiListParams, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<BiReleaseList[]>(
    {
      url: Api.List,
      params,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 获取模板详情信息
 */
export async function getBiRelease(id: string, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<BiReleaseModel>(
    {
      url: Api.Info,
      params: { id },
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 修改
 */
export async function updateBiRelease(release: Recordable, mode: ErrorMessageMode = 'modal') {
  return defHttp.put<number>(
    {
      url: Api.BiRelease,
      data: release,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 新增
 */
export async function addBiRelease(release: Recordable, mode: ErrorMessageMode = 'modal') {
  return defHttp.post<number>(
    {
      url: Api.BiRelease,
      data: release,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description:  查询所有模板 （分页）
 */
export async function getBiReleasePage(params: Recordable, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<BiReleaseListResultModel>(
    {
      url: Api.Page,
      params,
    },
    {
      errorMessageMode: mode,
    },
  );
}
/**
 * @description:  查询所有模板 （分页）
 */
export async function getBiListPage(params: Recordable, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<BiListResultModel>(
    {
      url: Api.BILIST,
      params,
    },
    {
      errorMessageMode: mode,
    },
  );
}
/**
 * @description: 删除模板（批量删除）
 */
export async function deleteBiRelease(ids: string[], mode: ErrorMessageMode = 'modal') {
  return defHttp.delete<number>(
    {
      url: Api.BiRelease,
      data: ids,
    },
    {
      errorMessageMode: mode,
    },
  );
}
/**
 * @description: 删除Bi和菜单
 */
export async function deleteBiAndMenu(ids: string[], mode: ErrorMessageMode = 'modal') {
  return defHttp.delete<number>(
    {
      url: Api.BiMenu,
      data: ids,
    },
    {
      errorMessageMode: mode,
    },
  );
}
