import type { RouteRecordRaw } from 'vue-router';
import type { App } from 'vue';

import { createRouter, createWebHashHistory } from 'vue-router';
import { basicRoutes } from './routes';
import { baseHandler } from '../../src/layouts/default/setting/handler';
import { HandlerEnum } from '../../src/layouts/default/setting/enum';
import { useMenuSetting } from '/@/hooks/setting/useMenuSetting';
import { useUserStore } from '/@/store/modules/user';

// 白名单应该包含基本静态路由
const WHITE_NAME_LIST: string[] = [];
const getRouteNames = (array: any[]) =>
  array.forEach((item) => {
    WHITE_NAME_LIST.push(item.name);
    getRouteNames(item.children || []);
  });
getRouteNames(basicRoutes);

// app router
// 创建一个可以被 Vue 应用程序使用的路由实例
export const router = createRouter({
  // 创建一个 hash 历史记录。
  history: createWebHashHistory(import.meta.env.VITE_PUBLIC_PATH),
  // 应该添加到路由的初始路由列表。
  routes: basicRoutes as unknown as RouteRecordRaw[],
  // 是否应该禁止尾部斜杠。默认为假
  strict: true,
  scrollBehavior: () => ({ left: 0, top: 0 }),
});

router.beforeResolve(async (to) => {
  const { setMenuSetting } = useMenuSetting();

  if (to.query?.fullScreen === 'true') {
    setMenuSetting({ collapsed: true });
    baseHandler(HandlerEnum.FULL_CONTENT, true);
  } else {
    setMenuSetting({ collapsed: false });
    baseHandler(HandlerEnum.FULL_CONTENT, false);
  }
  const userStore = useUserStore();

  if (to.query?.token) {
    userStore.setToken(to.query?.token as string);
    await userStore.afterLoginAction();
  }
});

// reset router
export function resetRouter() {
  router.getRoutes().forEach((route) => {
    const { name } = route;
    if (name && !WHITE_NAME_LIST.includes(name as string)) {
      router.hasRoute(name) && router.removeRoute(name);
    }
  });
}

// config router
export function setupRouter(app: App<Element>) {
  app.use(router);
}
