
import { MesMoldInfoPageModel, MesMoldInfoPageParams, MesMoldInfoPageResult } from './model/MjdaModel';
import { defHttp } from '/@/utils/http/axios';
import { ErrorMessageMode } from '/#/axios';

enum Api {
  Page = '/mjgl/mjda/page',
  List = '/mjgl/mjda/list',
  Info = '/mjgl/mjda/info',
  MesMoldInfo = '/mjgl/mjda',
  
  
  Export = '/mjgl/mjda/export',
  
}

/**
 * @description: 查询MesMoldInfo分页列表
 */
export async function getMesMoldInfoPage(params: MesMoldInfoPageParams, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<MesMoldInfoPageResult>(
    {
      url: Api.Page,
      params,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 获取MesMoldInfo信息
 */
export async function getMesMoldInfo(id: String, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<MesMoldInfoPageModel>(
    {
      url: Api.Info,
      params: { id },
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 新增MesMoldInfo
 */
export async function addMesMoldInfo(mesMoldInfo: Recordable, mode: ErrorMessageMode = 'modal') {
  return defHttp.post<boolean>(
    {
      url: Api.MesMoldInfo,
      params: mesMoldInfo,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 更新MesMoldInfo
 */
export async function updateMesMoldInfo(mesMoldInfo: Recordable, mode: ErrorMessageMode = 'modal') {
  return defHttp.put<boolean>(
    {
      url: Api.MesMoldInfo,
      params: mesMoldInfo,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 删除MesMoldInfo（批量删除）
 */
export async function deleteMesMoldInfo(ids: string[], mode: ErrorMessageMode = 'modal') {
  return defHttp.delete<boolean>(
    {
      url: Api.MesMoldInfo,
      data: ids,
    },
    {
      errorMessageMode: mode,
    },
  );
}



/**
 * @description: 导出MesMoldInfo
 */
export async function exportMesMoldInfo(
  params?: object, 
  mode: ErrorMessageMode = 'modal'
) {
  return defHttp.download(
    {
      url: Api.Export,
      method: 'GET',
      params,
      responseType: 'blob',
    },
    {
      errorMessageMode: mode,
    },
  );
}
  

