import { BasicPageParams, BasicFetchResult } from '/@/api/model/baseModel';

/**
 * @description: MesQlIncheckreport分页参数 模型
 */
export interface MesQlIncheckreportPageParams extends BasicPageParams {
  code: string;

  name: string;

  sendDate: string;

  checkDate: string;

  checkUser: string;

  supplierName: string;

  buyOrderno: string;

  sendNo: string;

  reportType: string;

  createUserId: string;

  createDateStart: string;
  createDateEnd: string;

  samplingStandard: string;

  sendCount: string;

  samplingCountd: string;

  checkreportNo: string;

  judgeResult: string;

  goodDisMethod: string;

  remark: string;
}

/**
 * @description: MesQlIncheckreport分页返回值模型
 */
export interface MesQlIncheckreportPageModel {
  id: string;

  code: string;

  isSysNum: string;

  name: string;

  sendDate: string;

  checkDate: string;

  checkUser: string;

  supplierName: string;

  buyOrderno: string;

  sendNo: string;

  reportType: string;

  createUserId: string;

  createDate: string;

  samplingStandard: string;

  sendCount: string;

  samplingCountd: string;

  checkreportNo: string;

  judgeResult: string;

  goodDisMethod: string;

  remark: string;
}

/**
 * @description: MesQlIncheckreport表类型
 */
export interface MesQlIncheckreportModel {
  id: number;

  isSysNum: string;

  code: string;

  name: string;

  state: number;

  remark: string;

  sort: number;

  sendDate: string;

  checkDate: string;

  checkUser: string;

  supplierName: string;

  buyOrderno: string;

  sendNo: string;

  reportType: string;

  judgeResult: string;

  goodDisMethod: string;

  samplingStandard: string;

  sendCount: string;

  sampCount: string;

  checkreportNo: string;

  createUserId: number;

  createDate: string;

  modifyUserId: number;

  modifyDate: string;

  deleteMark: number;

  enabledMark: number;

  mesQlIncheckdataList?: MesQlIncheckdataModel;
}

/**
 * @description: MesQlIncheckdata表类型
 */
export interface MesQlIncheckdataModel {
  id: number;

  reportId: number;

  code: string;

  materialId: string;

  materialNo: string;

  materialName: string;

  sendGoodNum: string;

  samplingNum: string;

  checkType: string;

  checkProduct: string;

  checkStandard: string;

  checkMethod: string;

  supplierName: string;

  referenceValue: string;

  upTolerance: string;

  downTolerance: string;

  measuredValue: string;

  judgeResult: string;

  imgFile: string;

  remark: string;

  state: number;

  sort: number;

  createUserId: number;

  createDate: string;

  modifyUserId: number;

  modifyDate: string;

  deleteMark: number;

  enabledMark: number;
}

/**
 * @description: MesQlIncheckreport分页返回值结构
 */
export type MesQlIncheckreportPageResult = BasicFetchResult<MesQlIncheckreportPageModel>;
