import { defHttp } from '/@/utils/http/axios';

export async function getproductStaticList(params, mode: ErrorMessageMode = 'modal') {
  return defHttp.get(
    {
      url: '/mes/common/productStaticList',
      params,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 导出
 */
export async function exportPproductStaticList(params?: object, mode: ErrorMessageMode = 'modal') {
  return defHttp.download(
    {
      url: '/mes/common/productStaticListExport',
      method: 'GET',
      params,
      responseType: 'blob',
    },
    {
      errorMessageMode: mode,
    },
  );
}

export async function getWorkStaticList(params, mode: ErrorMessageMode = 'modal') {
  return defHttp.get(
    {
      url: '/mes/common/workStaticList',
      params,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 导出
 */
export async function exportWorkStaticList(params?: object, mode: ErrorMessageMode = 'modal') {
  return defHttp.download(
    {
      url: '/mes/common/workStaticListExport',
      method: 'GET',
      params,
      responseType: 'blob',
    },
    {
      errorMessageMode: mode,
    },
  );
}

export async function getCheckStaticList(params, mode: ErrorMessageMode = 'modal') {
  return defHttp.get(
    {
      url: '/mes/common/checkStaticList',
      params,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 导出
 */
export async function exportCheckStaticList(params?: object, mode: ErrorMessageMode = 'modal') {
  return defHttp.download(
    {
      url: '/mes/common/checkStaticListExport',
      method: 'GET',
      params,
      responseType: 'blob',
    },
    {
      errorMessageMode: mode,
    },
  );
}

export async function getLostStaticList(params, mode: ErrorMessageMode = 'modal') {
  return defHttp.get(
    {
      url: '/mes/common/lostStaticList',
      params,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 导出
 */
export async function exportLostStaticList(params?: object, mode: ErrorMessageMode = 'modal') {
  return defHttp.download(
    {
      url: '/mes/common/lostStaticListExport',
      method: 'GET',
      params,
      responseType: 'blob',
    },
    {
      errorMessageMode: mode,
    },
  );
}
