
import { MesBaseCertificatePageModel, MesBaseCertificatePageParams, MesBaseCertificatePageResult } from './model/ZsglModel';
import { defHttp } from '/@/utils/http/axios';
import { ErrorMessageMode } from '/#/axios';

enum Api {
  Page = '/jcsj/zsgl/page',
  List = '/jcsj/zsgl/list',
  Info = '/jcsj/zsgl/info',
  MesBaseCertificate = '/jcsj/zsgl',
  
  
  
}

/**
 * @description: 查询MesBaseCertificate分页列表
 */
export async function getMesBaseCertificatePage(params: MesBaseCertificatePageParams, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<MesBaseCertificatePageResult>(
    {
      url: Api.Page,
      params,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 获取MesBaseCertificate信息
 */
export async function getMesBaseCertificate(id: String, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<MesBaseCertificatePageModel>(
    {
      url: Api.Info,
      params: { id },
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 新增MesBaseCertificate
 */
export async function addMesBaseCertificate(mesBaseCertificate: Recordable, mode: ErrorMessageMode = 'modal') {
  return defHttp.post<boolean>(
    {
      url: Api.MesBaseCertificate,
      params: mesBaseCertificate,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 更新MesBaseCertificate
 */
export async function updateMesBaseCertificate(mesBaseCertificate: Recordable, mode: ErrorMessageMode = 'modal') {
  return defHttp.put<boolean>(
    {
      url: Api.MesBaseCertificate,
      params: mesBaseCertificate,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 删除MesBaseCertificate（批量删除）
 */
export async function deleteMesBaseCertificate(ids: string[], mode: ErrorMessageMode = 'modal') {
  return defHttp.delete<boolean>(
    {
      url: Api.MesBaseCertificate,
      data: ids,
    },
    {
      errorMessageMode: mode,
    },
  );
}




