
import { MesDyxunjianItemPageModel, MesDyxunjianItemPageParams, MesDyxunjianItemPageResult } from './model/YyydxjxModel';
import { defHttp } from '/@/utils/http/axios';
import { ErrorMessageMode } from '/#/axios';

enum Api {
  Page = '/jcsj/yyydxjx/page',
  List = '/jcsj/yyydxjx/list',
  Info = '/jcsj/yyydxjx/info',
  MesDyxunjianItem = '/jcsj/yyydxjx',
  
  
  
}

/**
 * @description: 查询MesDyxunjianItem分页列表
 */
export async function getMesDyxunjianItemPage(params: MesDyxunjianItemPageParams, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<MesDyxunjianItemPageResult>(
    {
      url: Api.Page,
      params,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 获取MesDyxunjianItem信息
 */
export async function getMesDyxunjianItem(id: String, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<MesDyxunjianItemPageModel>(
    {
      url: Api.Info,
      params: { id },
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 新增MesDyxunjianItem
 */
export async function addMesDyxunjianItem(mesDyxunjianItem: Recordable, mode: ErrorMessageMode = 'modal') {
  return defHttp.post<boolean>(
    {
      url: Api.MesDyxunjianItem,
      params: mesDyxunjianItem,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 更新MesDyxunjianItem
 */
export async function updateMesDyxunjianItem(mesDyxunjianItem: Recordable, mode: ErrorMessageMode = 'modal') {
  return defHttp.put<boolean>(
    {
      url: Api.MesDyxunjianItem,
      params: mesDyxunjianItem,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 删除MesDyxunjianItem（批量删除）
 */
export async function deleteMesDyxunjianItem(ids: string[], mode: ErrorMessageMode = 'modal') {
  return defHttp.delete<boolean>(
    {
      url: Api.MesDyxunjianItem,
      data: ids,
    },
    {
      errorMessageMode: mode,
    },
  );
}




