import { FormProps, FormSchema } from '/@/components/Form';
import { BasicColumn } from '/@/components/Table';

export const searchFormSchema: FormSchema[] = [
  {
    field: 'orderNo',
    label: '生产订单编号',
    component: 'Input',
    colProps: { span: 8 },
  },
  {
    field: 'saleOrderId',
    label: '销售单号',
    component: 'Input',
    colProps: { span: 8 },
  },
  {
    field: 'productNo',
    label: '产品编号',
    component: 'Input',
    colProps: { span: 8 },
  },
  {
    field: 'productName',
    label: '产品名称',
    component: 'Input',
    colProps: { span: 8 },
  },
  {
    field: 'onlineDate',
    label: '上线日期',
    component: 'RangePicker',
    componentProps: {
      format: 'YYYY-MM-DD',
      style: { width: '100%' },
      getPopupContainer: () => document.body,
    },
    colProps: { span: 8 },
  },

  {
    field: 'priority',
    label: '优先级',
    component: 'XjrSelect',
    componentProps: {
      datasourceType: 'dic',
      params: { itemId: '1689840965516009473' },
      labelField: 'name',
      valueField: 'value',

      getPopupContainer: () => document.body,
    },
    colProps: { span: 8 },
  },
  {
    field: 'planNum',
    label: '计划产量',
    component: 'Input',
    colProps: { span: 8 },
  },
  {
    field: 'state',
    label: '状态',
    component: 'XjrSelect',
    componentProps: {
      datasourceType: 'staticData',
      staticOptions: [
        { key: 1, label: '待计划', value: '1' },
        { key: 2, label: '已计划', value: '2' },
        { key: 3, label: '已作废', value: '3' },
      ],
      labelField: 'label',
      valueField: 'value',

      getPopupContainer: () => document.body,
    },
    colProps: { span: 8 },
  },
  {
    field: 'realNum',
    label: '已生产数量',
    component: 'Input',
    colProps: { span: 8 },
  },
  {
    field: 'remark',
    label: '备注',
    component: 'Input',
    colProps: { span: 8 },
  },
  {
    field: 'speModel',
    label: '规格型号',
    component: 'Input',
    colProps: { span: 8 },
  },
  {
    field: 'unity',
    label: '单位',
    component: 'Input',
    colProps: { span: 8 },
  },
  {
    field: 'createUserId',
    label: '创建人',
    component: 'User',
    componentProps: {
      suffix: 'ant-design:setting-outlined',
      placeholder: '请选择',
    },
    colProps: { span: 8 },
  },

  {
    field: 'createDate',
    label: '创建时间',
    component: 'User',
    componentProps: {
      suffix: 'ant-design:setting-outlined',
      placeholder: '请选择',
    },
    colProps: { span: 8 },
  },
];

export const columns: BasicColumn[] = [
  {
    dataIndex: 'orderNo',
    title: '生产订单编号',
    componentType: 'input',

    sorter: true,
  },

  {
    dataIndex: 'saleOrderId',
    title: '销售单号',
    componentType: 'input',

    sorter: true,
  },

  {
    dataIndex: 'productId',
    title: '产品编码',
    componentType: 'input',

    sorter: true,
  },

  {
    dataIndex: 'productName',
    title: '产品名称',
    componentType: 'input',

    sorter: true,
  },

  {
    dataIndex: 'onlineDate',
    title: '上线日期',
    componentType: 'date',

    sorter: true,
  },

  {
    dataIndex: 'priority',
    title: '优先级',
    componentType: 'select',

    sorter: true,
  },

  {
    dataIndex: 'planNum',
    title: '计划产量',
    componentType: 'input',

    sorter: true,
  },

  {
    dataIndex: 'state',
    title: '状态',
    componentType: 'select',

    customRender: ({ record }) => {
      const staticOptions = [
        { key: 1, label: '待计划', value: '1' },
        { key: 2, label: '已计划', value: '2' },
        { key: 3, label: '已作废', value: '3' },
      ];
      return staticOptions.filter((x) => x.value === record.state)[0]?.label;
    },
    sorter: true,
  },

  {
    dataIndex: 'realNum',
    title: '已生产数量',
    componentType: 'input',

    sorter: true,
  },

  {
    dataIndex: 'remark',
    title: '备注',
    componentType: 'textarea',

    sorter: true,
  },

  {
    dataIndex: 'speModel',
    title: '规格型号',
    componentType: 'input',

    sorter: true,
  },

  {
    dataIndex: 'unity',
    title: '单位',
    componentType: 'input',

    sorter: true,
  },

  // {
  //   dataIndex: 'createUserId',
  //   title: '创建人',
  //   componentType: 'info',

  //   sorter: true,
  // },

  // {
  //   dataIndex: 'createDate',
  //   title: '创建时间',
  //   componentType: 'info',

  //   sorter: true,
  // },
];

export const formProps: FormProps = {
  labelWidth: '100px',
  labelAlign: 'right',
  layout: 'horizontal',
  size: 'default',
  schemas: [
    {
      key: 'd37d753f49684dbe9fdc8413614723d8',
      field: '',
      label: '标题',
      type: 'title',
      component: 'Title',
      colProps: { span: 24 },
      ifShow: true,
      defaultValue: '基础信息',
      componentProps: {
        defaultValue: '基础信息',
        color: '',
        align: 'left',
        fontSize: 15,
        style: {},
      },
    },
    {
      key: '0c80bd9c7ae540d983a757c3c5a7599b',
      field: 'orderNo',
      label: '生产订单号',
      type: 'auto-code',
      component: 'AutoCodeRule',
      colProps: { span: 8 },
      ifShow: true,
      componentProps: {
        width: '100%',
        span: '',
        placeholder: '请输入生产订单号',
        prefix: '',
        suffix: '',
        addonBefore: '',
        addonAfter: '',
        showLabel: true,
        autoCodeRule: 'mesproOrderNo',
        required: true,
        col: 8,
        style: { width: '100%' },
      },
    },
    {
      key: 'bd82ceab51404043bed182258771fdb7',
      field: 'isSysNum',
      label: '',
      type: 'checkbox',
      component: 'ApiCheckboxGroup',
      colProps: { span: 4 },
      ifShow: true,
      componentProps: {
        span: '',
        showLabel: true,
        disabled: false,
        staticOptions: [{ key: 1, label: '使用系统编号', value: '1' }],
        datasourceType: 'staticData',
        defaultSelect: '1',
        labelField: 'label',
        valueField: 'value',
        apiConfig: {},
        dicOptions: [],
        required: false,
        rules: [],
        events: {
          change:
            "//是否使用系统编号事件：\nconst code='orderNo';//编码字段名\nif(formModel.isSysNum==1){\n\tformModel[code]=formModel.codeTemp; formActionType.updateSchema({field:code,componentProps: {readonly:true}});\n}else{\n  formModel.codeTemp=formModel[code];\n  formModel[code]='';\nformActionType.updateSchema({field:code,componentProps: {readonly:false}});\n}",
        },
        col: 4,
        style: {},
      },
    },
    {
      key: 'dc31cef1b3464ee1830318598969cbfd',
      field: 'priority',
      label: '优先级',
      type: 'select',
      component: 'XjrSelect',
      colProps: { span: 24 },
      ifShow: true,
      componentProps: {
        width: '100%',
        span: '',
        placeholder: '请选择',
        showLabel: true,
        showSearch: false,
        clearable: false,
        disabled: false,
        staticOptions: [{ key: 1, label: 'Option 1', value: 'Option 1' }],
        defaultSelect: '',
        datasourceType: 'dic',
        params: { itemId: '1689840965516009473' },
        labelField: 'name',
        valueField: 'value',
        apiConfig: {},
        dicOptions: [],
        required: true,
        rules: [],
        events: {},
        itemId: '1689840965516009473',
        style: { width: '100%' },
      },
    },
    {
      key: '8e12c4cd7d084d4aa1325a8fcce373df',
      field: 'remark',
      label: '备注',
      type: 'textarea',
      component: 'InputTextArea',
      colProps: { span: 24 },
      ifShow: true,
      defaultValue: '',
      componentProps: {
        width: '100%',
        span: '',
        defaultValue: '',
        placeholder: '请输入备注',
        maxlength: null,
        rows: 4,
        autoSize: false,
        showCount: false,
        disabled: false,
        showLabel: true,
        allowClear: false,
        required: false,
        rules: [],
        events: {},
        style: { width: '100%' },
      },
    },
    {
      key: '579e10ba3fb84e0fb6b6027db4cdfddc',
      field: 'createUserId',
      label: '创建人',
      type: 'info',
      component: 'Info',
      colProps: { span: 24 },
      ifShow: false,
      componentProps: {
        span: '',
        width: '100%',
        placeholder: '',
        infoType: 0,
        loadAgain: false,
        showLabel: true,
        disabled: true,
        style: { width: '100%' },
      },
    },
    {
      key: 'c38cff2feb024ebf9361a8a7bb945274',
      field: 'createDate',
      label: '创建时间',
      type: 'info',
      component: 'Info',
      colProps: { span: 24 },
      ifShow: false,
      componentProps: {
        span: '',
        width: '100%',
        placeholder: '',
        infoType: 2,
        loadAgain: false,
        showLabel: true,
        disabled: true,
        style: { width: '100%' },
      },
    },
    {
      key: 'bf6788f307034f29b918d2e70a910b5b',
      field: '',
      label: '标题',
      type: 'title',
      component: 'Title',
      colProps: { span: 24 },
      ifShow: true,
      defaultValue: '产品明细',
      componentProps: {
        defaultValue: '产品明细',
        color: '',
        align: 'left',
        fontSize: 15,
        style: {},
      },
    },
    {
      key: '97b1ffc35601418bb83d43be9cd07571',
      label: '',
      field: 'mesProOrderDetailList',
      type: 'form',
      component: 'SubForm',
      required: true,
      colProps: { span: 24 },
      componentProps: {
        mainKey: 'mesProOrderDetailList',
        columns: [
          {
            key: '33c983ef96f14512bb55a86943992152',
            title: '销售单号ID',
            dataIndex: 'saleOrderId',
            componentType: 'AssociateSelect',
            show: false,
            componentProps: {
              rules: [],
              valueField: 'value',
              showLabel: true,
              required: false,
              labelField: 'label',
              datasourceType: 'api',
              dicOptions: [],
              showSearch: false,
              width: '100%',
              apiConfig: {
                method: 'GET',
                script:
                  'var condition="";\r\n\r\nreturn db.select("SELECT t.id AS `key` ,t.id AS `value`,t.sale_number AS label,t.* FROM case_erp_sale t where audit_state=3  "+condition)',
                apiParams: [
                  {
                    tableInfo: [
                      { dataType: 'String', bindType: '', required: false, name: 'keyword' },
                      {
                        defaultValue: 'code',
                        dataType: 'String',
                        bindType: 'value',
                        description: '回显字段',
                        required: false,
                        name: 'showLabel',
                        value: 'code',
                      },
                      {
                        dataType: 'String',
                        bindType: 'value',
                        description: '查询类型',
                        required: false,
                        name: 'queryType',
                        value: 'sc',
                      },
                    ],
                    title: 'Query Params',
                    key: '1',
                  },
                  { tableInfo: [], title: 'Header', key: '2' },
                  { title: 'Body', key: '3' },
                ],
                path: '/mes/getSaleOrderList',
                apiId: 'copy1690958013341d31983',
              },
              disabled: false,
              placeholder: '请选择',
              events: {},
              span: '',
              prestrainField: 'sale_id',
            },
          },
          {
            key: '98748f978a2b4e01adbdb82cba77bdfa',
            title: '销售单号',
            dataIndex: 'saleOrderNo',
            componentType: 'Input',
            defaultValue: '',
            componentProps: {
              width: '100%',
              span: '',
              defaultValue: '',
              placeholder: '请输入销售单号',
              maxlength: null,
              prefix: '',
              suffix: '',
              addonBefore: '',
              addonAfter: '',
              disabled: true,
              allowClear: false,
              showLabel: true,
              required: false,
              rules: [],
              events: {},
              prestrainField: 'sale_number',
            },
          },
          {
            key: 'be896e7f9d734bf4a478909bb16471fb',
            title: '产品编码',
            dataIndex: 'productNo',
            componentType: 'Input',
            defaultValue: '',
            componentProps: {
              width: '100%',
              span: '',
              defaultValue: '',
              placeholder: '请输入产品编码',
              maxlength: null,
              prefix: '',
              suffix: '',
              addonBefore: '',
              addonAfter: '',
              disabled: true,
              allowClear: false,
              showLabel: true,
              required: false,
              rules: [],
              events: {},
              prestrainField: 'code',
            },
          },
          {
            key: 'b7cbb6c8c133465a849578b765a03f89',
            title: '产品ID',
            dataIndex: 'productId',
            componentType: 'AssociateSelect',
            show: false,
            componentProps: {
              rules: [],
              valueField: 'value',
              showLabel: true,
              required: false,
              labelField: 'label',
              datasourceType: 'api',
              dicOptions: [],
              showSearch: false,
              width: '100%',
              apiConfig: {
                method: 'GET',
                script:
                  'var condition="";\r\nif(sale_id!=null&&sale_id!=""){ \r\n    condition+=" and sale_id=#{sale_id}";\r\n}\r\nreturn db.select("SELECT t.id AS `key` ,t.id AS `value`,t.code AS label,t.* FROM case_erp_sale_detail t where 1=1  "+condition)',
                apiParams: [
                  {
                    tableInfo: [
                      { dataType: 'String', bindType: '', required: false, name: 'keyword' },
                      {
                        defaultValue: 'code',
                        dataType: 'String',
                        bindType: 'value',
                        description: '回显字段',
                        required: false,
                        name: 'showLabel',
                        value: 'code',
                      },
                      {
                        dataType: 'String',
                        bindType: '',
                        description: '查询类型',
                        required: false,
                        name: 'queryType',
                      },
                      {
                        dataType: 'String',
                        bindType: 'value',
                        description: '销售订单ID',
                        required: false,
                        name: 'sale_id',
                        value: '',
                      },
                    ],
                    title: 'Query Params',
                    key: '1',
                  },
                  { tableInfo: [], title: 'Header', key: '2' },
                  { title: 'Body', key: '3' },
                ],
                path: '/mes/getSaleOrderProductList',
                outputParams: [{ bindField: 'product_name', name: 'product_name' }],
                apiId: 'copy1691460260596d60862',
              },
              disabled: false,
              placeholder: '请选择',
              events: {},
              span: '',
              prestrainField: 'code',
            },
          },
          {
            key: 'b895da75e830495c8d4ff0a425e8e687',
            title: '产品名称',
            dataIndex: 'productName',
            componentType: 'Input',
            defaultValue: '',
            componentProps: {
              defaultValue: '',
              prefix: '',
              rules: [],
              suffix: '',
              addonAfter: '',
              showLabel: true,
              required: false,
              width: '100%',
              disabled: true,
              placeholder: '',
              allowClear: false,
              addonBefore: '',
              events: {},
              span: '',
              prestrainField: 'name',
            },
          },
          {
            key: '37fb118c17544118be39dc4ea01e1d1e',
            title: '规格型号',
            dataIndex: 'speModel',
            componentType: 'Input',
            defaultValue: '',
            componentProps: {
              defaultValue: '',
              prefix: '',
              rules: [],
              suffix: '',
              addonAfter: '',
              showLabel: true,
              required: false,
              width: '100%',
              disabled: true,
              placeholder: '',
              allowClear: false,
              addonBefore: '',
              events: {},
              span: '',
              prestrainField: 'model',
            },
          },
          {
            key: '23cbed159a7749659f500992e0d46933',
            title: '单位',
            dataIndex: 'unity',
            componentType: 'Input',
            defaultValue: '',
            componentProps: {
              defaultValue: '',
              prefix: '',
              rules: [],
              suffix: '',
              addonAfter: '',
              showLabel: true,
              required: false,
              width: '100%',
              disabled: true,
              placeholder: '',
              allowClear: false,
              addonBefore: '',
              events: {},
              span: '',
              prestrainField: 'unit_name',
            },
          },
          {
            key: '09f6b12c5176483b88044d318f13d807',
            title: '计划产量',
            dataIndex: 'planNum',
            componentType: 'InputNumber',
            componentProps: {
              controls: true,
              max: 100,
              rules: [],
              subTotal: false,
              showLabel: true,
              required: false,
              min: 0,
              width: '100%',
              step: 1,
              disabled: false,
              events: {},
              span: '',
              prestrainField: 'count',
            },
          },
          {
            key: '978b5193ff4b43d6ab8132df92661578',
            title: '上线日期',
            dataIndex: 'onlineDate',
            componentType: 'DatePicker',
            defaultValue: '',
            componentProps: {
              defaultValue: '',
              format: 'YYYY-MM-DD',
              rules: [],
              showLabel: true,
              required: false,
              width: '100%',
              disabled: false,
              placeholder: '请选择',
              allowClear: true,
              events: {},
              span: '',
            },
          },
          { title: '操作', key: 'action', fixed: 'right', width: '50px' },
        ],
        buttonName: '选择',
        showIndex: false,
        useSelectButton: true,
        useAddButton: false, //不显示新增按钮
        preloadType: 'api',
        showLabel: true,
        itemId: '',
        multipleHeads: [],
        dicOptions: [],
        showComponentBorder: true,
        apiConfig: {
          path: '/mes/getSaleOrderProductList',
          method: 'GET',
          apiId: 'copy1691460260596d60862',
          apiParams: [
            {
              key: '1',
              title: 'Query Params',
              tableInfo: [
                {
                  name: 'keyword',
                  value: null,
                  description: null,
                  required: false,
                  dataType: 'String',
                  type: null,
                  defaultValue: null,
                  validateType: null,
                  error: null,
                  expression: null,
                  children: null,
                  bindType: '',
                },
                {
                  name: 'showLabel',
                  value: '',
                  description: '回显字段',
                  required: false,
                  dataType: 'String',
                  type: null,
                  defaultValue: 'code',
                  validateType: null,
                  error: null,
                  expression: null,
                  children: null,
                  bindType: '',
                },
                {
                  name: 'queryType',
                  value: null,
                  description: '查询类型',
                  required: false,
                  dataType: 'String',
                  type: null,
                  defaultValue: null,
                  validateType: null,
                  error: null,
                  expression: null,
                  children: null,
                  bindType: '',
                },
                {
                  name: 'sale_id',
                  value: '',
                  description: '销售订单ID',
                  required: false,
                  dataType: 'String',
                  type: null,
                  defaultValue: null,
                  validateType: null,
                  error: null,
                  expression: null,
                  children: null,
                  bindType: '',
                },
              ],
            },
            { key: '2', title: 'Header', tableInfo: [] },
            { key: '3', title: 'Body' },
          ],
          script:
            'var condition="";\r\nif(sale_id!=null&&sale_id!=""){ \r\n    condition+=" and sale_id=#{sale_id}";\r\n}\r\nreturn db.select("SELECT t.id AS `key` ,t.id AS `value`,t.code AS label,t.* FROM case_erp_sale_detail t where 1=1  "+condition)',
          outputParams: [
            { tableTitle: '销售单号', name: 'sale_number' },
            { tableTitle: '产品编码', name: 'code' },
            { tableTitle: '产品名称', name: 'name' },
            { tableTitle: '规格型号', name: 'model' },
            { tableTitle: '单位', name: 'unit_name' },
            { tableTitle: '订单数量', name: 'count' },
          ],
        },
        showFormBorder: true,
        span: '24',
      },
    },
  ],
  showActionButtonGroup: false,
  buttonLocation: 'center',
  actionColOptions: { span: 24 },
  showResetButton: false,
  showSubmitButton: false,
  hiddenComponent: [],
};
