import { FormProps, FormSchema } from '/@/components/Form';
import { BasicColumn } from '/@/components/Table';
import { uploadApi } from '/@/api/sys/upload';

export const searchFormSchema: FormSchema[] = [
  {
    field: 'kczz',
    label: '库存组织',
    defaultValue: undefined,
    component: 'Input',
  },
  {
    field: 'ck',
    label: '仓库',
    defaultValue: undefined,
    component: 'Input',
  },
  {
    field: 'kgy',
    label: '库管员',
    defaultValue: undefined,
    component: 'Input',
  },
  {
    field: 'scbm',
    label: '生产部门',
    defaultValue: undefined,
    component: 'Input',
  },
];

export const columns: BasicColumn[] = [
  {
    resizable: true,
    dataIndex: 'kczz',
    title: '库存组织',
    componentType: 'input',

    fixed: false,
    sorter: true,

    styleConfig: undefined,
    listStyle: '',
  },

  {
    resizable: true,
    dataIndex: 'djrq',
    title: '单据日期',
    componentType: 'date',

    fixed: false,
    sorter: true,

    styleConfig: undefined,
    listStyle: undefined,
  },

  {
    resizable: true,
    dataIndex: 'ck',
    title: '仓库',
    componentType: 'input',

    fixed: false,
    sorter: true,

    styleConfig: undefined,
    listStyle: '',
  },

  {
    resizable: true,
    dataIndex: 'crklx',
    title: '出入库类型',
    componentType: 'select',

    fixed: false,
    sorter: true,

    styleConfig: undefined,
    listStyle: undefined,
  },

  {
    resizable: true,
    dataIndex: 'kgy',
    title: '库管员',
    componentType: 'input',

    fixed: false,
    sorter: true,

    styleConfig: undefined,
    listStyle: '',
  },

  {
    resizable: true,
    dataIndex: 'scbm',
    title: '生产部门',
    componentType: 'input',

    fixed: false,
    sorter: true,

    styleConfig: undefined,
    listStyle: '',
  },

  {
    resizable: true,
    dataIndex: 'djbh',
    title: '单据编号',
    componentType: 'input',

    fixed: false,
    sorter: true,

    styleConfig: undefined,
    listStyle: '',
  },

  {
    resizable: true,
    dataIndex: 'djzt',
    title: '单据状态',
    componentType: 'input',

    fixed: false,
    sorter: true,

    styleConfig: undefined,
    listStyle: '',
  },
];
//表头合并配置
export const headerMergingData = [];
//表单事件
export const formEventConfigs = {
  0: [
    {
      type: 'circle',
      color: '#2774ff',
      text: '开始节点',
      icon: '#icon-kaishi',
      bgcColor: '#D8E5FF',
      isUserDefined: false,
    },
    {
      color: '#F6AB01',
      icon: '#icon-chushihua',
      text: '初始化表单',
      bgcColor: '#f9f5ea',
      isUserDefined: false,
      nodeInfo: { processEvent: [] },
    },
  ],
  1: [
    {
      color: '#B36EDB',
      icon: '#icon-shujufenxi',
      text: '获取表单数据',
      detail: '(新增无此操作)',
      bgcColor: '#F8F2FC',
      isUserDefined: false,
      nodeInfo: { processEvent: [] },
    },
  ],
  2: [
    {
      color: '#F8625C',
      icon: '#icon-jiazai',
      text: '加载表单',
      bgcColor: '#FFF1F1',
      isUserDefined: false,
      nodeInfo: { processEvent: [] },
    },
  ],
  3: [
    {
      color: '#6C6AE0',
      icon: '#icon-jsontijiao',
      text: '提交表单',
      bgcColor: '#F5F4FF',
      isUserDefined: false,
      nodeInfo: { processEvent: [] },
    },
  ],
  4: [
    {
      type: 'circle',
      color: '#F8625C',
      text: '结束节点',
      icon: '#icon-jieshuzhiliao',
      bgcColor: '#FFD6D6',
      isLast: true,
      isUserDefined: false,
    },
  ],
};
export const formProps: FormProps = {
  labelCol: { span: 3, offset: 0 },
  labelAlign: 'right',
  layout: 'horizontal',
  size: 'default',
  schemas: [
    {
      key: '788870e67cd14e66a2eef933479871eb',
      field: '',
      label: '',
      type: 'grid',
      colProps: { span: 24 },
      component: 'Grid',
      children: [
        {
          span: 8,
          list: [
            {
              key: 'b7fc1a99eb11469fbffd723f8ce0629f',
              field: 'kczz',
              label: '库存组织',
              type: 'input',
              component: 'Input',
              colProps: { span: 24 },
              defaultValue: '',
              componentProps: {
                width: '100%',
                span: 7,
                defaultValue: '',
                placeholder: '请输入库存组织',
                maxlength: null,
                prefix: '',
                suffix: '',
                addonBefore: '',
                addonAfter: '',
                disabled: false,
                allowClear: false,
                showLabel: true,
                required: true,
                rules: [],
                events: {},
                listStyle: '',
                isSave: false,
                isShow: true,
                scan: false,
                bordered: true,
                isShowAi: false,
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
          ],
        },
        {
          span: 8,
          list: [
            {
              key: '771aa5416a5f45bbaf9229eb8fd095fd',
              field: 'djrq',
              label: '单据日期',
              type: 'date',
              component: 'DatePicker',
              colProps: { span: 24 },
              defaultValue: '',
              componentProps: {
                span: 7,
                defaultValue: '',
                width: '100%',
                placeholder: '请选择单据日期',
                format: 'YYYY-MM-DD HH:mm:ss',
                showLabel: true,
                allowClear: true,
                disabled: false,
                required: false,
                isShow: true,
                rules: [],
                events: {},
                isGetCurrent: false,
                tooltipConfig: { visible: false, title: '提示文本' },
                searchType: 'time',
                style: { width: '100%' },
              },
            },
          ],
        },
        {
          span: 8,
          list: [
            {
              key: '0f17a0106f2348bbbc3d19889815b9c7',
              field: 'ck',
              label: '仓库',
              type: 'input',
              component: 'Input',
              colProps: { span: 24 },
              defaultValue: '',
              componentProps: {
                width: '100%',
                span: 7,
                defaultValue: '',
                placeholder: '请输入仓库',
                maxlength: null,
                prefix: '',
                suffix: '',
                addonBefore: '',
                addonAfter: '',
                disabled: false,
                allowClear: false,
                showLabel: true,
                required: false,
                rules: [],
                events: {},
                listStyle: '',
                isSave: false,
                isShow: true,
                scan: false,
                bordered: true,
                isShowAi: false,
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
          ],
        },
        {
          span: 8,
          list: [
            {
              key: '2ebc5694329846dc975c563118968daa',
              field: 'crklx',
              label: '出入库类型',
              type: 'select',
              component: 'XjrSelect',
              colProps: { span: 24 },
              componentProps: {
                width: '100%',
                span: 7,
                placeholder: '请选择出入库类型',
                showLabel: true,
                showSearch: false,
                isMultiple: false,
                clearable: false,
                disabled: false,
                staticOptions: [
                  { key: 1, label: 'Option 1', value: 'Option 1' },
                  { key: 2, label: 'Option 2', value: 'Option 2' },
                  { key: 3, label: 'Option 3', value: 'Option 3' },
                ],
                defaultSelect: '2',
                datasourceType: 'dic',
                params: { itemId: '2010533622867509249' },
                labelField: 'name',
                valueField: 'value',
                apiConfig: {
                  path: 'CodeGeneration/selection',
                  method: 'GET',
                  apiId: '93d735dcb7364a0f8102188ec4d77ac7',
                },
                dicOptions: [],
                required: false,
                rules: [],
                events: {},
                isShow: true,
                tooltipConfig: { visible: false, title: '提示文本' },
                itemId: '2010533622867509249',
                style: { width: '100%' },
              },
            },
          ],
        },
        {
          span: 8,
          list: [
            {
              key: '6948582a4bcc4ed59c2a9e20b0eb0a40',
              field: 'kgy',
              label: '库管员',
              type: 'input',
              component: 'Input',
              colProps: { span: 24 },
              defaultValue: '',
              componentProps: {
                width: '100%',
                span: 7,
                defaultValue: '',
                placeholder: '请输入库管员',
                maxlength: null,
                prefix: '',
                suffix: '',
                addonBefore: '',
                addonAfter: '',
                disabled: false,
                allowClear: false,
                showLabel: true,
                required: false,
                rules: [],
                events: {},
                listStyle: '',
                isSave: false,
                isShow: true,
                scan: false,
                bordered: true,
                isShowAi: false,
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
          ],
        },
        {
          span: 8,
          list: [
            {
              key: '4974e34247094ea5bce99f66f4169b27',
              field: 'scbm',
              label: '生产部门',
              type: 'input',
              component: 'Input',
              colProps: { span: 24 },
              defaultValue: '',
              componentProps: {
                width: '100%',
                span: 7,
                defaultValue: '',
                placeholder: '请输入生产部门',
                maxlength: null,
                prefix: '',
                suffix: '',
                addonBefore: '',
                addonAfter: '',
                disabled: false,
                allowClear: false,
                showLabel: true,
                required: false,
                rules: [],
                events: {},
                listStyle: '',
                isSave: false,
                isShow: true,
                scan: false,
                bordered: true,
                isShowAi: false,
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
          ],
        },
        {
          span: 8,
          list: [
            {
              key: 'd5e600afe891410882c273a7bc1b2ca2',
              field: 'djbh',
              label: '单据编号',
              type: 'input',
              component: 'Input',
              colProps: { span: 24 },
              defaultValue: '',
              componentProps: {
                width: '100%',
                span: 7,
                defaultValue: '',
                placeholder: '请输入单据编号',
                maxlength: null,
                prefix: '',
                suffix: '',
                addonBefore: '',
                addonAfter: '',
                disabled: false,
                allowClear: false,
                showLabel: true,
                required: false,
                rules: [],
                events: {},
                listStyle: '',
                isSave: false,
                isShow: true,
                scan: false,
                bordered: true,
                isShowAi: false,
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
          ],
        },
        {
          span: 8,
          list: [
            {
              key: '320589395feb4544a4c0b9ff283e3b2f',
              field: 'djzt',
              label: '单据状态',
              type: 'input',
              component: 'Input',
              colProps: { span: 24 },
              defaultValue: '',
              componentProps: {
                width: '100%',
                span: 7,
                defaultValue: '',
                placeholder: '请输入单据状态',
                maxlength: null,
                prefix: '',
                suffix: '',
                addonBefore: '',
                addonAfter: '',
                disabled: false,
                allowClear: false,
                showLabel: true,
                required: false,
                rules: [],
                events: {},
                listStyle: '',
                isSave: false,
                isShow: true,
                scan: false,
                bordered: true,
                isShowAi: false,
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
          ],
        },
        {
          span: 8,
          list: [
            {
              key: '904dcc9c92f2492eba6f775a2602847b',
              field: 'fj',
              label: '上传附件',
              type: 'upload',
              component: 'Upload',
              colProps: { span: 24 },
              componentProps: {
                api: uploadApi,
                span: 7,
                defaultValue: '',
                accept: '',
                maxNumber: 5,
                maxSize: 5,
                showLabel: true,
                multiple: false,
                disabled: false,
                required: false,
                isShow: true,
                events: {},
                listType: 'text',
                sourceType: 'album,camera',
                tooltipConfig: { visible: false, title: '提示文本' },
              },
            },
          ],
        },
        {
          span: 24,
          list: [
            {
              key: '90b34658b2bd49f89270a0e864587f62',
              field: 'bz',
              label: '备注',
              type: 'input',
              component: 'Input',
              colProps: { span: 24 },
              defaultValue: '',
              componentProps: {
                width: '100%',
                span: 2,
                defaultValue: '',
                placeholder: '请输入备注',
                maxlength: null,
                prefix: '',
                suffix: '',
                addonBefore: '',
                addonAfter: '',
                disabled: false,
                allowClear: false,
                showLabel: true,
                required: false,
                rules: [],
                events: {},
                listStyle: '',
                isSave: false,
                isShow: true,
                scan: false,
                bordered: true,
                isShowAi: false,
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
          ],
        },
        {
          span: 8,
          list: [
            {
              key: 'bf9dbbefa3ed4ba08f51998b263f227e',
              field: 'id',
              label: 'ID',
              type: 'input',
              component: 'Input',
              colProps: { span: 24 },
              defaultValue: '',
              componentProps: {
                width: '100%',
                span: 7,
                defaultValue: '',
                placeholder: '',
                maxlength: null,
                prefix: '',
                suffix: '',
                addonBefore: '',
                addonAfter: '',
                disabled: false,
                allowClear: false,
                showLabel: true,
                required: false,
                rules: [],
                events: {},
                listStyle: '',
                isSave: false,
                isShow: false,
                scan: false,
                bordered: true,
                isShowAi: false,
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
          ],
        },
      ],
      componentProps: {
        gutter: 16,
        justify: 'start',
        align: 'top',
        isShow: true,
        showBorder: false,
        bordercolor: '#d9d9d9',
        bordershowtype: [true, true, true, true],
        borderwidth: 1,
        padding: '10px',
        margin: '10px',
      },
    },
    {
      key: '82fc7feecfa140368698bd80d6cae114',
      label: '',
      field: 'mesWarehouseProductInfoList',
      type: 'form',
      component: 'SubForm',
      required: true,
      colProps: { span: 24 },
      componentProps: {
        mainKey: 'mesWarehouseProductInfoList',
        columns: [
          {
            key: '67758677bce44720b4af09091d5590f3',
            title: '物料编码',
            dataIndex: 'wlbm',
            componentType: 'Input',
            defaultValue: '',
            componentProps: {
              width: '100%',
              span: '',
              defaultValue: '',
              placeholder: '请输入物料编码',
              maxlength: null,
              prefix: '',
              suffix: '',
              addonBefore: '',
              addonAfter: '',
              disabled: false,
              allowClear: false,
              showLabel: true,
              required: true,
              rules: [],
              events: {},
              listStyle: '',
              isSave: false,
              isShow: true,
              scan: false,
              bordered: true,
              isShowAi: false,
              tooltipConfig: { visible: false, title: '提示文本' },
            },
          },
          {
            key: '90eb56185b5c419b9f0d7d6179beed9b',
            title: '物料名称',
            dataIndex: 'wlmc',
            componentType: 'Input',
            defaultValue: '',
            componentProps: {
              width: '100%',
              span: '',
              defaultValue: '',
              placeholder: '请输入物料名称',
              maxlength: null,
              prefix: '',
              suffix: '',
              addonBefore: '',
              addonAfter: '',
              disabled: false,
              allowClear: false,
              showLabel: true,
              required: false,
              rules: [],
              events: {},
              listStyle: '',
              isSave: false,
              isShow: true,
              scan: false,
              bordered: true,
              isShowAi: false,
              tooltipConfig: { visible: false, title: '提示文本' },
            },
          },
          {
            key: 'e5b7433c899c4af095639be8726ede96',
            title: '规格',
            dataIndex: 'gg',
            componentType: 'Input',
            defaultValue: '',
            componentProps: {
              width: '100%',
              span: '',
              defaultValue: '',
              placeholder: '请输入规格',
              maxlength: null,
              prefix: '',
              suffix: '',
              addonBefore: '',
              addonAfter: '',
              disabled: false,
              allowClear: false,
              showLabel: true,
              required: false,
              rules: [],
              events: {},
              listStyle: '',
              isSave: false,
              isShow: true,
              scan: false,
              bordered: true,
              isShowAi: false,
              tooltipConfig: { visible: false, title: '提示文本' },
            },
          },
          {
            key: '3d33a3a9e46545c5ba831660038ebc88',
            title: '型号',
            dataIndex: 'xh',
            componentType: 'Input',
            defaultValue: '',
            componentProps: {
              width: '100%',
              span: '',
              defaultValue: '',
              placeholder: '请输入型号',
              maxlength: null,
              prefix: '',
              suffix: '',
              addonBefore: '',
              addonAfter: '',
              disabled: false,
              allowClear: false,
              showLabel: true,
              required: false,
              rules: [],
              events: {},
              listStyle: '',
              isSave: false,
              isShow: true,
              scan: false,
              bordered: true,
              isShowAi: false,
              tooltipConfig: { visible: false, title: '提示文本' },
            },
          },
          {
            key: 'f4f6844ab6454be7af329f780e80447f',
            title: '批次号',
            dataIndex: 'pch',
            componentType: 'Input',
            defaultValue: '',
            componentProps: {
              width: '100%',
              span: '',
              defaultValue: '',
              placeholder: '请输入批次号',
              maxlength: null,
              prefix: '',
              suffix: '',
              addonBefore: '',
              addonAfter: '',
              disabled: false,
              allowClear: false,
              showLabel: true,
              required: false,
              rules: [],
              events: {},
              listStyle: '',
              isSave: false,
              isShow: true,
              scan: false,
              bordered: true,
              isShowAi: false,
              tooltipConfig: { visible: false, title: '提示文本' },
            },
          },
          {
            key: '5d9a11c345e24ff59f416012ae5fb4c1',
            title: '货位',
            dataIndex: 'hw',
            componentType: 'Input',
            defaultValue: '',
            componentProps: {
              width: '100%',
              span: '',
              defaultValue: '',
              placeholder: '请输入货位',
              maxlength: null,
              prefix: '',
              suffix: '',
              addonBefore: '',
              addonAfter: '',
              disabled: false,
              allowClear: false,
              showLabel: true,
              required: false,
              rules: [],
              events: {},
              listStyle: '',
              isSave: false,
              isShow: true,
              scan: false,
              bordered: true,
              isShowAi: false,
              tooltipConfig: { visible: false, title: '提示文本' },
            },
          },
          {
            key: 'daec33570ef04811860b88bfe4b743d7',
            title: '实收件数',
            dataIndex: 'ssjs',
            componentType: 'Input',
            defaultValue: '',
            componentProps: {
              width: '100%',
              span: '',
              defaultValue: '',
              placeholder: '请输入实收件数',
              maxlength: null,
              prefix: '',
              suffix: '',
              addonBefore: '',
              addonAfter: '',
              disabled: false,
              allowClear: false,
              showLabel: true,
              required: false,
              rules: [],
              events: {},
              listStyle: '',
              isSave: false,
              isShow: true,
              scan: false,
              bordered: true,
              isShowAi: false,
              tooltipConfig: { visible: false, title: '提示文本' },
            },
          },
          {
            key: 'b15dfaeae0884f338b4bfcd631d3e16e',
            title: '备注',
            dataIndex: 'bz',
            componentType: 'Input',
            defaultValue: '',
            componentProps: {
              width: '100%',
              span: '',
              defaultValue: '',
              placeholder: '请输入备注',
              maxlength: null,
              prefix: '',
              suffix: '',
              addonBefore: '',
              addonAfter: '',
              disabled: false,
              allowClear: false,
              showLabel: true,
              required: false,
              rules: [],
              events: {},
              listStyle: '',
              isSave: false,
              isShow: true,
              scan: false,
              bordered: true,
              isShowAi: false,
              tooltipConfig: { visible: false, title: '提示文本' },
            },
          },
          {
            key: '4cb64c1c2b6f4ae5a0a03cafd47a1669',
            title: 'ID',
            dataIndex: 'id',
            componentType: 'Input',
            defaultValue: '',
            componentProps: {
              width: '100%',
              span: '',
              defaultValue: '',
              placeholder: '',
              maxlength: null,
              prefix: '',
              suffix: '',
              addonBefore: '',
              addonAfter: '',
              disabled: false,
              allowClear: false,
              showLabel: true,
              required: false,
              rules: [],
              events: {},
              listStyle: '',
              isSave: false,
              isShow: false,
              scan: false,
              bordered: true,
              isShowAi: false,
              tooltipConfig: { visible: false, title: '提示文本' },
            },
          },
          { title: '操作', key: 'action', fixed: 'right', width: '50px' },
        ],
        span: '24',
        preloadType: 'api',
        apiConfig: {},
        itemId: '',
        dicOptions: [],
        useSelectButton: false,
        buttonName: '选择物料',
        showLabel: true,
        showComponentBorder: true,
        showBorder: false,
        bordercolor: '#f0f0f0',
        bordershowtype: [true, true, true, true],
        borderwidth: 1,
        showIndex: false,
        isShow: true,
        multipleHeads: [],
        buttonList: [],
        topButtonList: [],
        isExport: false,
        isImport: false,
        isDeleteSelected: false,
        isListView: false,
        viewList: [],
        isShowAdd: true,
        isShowDelete: true,
        hasCheckedCol: false,
        events: {},
        showPagenation: true,
      },
    },
  ],
  showActionButtonGroup: false,
  buttonLocation: 'center',
  actionColOptions: { span: 24 },
  showResetButton: false,
  showSubmitButton: false,
  hiddenComponent: [],
};
