import { BasicPageParams, BasicFetchResult } from '/@/api/model/baseModel';

/**
 * @description: MesQualityInspectionPlan分页参数 模型
 */
export interface MesQualityInspectionPlanPageParams extends BasicPageParams {
  bh: string;

  fzr: string;

  fams: string;

  mc: string;

  fasx: string;

  jclx: string;

  zjfs: string;
}

/**
 * @description: MesQualityInspectionPlan分页返回值模型
 */
export interface MesQualityInspectionPlanPageModel {
  id: string;

  bh: string;

  mc: string;

  fzr: string;

  fasx: string;

  jclx: string;

  zjfs: string;

  fams: string;
}

/**
 * @description: MesQualityInspectionPlan表类型
 */
export interface MesQualityInspectionPlanModel {
  id: string;

  deleteMark: string;

  bh: string;

  mc: string;

  jclx: string;

  fasx: string;

  zjfs: string;

  fams: string;

  fzr: string;

  bz: string;

  p1: string;

  p2: string;

  p3: string;

  p4: string;

  p5: string;

  p6: string;

  p7: string;

  p8: string;

  p9: string;

  p10: string;

  createDate: string;

  createUserId: string;

  modifyDate: string;

  modifyUserId: string;

  mesQuailtyInspectionProjectList?: MesQuailtyInspectionProjectModel;
}

/**
 * @description: MesQuailtyInspectionProject表类型
 */
export interface MesQuailtyInspectionProjectModel {
  id: string;

  deleteMark: string;

  inspectionId: string;

  bh: string;

  mc: string;

  bz: string;

  xmlb: string;

  sjlx: string;

  bzz: string;

  sx: string;

  xx: string;

  p1: string;

  p2: string;

  p3: string;

  p4: string;

  p5: string;

  p6: string;

  p7: string;

  p8: string;

  p9: string;

  p10: string;

  createDate: string;

  createUserId: string;

  modifyDate: string;

  modifyUserId: string;
}

/**
 * @description: MesQualityInspectionPlan分页返回值结构
 */
export type MesQualityInspectionPlanPageResult =
  BasicFetchResult<MesQualityInspectionPlanPageModel>;
