
import { MesGongdanReportPageModel, MesGongdanReportPageParams, MesGongdanReportPageResult } from './model/BgjlModel';
import { defHttp } from '/@/utils/http/axios';
import { ErrorMessageMode } from '/#/axios';

enum Api {
  Page = '/scgl/bgjl/page',
  List = '/scgl/bgjl/list',
  Info = '/scgl/bgjl/info',
  MesGongdanReport = '/scgl/bgjl',
  
  
  
}

/**
 * @description: 查询MesGongdanReport分页列表
 */
export async function getMesGongdanReportPage(params: MesGongdanReportPageParams, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<MesGongdanReportPageResult>(
    {
      url: Api.Page,
      params,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 获取MesGongdanReport信息
 */
export async function getMesGongdanReport(id: String, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<MesGongdanReportPageModel>(
    {
      url: Api.Info,
      params: { id },
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 新增MesGongdanReport
 */
export async function addMesGongdanReport(mesGongdanReport: Recordable, mode: ErrorMessageMode = 'modal') {
  return defHttp.post<boolean>(
    {
      url: Api.MesGongdanReport,
      params: mesGongdanReport,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 更新MesGongdanReport
 */
export async function updateMesGongdanReport(mesGongdanReport: Recordable, mode: ErrorMessageMode = 'modal') {
  return defHttp.put<boolean>(
    {
      url: Api.MesGongdanReport,
      params: mesGongdanReport,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 删除MesGongdanReport（批量删除）
 */
export async function deleteMesGongdanReport(ids: string[], mode: ErrorMessageMode = 'modal') {
  return defHttp.delete<boolean>(
    {
      url: Api.MesGongdanReport,
      data: ids,
    },
    {
      errorMessageMode: mode,
    },
  );
}




