import { BasicPageParams, BasicFetchResult } from '/@/api/model/baseModel';

/**
 * @description: MesProSchetool分页参数 模型
 */
export interface MesProSchetoolPageParams extends BasicPageParams {
  toolNo: string;

  onlineDate: string;

  productNo: string;

  productName: string;

  scheNum: string;

  toolDate: string;

  remark: string;
}

/**
 * @description: MesProSchetool分页返回值模型
 */
export interface MesProSchetoolPageModel {
  id: string;

  toolNo: string;

  onlineDate: string;

  productNo: string;

  productName: string;

  scheNum: string;

  toolDate: string;

  remark: string;
}

/**
 * @description: MesProSchetool表类型
 */
export interface MesProSchetoolModel {
  id: number;

  isSysNum: string;

  toolNo: string;

  scheId: number;

  productId: string;

  productNo: string;

  productName: string;

  onlineDate: string;

  scheNum: string;

  saleId: string;

  toolDate: string;

  remark: string;

  state: number;

  sort: number;

  createUserId: number;

  createDate: string;

  modifyUserId: number;

  modifyDate: string;

  deleteMark: number;

  enabledMark: number;

  mesProSchetoolDetailList?: MesProSchetoolDetailModel;
}

/**
 * @description: MesProSchetoolDetail表类型
 */
export interface MesProSchetoolDetailModel {
  id: number;

  scheId: number;

  toolId: number;

  productId: string;

  productNo: string;

  productName: string;

  customerName: string;

  scheNum: string;

  saleId: string;

  saleNo: string;

  saleName: string;

  saleNum: string;

  remark: string;

  state: number;

  sort: number;

  createUserId: number;

  createDate: string;

  modifyUserId: number;

  modifyDate: string;

  deleteMark: number;

  enabledMark: number;
}

/**
 * @description: MesProSchetool分页返回值结构
 */
export type MesProSchetoolPageResult = BasicFetchResult<MesProSchetoolPageModel>;
