import { MesQbFinishReportModel, MesQbFinishReportPageParams, MesQbFinishReportPageResult } from './model/MesFinishReportModel';
import { defHttp } from '/@/utils/http/axios';
import { ErrorMessageMode } from '/#/axios';

enum Api {
  Page = '/mes/mesfinishreport/page',
  List = '/mes/mesfinishreport/list',
  Info = '/mes/mesfinishreport/info',
  MesQbFinishReport = '/mes/mesfinishreport',
  
  
}

/**
 * @description: 查询MesQbFinishReport分页列表
 */
export async function getMesQbFinishReportPage(params: MesQbFinishReportPageParams, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<MesQbFinishReportPageResult>(
    {
      url: Api.Page,
      params,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 获取MesQbFinishReport信息
 */
export async function getMesQbFinishReport(id: String, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<MesQbFinishReportModel>(
    {
      url: Api.Info,
      params: { id },
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 新增MesQbFinishReport
 */
export async function addMesQbFinishReport(mesQbFinishReport: Recordable, mode: ErrorMessageMode = 'modal') {
  return defHttp.post<boolean>(
    {
      url: Api.MesQbFinishReport,
      params: mesQbFinishReport,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 更新MesQbFinishReport
 */
export async function updateMesQbFinishReport(mesQbFinishReport: Recordable, mode: ErrorMessageMode = 'modal') {
  return defHttp.put<boolean>(
    {
      url: Api.MesQbFinishReport,
      params: mesQbFinishReport,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 删除MesQbFinishReport（批量删除）
 */
export async function deleteMesQbFinishReport(ids: string[], mode: ErrorMessageMode = 'modal') {
  return defHttp.delete<boolean>(
    {
      url: Api.MesQbFinishReport,
      data: ids,
    },
    {
      errorMessageMode: mode,
    },
  );
}