import { BasicPageParams, BasicFetchResult } from '/@/api/model/baseModel';

/**
 * @description: MesBaseChanxian分页参数 模型
 */
export interface MesBaseChanxianPageParams extends BasicPageParams {
  cxbh: string;

  cxmc: string;
}

/**
 * @description: MesBaseChanxian分页返回值模型
 */
export interface MesBaseChanxianPageModel {
  id: string;

  cxbh: string;

  cxmc: string;

  bz: string;
}

/**
 * @description: MesBaseChanxian表类型
 */
export interface MesBaseChanxianModel {
  id: string;

  deleteMark: string;

  cxbh: string;

  cxmc: string;

  bz: string;

  p1: string;

  p2: string;

  p3: string;

  p4: string;

  p5: string;

  p6: string;

  p7: string;

  p8: string;

  p9: string;

  p10: string;

  createDate: string;

  createUserId: string;

  modifyDate: string;

  modifyUserId: string;

  mesBaseCxGzzxRelaList?: MesBaseCxGzzxRelaModel;
}

/**
 * @description: MesBaseCxGzzxRela表类型
 */
export interface MesBaseCxGzzxRelaModel {
  id: string;

  deleteMark: string;

  cxid: string;

  gzzxid: string;

  gzzxbh: string;

  gzzxmc: string;

  p1: string;

  p2: string;

  p3: string;

  p4: string;

  p5: string;

  p6: string;

  p7: string;

  p8: string;

  p9: string;

  p10: string;

  createDate: string;

  createUserId: string;

  modifyDate: string;

  modifyUserId: string;
}

/**
 * @description: MesBaseChanxian分页返回值结构
 */
export type MesBaseChanxianPageResult = BasicFetchResult<MesBaseChanxianPageModel>;
