import { defHttp } from '/@/utils/http/axios';

import { ErrorMessageMode } from '/#/axios';
import {
  ManagementPageListSearchModel,
  ManagementPageListResultModel,
  ManagementAddParamsModel,
  ManagementUpdateParamsModel,
} from './model';

enum Api {
  Page = '/caseErpStoreReceipt/caseErpStoreReceipt/page',
  Management = '/caseErpStoreReceipt/caseErpStoreReceipt',
  Info = '/caseErpStoreReceipt/caseErpStoreReceipt/info',
}

/**
 * @description: 查询仓库管理（分页）
 */
export async function getStoreManagementPageList(
  params: ManagementPageListSearchModel,
  mode: ErrorMessageMode = 'modal',
) {
  return defHttp.get<ManagementPageListResultModel>(
    {
      url: Api.Page,
      params,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 新增仓库管理
 */
export async function addStoreManagement(
  params: ManagementAddParamsModel,
  mode: ErrorMessageMode = 'modal',
) {
  return defHttp.post<number>(
    {
      url: Api.Management,
      params,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 修改仓库管理
 */
export async function updateStoreManagement(
  params: ManagementUpdateParamsModel,
  mode: ErrorMessageMode = 'modal',
) {
  return defHttp.put<number>(
    {
      url: Api.Management,
      params,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 删除仓库管理
 */
export async function deleteStoreManagement(id: string, mode: ErrorMessageMode = 'modal') {
  return defHttp.delete<number>(
    {
      url: Api.Management,
      data: id,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 查询仓库管理详情
 */
export async function getStoreManagementInfo(id: string, mode: ErrorMessageMode = 'modal') {
  return defHttp.get(
    {
      url: Api.Info,
      params: { id },
    },
    {
      errorMessageMode: mode,
    },
  );
}
