
import { MesWarehouseSaleoutPageModel, MesWarehouseSaleoutPageParams, MesWarehouseSaleoutPageResult } from './model/XsckModel';
import { defHttp } from '/@/utils/http/axios';
import { ErrorMessageMode } from '/#/axios';

enum Api {
  Page = '/ckgl/xsck/page',
  List = '/ckgl/xsck/list',
  Info = '/ckgl/xsck/info',
  MesWarehouseSaleout = '/ckgl/xsck',
  
  
  Export = '/ckgl/xsck/export',
  
}

/**
 * @description: 查询MesWarehouseSaleout分页列表
 */
export async function getMesWarehouseSaleoutPage(params: MesWarehouseSaleoutPageParams, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<MesWarehouseSaleoutPageResult>(
    {
      url: Api.Page,
      params,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 获取MesWarehouseSaleout信息
 */
export async function getMesWarehouseSaleout(id: String, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<MesWarehouseSaleoutPageModel>(
    {
      url: Api.Info,
      params: { id },
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 新增MesWarehouseSaleout
 */
export async function addMesWarehouseSaleout(mesWarehouseSaleout: Recordable, mode: ErrorMessageMode = 'modal') {
  return defHttp.post<boolean>(
    {
      url: Api.MesWarehouseSaleout,
      params: mesWarehouseSaleout,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 更新MesWarehouseSaleout
 */
export async function updateMesWarehouseSaleout(mesWarehouseSaleout: Recordable, mode: ErrorMessageMode = 'modal') {
  return defHttp.put<boolean>(
    {
      url: Api.MesWarehouseSaleout,
      params: mesWarehouseSaleout,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 删除MesWarehouseSaleout（批量删除）
 */
export async function deleteMesWarehouseSaleout(ids: string[], mode: ErrorMessageMode = 'modal') {
  return defHttp.delete<boolean>(
    {
      url: Api.MesWarehouseSaleout,
      data: ids,
    },
    {
      errorMessageMode: mode,
    },
  );
}



/**
 * @description: 导出MesWarehouseSaleout
 */
export async function exportMesWarehouseSaleout(
  params?: object, 
  mode: ErrorMessageMode = 'modal'
) {
  return defHttp.download(
    {
      url: Api.Export,
      method: 'GET',
      params,
      responseType: 'blob',
    },
    {
      errorMessageMode: mode,
    },
  );
}
  

