
import { MesWarehouseOtheroutPageModel, MesWarehouseOtheroutPageParams, MesWarehouseOtheroutPageResult } from './model/QtckModel';
import { defHttp } from '/@/utils/http/axios';
import { ErrorMessageMode } from '/#/axios';

enum Api {
  Page = '/ckgl/qtck/page',
  List = '/ckgl/qtck/list',
  Info = '/ckgl/qtck/info',
  MesWarehouseOtherout = '/ckgl/qtck',
  
  
  
}

/**
 * @description: 查询MesWarehouseOtherout分页列表
 */
export async function getMesWarehouseOtheroutPage(params: MesWarehouseOtheroutPageParams, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<MesWarehouseOtheroutPageResult>(
    {
      url: Api.Page,
      params,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 获取MesWarehouseOtherout信息
 */
export async function getMesWarehouseOtherout(id: String, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<MesWarehouseOtheroutPageModel>(
    {
      url: Api.Info,
      params: { id },
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 新增MesWarehouseOtherout
 */
export async function addMesWarehouseOtherout(mesWarehouseOtherout: Recordable, mode: ErrorMessageMode = 'modal') {
  return defHttp.post<boolean>(
    {
      url: Api.MesWarehouseOtherout,
      params: mesWarehouseOtherout,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 更新MesWarehouseOtherout
 */
export async function updateMesWarehouseOtherout(mesWarehouseOtherout: Recordable, mode: ErrorMessageMode = 'modal') {
  return defHttp.put<boolean>(
    {
      url: Api.MesWarehouseOtherout,
      params: mesWarehouseOtherout,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 删除MesWarehouseOtherout（批量删除）
 */
export async function deleteMesWarehouseOtherout(ids: string[], mode: ErrorMessageMode = 'modal') {
  return defHttp.delete<boolean>(
    {
      url: Api.MesWarehouseOtherout,
      data: ids,
    },
    {
      errorMessageMode: mode,
    },
  );
}




