
import { 
  getMesWarehouseBatchPage,
  deleteMesWarehouseBatch 
} from '@/common/api/ckgl/pcgl/index.js';
import {
  componentType,
  datasourceTypeEnum
} from '@/components/simple-form/types/form.js'


export const listProps = {
  rowKey:'id',
  //列表请求接口
  api: getMesWarehouseBatchPage,
  // 请求之前处理参数 (params) => {}
  beforeFetch: (params) => {
    for(let key in params){
			if(key.includes(',')){
				delete params[key]
			}
		}
    params.PK='id'
		params.FormId='2009150321167294464'
    return params
  },
  // 自定义处理接口返回参数
  afterFetch: (data) => {
    return data
  },
  //数据源  静态
  datasource: [],
  workflowConfig:{
    Pk:'id',
    Formid:'2009150321167294464'
  },
  //列配置
  columnConfigs: [
    {
        title: '单件/批次号',
        mainField:false,
			  showLabel:true,
        componentType:'AutoCode',
        field: 'pch',
      },{
        title: '客户/供应商',
        mainField:false,
			  showLabel:true,
        componentType:'Select',
        field: 'gys',
      },{
        title: '产品',
        mainField:false,
			  showLabel:true,
        componentType:'Select',
        field: 'cp',
      },{
        title: '数量',
        mainField:false,
			  showLabel:true,
        componentType:'InputNumber',
        field: 'sl',
      },{
        title: '成本单价',
        mainField:false,
			  showLabel:true,
        componentType:'InputNumber',
        field: 'cbdj',
      },{
        title: '入库日期',
        mainField:false,
			  showLabel:true,
        componentType:'DateTime',
        field: 'createDate',
      }
  ],
  //是否启用搜索
  isSearch: true,
  //是否分页
  isPage: true,
  pageSize: 10,
  //分类筛选配置
  categoryConfigs:"",
  //搜索配置
  searchConfigs: [{
      key: '1d3aace87f304d42a108e5152f8c8345',
      name: '单件/批次号',
      label: '单件/批次号',
      field: 'pch',
      component: componentType.input, //组件类型
      componentProps: { 
        placeholder: '请输入单件/批次号',
      }
    },
{
        key: 'd132722378d64da6838371444968271b',
      name: '客户/供应商',
      label: '客户/供应商',
        field: 'gys',
        component: componentType.select, //组件类型
        componentProps: {"placeholder":"请选择客户/供应商","isShow":true,"apiConfig":{"method":"GET","path":"/bmxx/getCompanyList","requestParamsConfigs":[],"requestHeaderConfigs":[],"requestBodyConfigs":[]},"map":{"text":"label","value":"value"},"multiple":false,"isSearch":false},
      },
{
        key: '63fb36d6b45d41fe8d984d637336af7b',
      name: '产品',
      label: '产品',
        field: 'cp',
        component: componentType.select, //组件类型
        componentProps: {"placeholder":"请选择产品","isShow":true,"apiConfig":{"method":"GET","path":"/scgl/scjh/getAllProduct","requestParamsConfigs":[],"requestHeaderConfigs":[],"requestBodyConfigs":[]},"map":{"text":"label","value":"value"},"multiple":false,"isSearch":false},
      },],
  //表单页面地址
  formUrl: '/pages/ckgl/pcgl/container',
  //列表页面地址
  listUrl: '/pages/ckgl/pcgl/list',
  //按钮配置
  otherButtons:[
        {
          text: '查看',
          isUse:true,
          code:'pcgl:view',
        },
        {
          text: '新增',
          isUse:true,
          code:'pcgl:add',
        },
        {
          text: '发起审批',
          isUse:false,
          code:'pcgl:startwork',
        }],
  buttonConfigs: [{
        code: 'pcgl:edit',
        icon: 'ant-design:edit-square',
        color:'#5E95FF',
        text: '编辑',
        action: (record) =>{
          uni.navigateTo({
            url: listProps.formUrl + '?type=edit&id=' + record[listProps.rowKey],
          });
        }
      },{
        code: 'pcgl:delete',
        icon: 'ant-design:delete-outlined',
        color:'#EF6969',
        text: '删除',
        action: async (record, { reload }) => {
          await deleteMesWarehouseBatch ([record[listProps.rowKey]]);
          reload()
          //请求删除接口
          uni.showToast({
            title: "删除成功"
          })
        } 
      }],
  formEventConfig:{"0":[],"1":[],"2":[],"3":[],"4":[]}
}


export const formProps =  {"validateTrigger":"submit","labelPosition":"left","labelWidth":75,"labelAlign":"right","errShowType":"undertext","border":false,"schemas":[{"key":"1d3aace87f304d42a108e5152f8c8345","field":"pch","label":"单件/批次号","component":"AutoCode","componentProps":{"autoCodeRule":"pcbh","placeholder":"自动生成","prefixIcon":"","suffixIcon":"","addonBefore":"","addonAfter":"","isShow":true},"required":false,"rules":[],"name":"单件/批次号","ifShow":true},{"key":"d132722378d64da6838371444968271b","field":"gys","label":"客户/供应商","component":"Select","defaultValue":"","componentProps":{"placeholder":"请选择客户/供应商","isShow":true,"apiConfig":{"method":"GET","path":"/bmxx/getCompanyList","requestParamsConfigs":[],"requestHeaderConfigs":[],"requestBodyConfigs":[]},"map":{"text":"label","value":"value"},"multiple":false,"isSearch":false},"required":false,"rules":[],"name":"客户/供应商","ifShow":true,"dynamicDisabled":false,"events":{}},{"key":"63fb36d6b45d41fe8d984d637336af7b","field":"cp","label":"产品","component":"Select","defaultValue":"","componentProps":{"placeholder":"请选择产品","isShow":true,"apiConfig":{"method":"GET","path":"/scgl/scjh/getAllProduct","requestParamsConfigs":[],"requestHeaderConfigs":[],"requestBodyConfigs":[]},"map":{"text":"label","value":"value"},"multiple":false,"isSearch":false},"required":true,"rules":[{"required":true,"errorMessage":"产品项必填"}],"name":"产品","ifShow":true,"dynamicDisabled":false,"events":{}},{"key":"4cbb4a0b76b94de4b0cd50e332d57f90","field":"sl","label":"数量","component":"InputNumber","defaultValue":0,"componentProps":{"min":0,"max":null,"step":1,"maxlength":-1,"isShow":true},"required":false,"rules":[],"name":"数量","ifShow":true,"dynamicDisabled":true,"events":{}},{"key":"a2fa14e2600a48dcbe977b55fe004157","field":"cbdj","label":"成本单价","component":"InputNumber","defaultValue":0,"componentProps":{"min":0,"max":null,"step":1,"maxlength":-1,"isShow":true},"required":false,"rules":[],"name":"成本单价","ifShow":true,"dynamicDisabled":false,"events":{}},{"key":"b929322dd8924750a29077e7308d1259","field":"createDate","label":"入库日期","component":"DateTime","componentProps":{"clearIcon":false,"placeholder":"请选择入库日期","type":"datetime","formatType":"datetime","isShow":true},"required":false,"rules":[],"name":"入库日期","ifShow":true,"dynamicDisabled":true,"events":{}},{"key":"cde52e0a23ef4208987f60559bff0681","field":"ysph","label":"原始批号","component":"Input","componentProps":{"placeholder":"请输入原始批号","prefixIcon":"","suffixIcon":"","addonBefore":"","addonAfter":"","clearable":false,"maxlength":-1,"isShow":true},"required":false,"rules":[],"name":"原始批号","ifShow":true,"dynamicDisabled":false,"events":{}},{"key":"e6a4af149da54b6baebcb250a9d2c66d","field":"bz","label":"备注说明","component":"Input","componentProps":{"type":"textarea","placeholder":"请输入备注说明","maxlength":-1,"showCount":false,"autoHeight":false,"clearable":false,"isShow":true},"required":false,"rules":[],"name":"备注说明","ifShow":true,"dynamicDisabled":false,"events":{}}],"rules":[]};

