import { FormProps, FormSchema } from '/@/components/Form';
import { BasicColumn } from '/@/components/Table';
import { uploadApi } from '/@/api/sys/upload';

export const searchFormSchema: FormSchema[] = [
  {
    field: 'code',
    label: '编码',
    defaultValue: undefined,
    component: 'Input',
  },
  {
    field: 'name',
    label: '名称',
    defaultValue: undefined,
    component: 'Input',
  },
  {
    field: 'categoryId',
    label: '工序类别',
    defaultValue: undefined,
    component: 'XjrSelect',
    componentProps: {
      datasourceType: 'dic',
      params: { itemId: '2005547790246666242' },
      labelField: 'name',
      valueField: 'value',
      mode: 'multiple',
      showSearch: true,
      getPopupContainer: () => document.body,
    },
  },
  {
    field: 'collectionSchemeId',
    label: '采集方案',
    defaultValue: undefined,
    component: 'XjrSelect',
    componentProps: {
      datasourceType: 'api',
      apiConfig: {
        path: '/jcxx/getCollectionSchemeList',
        method: 'GET',
        apiId: 'copy1767064303024d70507',
        apiParams: [
          { key: '1', title: 'Query Params', tableInfo: [] },
          { key: '2', title: 'Header', tableInfo: [] },
          { key: '3', title: 'Body' },
        ],
        script:
          'var sql="select id as value,name as label from mes_collection_scheme where delete_mark = 0";\r\nreturn db.select(sql);',
      },
      labelField: 'label',
      valueField: 'value',
      mode: 'multiple',
      showSearch: true,
      getPopupContainer: () => document.body,
    },
  },
];

export const columns: BasicColumn[] = [
  {
    resizable: true,
    dataIndex: 'code',
    title: '编码',
    componentType: 'auto-code',

    fixed: false,
    sorter: true,

    styleConfig: undefined,
    listStyle: undefined,
  },

  {
    resizable: true,
    dataIndex: 'name',
    title: '名称',
    componentType: 'input',

    fixed: false,
    sorter: true,

    styleConfig: undefined,
    listStyle: '',
  },

  {
    resizable: true,
    dataIndex: 'categoryId',
    title: '工序类别',
    componentType: 'select',

    fixed: false,
    sorter: true,

    styleConfig: undefined,
    listStyle: undefined,
  },

  {
    resizable: true,
    dataIndex: 'collectionSchemeId',
    title: '采集方案',
    componentType: 'associate-select',

    fixed: false,
    sorter: true,

    styleConfig: undefined,
    listStyle: undefined,
  },
];
//表头合并配置
export const headerMergingData = [];
//表单事件
export const formEventConfigs = {
  0: [
    {
      type: 'circle',
      color: '#2774ff',
      text: '开始节点',
      icon: '#icon-kaishi',
      bgcColor: '#D8E5FF',
      isUserDefined: false,
    },
    {
      color: '#F6AB01',
      icon: '#icon-chushihua',
      text: '初始化表单',
      bgcColor: '#f9f5ea',
      isUserDefined: false,
      nodeInfo: { processEvent: [] },
    },
  ],
  1: [
    {
      color: '#B36EDB',
      icon: '#icon-shujufenxi',
      text: '获取表单数据',
      detail: '(新增无此操作)',
      bgcColor: '#F8F2FC',
      isUserDefined: false,
      nodeInfo: { processEvent: [] },
    },
  ],
  2: [
    {
      color: '#F8625C',
      icon: '#icon-jiazai',
      text: '加载表单',
      bgcColor: '#FFF1F1',
      isUserDefined: false,
      nodeInfo: { processEvent: [] },
    },
  ],
  3: [
    {
      color: '#6C6AE0',
      icon: '#icon-jsontijiao',
      text: '提交表单',
      bgcColor: '#F5F4FF',
      isUserDefined: false,
      nodeInfo: { processEvent: [] },
    },
  ],
  4: [
    {
      type: 'circle',
      color: '#F8625C',
      text: '结束节点',
      icon: '#icon-jieshuzhiliao',
      bgcColor: '#FFD6D6',
      isLast: true,
      isUserDefined: false,
    },
  ],
};
export const formProps: FormProps = {
  labelCol: { span: 3, offset: 0 },
  labelAlign: 'left',
  layout: 'horizontal',
  size: 'default',
  schemas: [
    {
      key: '04fbf175bf2a4661a06e44126776617b',
      field: '',
      label: '',
      type: 'grid',
      colProps: { span: 24 },
      component: 'Grid',
      children: [
        {
          span: 8,
          list: [
            {
              key: 'e0f5ab09b1e541d3bff26b82ad0ccf53',
              field: 'code',
              label: '编码',
              type: 'auto-code',
              component: 'AutoCodeRule',
              colProps: { span: 24 },
              componentProps: {
                width: '100%',
                span: 7,
                placeholder: '请输入编码组件组件',
                prefix: '',
                suffix: '',
                addonBefore: '',
                addonAfter: '',
                showLabel: true,
                autoCodeRule: 'GX',
                required: false,
                isShow: false,
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
            {
              key: '60af544637c442bcb20cdbf2cd71a2c2',
              field: 'name',
              label: '名称',
              type: 'input',
              component: 'Input',
              colProps: { span: 24 },
              defaultValue: '',
              componentProps: {
                width: '100%',
                span: 7,
                defaultValue: '',
                placeholder: '',
                prefix: '',
                suffix: '',
                addonBefore: '',
                addonAfter: '',
                disabled: false,
                allowClear: false,
                showLabel: true,
                required: true,
                rules: [],
                events: {},
                listStyle: '',
                isSave: false,
                isShow: true,
                scan: false,
                bordered: true,
                isShowAi: false,
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
            {
              key: 'f7c26bba94034dcdbc816e49607d64e9',
              field: 'zyzdFile',
              label: '作业指导',
              type: 'upload',
              component: 'Upload',
              colProps: { span: 24 },
              componentProps: {
                api: uploadApi,
                span: 7,
                defaultValue: '',
                accept: '',
                maxNumber: 10,
                maxSize: 100,
                showLabel: true,
                multiple: true,
                disabled: false,
                required: false,
                isShow: true,
                events: {},
                listType: 'text',
                sourceType: 'album,camera',
                tooltipConfig: { visible: false, title: '提示文本' },
              },
            },
          ],
        },
        {
          span: 8,
          list: [
            {
              key: '16def0c2f9d8422da5d403e11b8c38e0',
              field: 'categoryId',
              label: '工序类别',
              type: 'select',
              component: 'XjrSelect',
              colProps: { span: 24 },
              componentProps: {
                width: '100%',
                span: 7,
                placeholder: '',
                showLabel: true,
                showSearch: false,
                isMultiple: false,
                clearable: false,
                disabled: false,
                staticOptions: [
                  { key: 1, label: 'Option 1', value: 'Option 1' },
                  { key: 2, label: 'Option 2', value: 'Option 2' },
                  { key: 3, label: 'Option 3', value: 'Option 3' },
                ],
                datasourceType: 'dic',
                params: { itemId: '2005547790246666242' },
                labelField: 'name',
                valueField: 'value',
                apiConfig: {
                  path: '/gxlb/getTypeList',
                  method: 'GET',
                  apiId: 'c1695a5b0fbe48e1817740557a3c5d4e',
                  apiParams: [
                    { key: '1', title: 'Query Params', tableInfo: [] },
                    { key: '2', title: 'Header', tableInfo: [] },
                    { key: '3', title: 'Body' },
                  ],
                  script:
                    'var sql="select id as value,name as label from roke_process_category";\r\nreturn db.select(sql);',
                },
                dicOptions: [],
                required: true,
                rules: [],
                events: {},
                isShow: true,
                tooltipConfig: { visible: false, title: '提示文本' },
                itemId: '2005547790246666242',
                style: { width: '100%' },
              },
            },
            {
              key: 'ca8257a46070472e9639110b11f7f3bd',
              field: 'ratedWorkingHours',
              label: '额定工时',
              type: 'number',
              component: 'InputNumber',
              colProps: { span: 24 },
              defaultValue: 0,
              componentProps: {
                width: '100%',
                span: 7,
                defaultValue: 0,
                min: 0,
                step: 0.01,
                disabled: false,
                showLabel: true,
                controls: true,
                required: false,
                subTotal: false,
                isShow: true,
                rules: [],
                events: {},
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
          ],
        },
        {
          span: 8,
          list: [
            {
              key: '6a8f658eb0e046e48c3dac472c0e51ae',
              field: 'collectionSchemeId',
              label: '采集方案',
              type: 'associate-select',
              component: 'AssociateSelect',
              colProps: { span: 24 },
              componentProps: {
                width: '100%',
                span: 7,
                placeholder: '请选择采集方案',
                showLabel: true,
                showSearch: true,
                disabled: false,
                datasourceType: 'api',
                labelField: 'label',
                valueField: 'value',
                apiConfig: {
                  path: '/jcxx/getCollectionSchemeList',
                  method: 'GET',
                  apiId: 'copy1767064303024d70507',
                  apiParams: [
                    { key: '1', title: 'Query Params', tableInfo: [] },
                    { key: '2', title: 'Header', tableInfo: [] },
                    { key: '3', title: 'Body' },
                  ],
                  script:
                    'var sql="select id as value,name as label from mes_collection_scheme where delete_mark = 0";\r\nreturn db.select(sql);',
                },
                dicOptions: [],
                required: false,
                rules: [],
                events: {},
                isShow: true,
                tooltipConfig: { visible: false, title: '提示文本' },
                defaultSelect: '2005534898818441218',
                style: { width: '100%' },
              },
            },
            {
              key: 'c0730ef93c40445195dac1ed93677144',
              field: 'active',
              label: '有效',
              type: 'switch',
              component: 'Switch',
              colProps: { span: 24 },
              defaultValue: 1,
              componentProps: {
                span: 7,
                defaultValue: 1,
                checkedChildren: '',
                unCheckedChildren: '',
                checkedColor: '#5c7cff',
                unCheckedColor: '#bbbdbf',
                showLabel: true,
                disabled: false,
                events: {},
                isShow: true,
                tooltipConfig: { visible: false, title: '提示文本' },
                style: {},
              },
            },
          ],
        },
      ],
      componentProps: {
        gutter: 2,
        justify: 'start',
        align: 'top',
        isShow: true,
        showBorder: false,
        bordercolor: '#d9d9d9',
        bordershowtype: [true, true, true, true],
        borderwidth: 1,
        padding: '',
        margin: '10px',
      },
    },
    {
      key: '6cf0d93568bf4236970c03902399e4c8',
      field: '',
      label: '',
      type: 'grid',
      colProps: { span: 24 },
      component: 'Grid',
      children: [
        {
          span: 24,
          list: [
            {
              key: '037bf18717bf496f8a1fc0e8605a8a7d',
              field: 'note',
              label: '备注',
              type: 'textarea',
              component: 'InputTextArea',
              colProps: { span: 24 },
              defaultValue: '',
              componentProps: {
                width: '100%',
                span: 1,
                defaultValue: '',
                placeholder: '请输入备注',
                rows: 4,
                autoSize: false,
                showCount: false,
                disabled: false,
                showLabel: true,
                allowClear: false,
                required: false,
                isShow: true,
                isShowAi: false,
                rules: [],
                events: {},
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
          ],
        },
      ],
      componentProps: {
        gutter: 16,
        justify: 'start',
        align: 'top',
        isShow: true,
        showBorder: false,
        bordercolor: '#d9d9d9',
        bordershowtype: [true, true, true, true],
        borderwidth: 1,
        padding: '10px',
        margin: '10px',
      },
    },
    {
      key: '03c19c5ac95b4d139d8380ede64f14ff',
      field: '',
      label: '',
      type: 'grid',
      colProps: { span: 24 },
      component: 'Grid',
      children: [
        {
          span: 24,
          list: [
            {
              key: '24f0714c9f3a4242b1bcefff04bb7314',
              field: '',
              label: '',
              type: 'tab',
              colProps: { span: 24 },
              component: 'Tab',
              children: [
                {
                  span: 24,
                  name: '产品/物料',
                  prefix: '',
                  suffix: '',
                  activeColor: '#1c8dff',
                  folderId: '',
                  imageUrl: '',
                  conFolderId: '',
                  conImageUrl: '',
                  list: [
                    {
                      key: '7cb7c6cdf3ec417280dc49e19dd39ffa',
                      label: '',
                      field: 'mesProcessProductList',
                      type: 'form',
                      component: 'SubForm',
                      required: true,
                      colProps: { span: 24 },
                      componentProps: {
                        mainKey: 'mesProcessProductList',
                        columns: [
                          {
                            key: '00c0e93b675841f48265b896515a5241',
                            title: '编号',
                            dataIndex: 'cpbh',
                            componentType: 'Input',
                            defaultValue: '',
                            componentProps: {
                              width: '100%',
                              span: '',
                              defaultValue: '',
                              placeholder: '',
                              prefix: '',
                              suffix: '',
                              addonBefore: '',
                              addonAfter: '',
                              disabled: true,
                              allowClear: false,
                              showLabel: true,
                              required: false,
                              rules: [],
                              events: {},
                              listStyle: '',
                              isSave: false,
                              isShow: true,
                              scan: false,
                              bordered: true,
                              isShowAi: false,
                              tooltipConfig: { visible: false, title: '提示文本' },
                            },
                          },
                          {
                            key: '91863c5a0ec24d76ade8735cd401059b',
                            title: '名称',
                            dataIndex: 'cpmc',
                            componentType: 'Input',
                            defaultValue: '',
                            componentProps: {
                              width: '100%',
                              span: '',
                              defaultValue: '',
                              placeholder: '',
                              prefix: '',
                              suffix: '',
                              addonBefore: '',
                              addonAfter: '',
                              disabled: true,
                              allowClear: false,
                              showLabel: true,
                              required: false,
                              rules: [],
                              events: {},
                              listStyle: '',
                              isSave: false,
                              isShow: true,
                              scan: false,
                              bordered: true,
                              isShowAi: false,
                              tooltipConfig: { visible: false, title: '提示文本' },
                            },
                          },
                          {
                            key: '6c749d8f7bde474da082c659146f473c',
                            title: '数量',
                            dataIndex: 'number',
                            componentType: 'InputNumber',
                            defaultValue: 0,
                            componentProps: {
                              width: '100%',
                              span: '',
                              defaultValue: 0,
                              min: 0,
                              step: 1,
                              disabled: false,
                              showLabel: true,
                              controls: true,
                              required: false,
                              subTotal: false,
                              isShow: true,
                              rules: [],
                              events: {},
                              tooltipConfig: { visible: false, title: '提示文本' },
                              listStyle: "return 'width:100%'",
                            },
                          },
                          {
                            key: 'cb38672445b24eedb2b10addf520de2e',
                            title: '是否投料',
                            dataIndex: 'isFeeding',
                            componentType: 'Switch',
                            defaultValue: 1,
                            componentProps: {
                              span: '',
                              defaultValue: 1,
                              checkedChildren: '',
                              unCheckedChildren: '',
                              checkedColor: '#545454',
                              unCheckedColor: '#bbbdbf',
                              showLabel: true,
                              disabled: false,
                              events: {},
                              isShow: true,
                              tooltipConfig: { visible: false, title: '提示文本' },
                            },
                          },
                          {
                            key: '1084a7c39baf47ba9a0251cb4e2f8c14',
                            title: '备注',
                            dataIndex: 'bz',
                            componentType: 'InputTextArea',
                            defaultValue: '',
                            componentProps: {
                              width: '100%',
                              span: '',
                              defaultValue: '',
                              placeholder: '请输入备注',
                              rows: 2,
                              autoSize: false,
                              showCount: false,
                              disabled: false,
                              showLabel: true,
                              allowClear: false,
                              required: false,
                              isShow: true,
                              isShowAi: false,
                              rules: [],
                              events: {},
                              tooltipConfig: { visible: false, title: '提示文本' },
                            },
                          },
                          { title: '操作', key: 'action', fixed: 'right', width: '50px' },
                        ],
                        span: '24',
                        preloadType: 'api',
                        apiConfig: {},
                        itemId: '',
                        dicOptions: [],
                        useSelectButton: false,
                        buttonName: '选择数据',
                        showLabel: true,
                        showComponentBorder: true,
                        showBorder: false,
                        bordercolor: '#f0f0f0',
                        bordershowtype: [true, true, true, true],
                        borderwidth: 1,
                        showIndex: false,
                        isShow: true,
                        multipleHeads: [],
                        buttonList: [],
                        topButtonList: [],
                        isExport: false,
                        isImport: false,
                        isDeleteSelected: true,
                        isListView: false,
                        viewList: [],
                        isShowAdd: true,
                        isShowDelete: true,
                        hasCheckedCol: true,
                        events: {},
                        showPagenation: true,
                      },
                    },
                  ],
                },
                {
                  span: 0,
                  name: '采集项',
                  list: [
                    {
                      key: '3fd474ce5f8c4bf78bd86dc701cbdc4f',
                      label: '',
                      field: 'mesProcessItemList',
                      type: 'form',
                      component: 'SubForm',
                      required: true,
                      colProps: { span: 24 },
                      componentProps: {
                        mainKey: 'mesProcessItemList',
                        columns: [
                          {
                            key: '3999831fde0a4e879f64f33eb2a1edd1',
                            title: '编码',
                            dataIndex: 'code',
                            componentType: 'Input',
                            defaultValue: '',
                            componentProps: {
                              width: '100%',
                              span: '',
                              defaultValue: '',
                              placeholder: '',
                              prefix: '',
                              suffix: '',
                              addonBefore: '',
                              addonAfter: '',
                              disabled: false,
                              allowClear: false,
                              showLabel: true,
                              required: false,
                              rules: [],
                              events: {},
                              listStyle: '',
                              isSave: false,
                              isShow: true,
                              scan: false,
                              bordered: true,
                              isShowAi: false,
                              tooltipConfig: { visible: false, title: '提示文本' },
                            },
                          },
                          {
                            key: 'ab6576e960ee44b4af09975e64088f05',
                            title: '名称',
                            dataIndex: 'name',
                            componentType: 'Input',
                            defaultValue: '',
                            componentProps: {
                              width: '100%',
                              span: '',
                              defaultValue: '',
                              placeholder: '',
                              prefix: '',
                              suffix: '',
                              addonBefore: '',
                              addonAfter: '',
                              disabled: false,
                              allowClear: false,
                              showLabel: true,
                              required: false,
                              rules: [],
                              events: {},
                              listStyle: '',
                              isSave: false,
                              isShow: true,
                              scan: false,
                              bordered: true,
                              isShowAi: false,
                              tooltipConfig: { visible: false, title: '提示文本' },
                            },
                          },
                          {
                            key: '745cb3bb014d4dd9ba38139d17b2f305',
                            title: '数据类型',
                            dataIndex: 'dataType',
                            componentType: 'XjrSelect',
                            componentProps: {
                              width: '100%',
                              span: '',
                              placeholder: '',
                              showLabel: true,
                              showSearch: false,
                              isMultiple: false,
                              clearable: false,
                              disabled: false,
                              staticOptions: [
                                { key: 1, label: 'Option 1', value: 'Option 1' },
                                { key: 2, label: 'Option 2', value: 'Option 2' },
                                { key: 3, label: 'Option 3', value: 'Option 3' },
                              ],
                              datasourceType: 'dic',
                              params: { itemId: '2004076331787718658' },
                              labelField: 'name',
                              valueField: 'value',
                              apiConfig: {
                                path: 'CodeGeneration/selection',
                                method: 'GET',
                                apiId: '93d735dcb7364a0f8102188ec4d77ac7',
                              },
                              dicOptions: [],
                              required: false,
                              rules: [],
                              events: {},
                              isShow: true,
                              tooltipConfig: { visible: false, title: '提示文本' },
                              itemId: '2004076331787718658',
                              listStyle: "return 'border: 0'",
                            },
                          },
                          {
                            key: '36a40652260d491e8a088ff843aab982',
                            title: '是否必填',
                            dataIndex: 'required',
                            componentType: 'Switch',
                            defaultValue: 0,
                            componentProps: {
                              span: '',
                              defaultValue: 0,
                              checkedChildren: '',
                              unCheckedChildren: '',
                              checkedColor: '#1C8DFF',
                              unCheckedColor: '#bbbdbf',
                              showLabel: true,
                              disabled: false,
                              events: {},
                              isShow: true,
                              tooltipConfig: { visible: false, title: '提示文本' },
                            },
                          },
                          {
                            key: 'f3ba1f809888475d925665668e2a1851',
                            title: '备注',
                            dataIndex: 'note',
                            componentType: 'InputTextArea',
                            defaultValue: '',
                            componentProps: {
                              width: '100%',
                              span: '',
                              defaultValue: '',
                              placeholder: '',
                              rows: 2,
                              autoSize: false,
                              showCount: false,
                              disabled: false,
                              showLabel: true,
                              allowClear: false,
                              required: false,
                              isShow: true,
                              isShowAi: false,
                              rules: [],
                              events: {},
                              tooltipConfig: { visible: false, title: '提示文本' },
                            },
                          },
                          { title: '操作', key: 'action', fixed: 'right', width: '50px' },
                        ],
                        span: '24',
                        preloadType: 'api',
                        apiConfig: {},
                        itemId: '',
                        dicOptions: [],
                        useSelectButton: false,
                        buttonName: '选择数据',
                        showLabel: true,
                        showComponentBorder: true,
                        showBorder: false,
                        bordercolor: '#f0f0f0',
                        bordershowtype: [true, true, true, true],
                        borderwidth: 1,
                        showIndex: false,
                        isShow: true,
                        multipleHeads: [],
                        buttonList: [],
                        topButtonList: [],
                        isExport: false,
                        isImport: false,
                        isDeleteSelected: false,
                        isListView: false,
                        viewList: [],
                        isShowAdd: false,
                        isShowDelete: true,
                        hasCheckedCol: false,
                        events: {},
                        showPagenation: true,
                      },
                    },
                  ],
                },
              ],
              componentProps: { tabPosition: 'top', size: 'default', type: 'line', isShow: true },
            },
          ],
        },
      ],
      componentProps: {
        gutter: 1,
        justify: 'start',
        align: 'top',
        isShow: true,
        showBorder: false,
        bordercolor: '#d9d9d9',
        bordershowtype: [true, true, true, true],
        borderwidth: 1,
        padding: '10px',
        margin: '10px',
      },
    },
  ],
  showActionButtonGroup: false,
  buttonLocation: 'center',
  actionColOptions: { span: 24 },
  showResetButton: false,
  showSubmitButton: false,
  hiddenComponent: [],
};

export const treeConfig = {
  id: '',
  isMultiple: false,
  name: '',
  type: 1,
  configTip: '',
  config: [],
};

export const formButtons = [
  {
    key: 'confirm',
    code: 'confirm',
    name: '确定',
    style: 'primary',
    event: [],
    isShow: true,
    index: 2,
    type: 1,
  },
  {
    key: 'cancel',
    code: 'cancel',
    name: '取消',
    style: 'default',
    event: [],
    isShow: true,
    index: 1,
    type: 1,
  },
  {
    key: 'reset',
    code: 'reset',
    name: '重置',
    style: 'default',
    event: [],
    isShow: true,
    index: 0,
    type: 1,
  },
];
