import { FormProps, FormSchema } from '/@/components/Form';
import { BasicColumn } from '/@/components/Table';

import { AppDataType } from '/@/enums/appEnum';

export const searchFormSchema: FormSchema[] = [
  {
    field: 'appName',
    label: '应用名称',
    component: 'Input',
  },
  {
    field: 'appCode',
    label: '应用编码',
    component: 'Input',
  },
  {
    field: 'appType',
    label: '应用类别',
    component: 'XjrSelect',
    componentProps: {
      datasourceType: 'staticData',
      staticOptions: [
        { key: 1, label: '表单', value: '0' },
        { key: 2, label: '桌面', value: '1' },
        { key: 3, label: '大屏', value: '2' },
        { key: 4, label: '其它', value: '3' },
      ],
      labelField: 'label',
      valueField: 'value',

      getPopupContainer: () => document.body,
    },
  },
  {
    field: 'appStoreType',
    label: '应用商店分类',
    component: 'XjrSelect',
    componentProps: {
      datasourceType: 'dic',
      params: { itemId: '1838783020800827394' },
      labelField: 'name',
      valueField: 'value',
      getPopupContainer: () => document.body,
    },
  },
  {
    field: 'appVersion',
    label: '应用版本',
    component: 'Input',
  },
  {
    field: 'appRemark',
    label: '应用描述',
    component: 'Input',
  },
];

export const columns: BasicColumn[] = [
  {
    dataIndex: 'appName',
    title: '应用名称',
    componentType: 'input',
    listStyle: '',
  },
  {
    dataIndex: 'appCode',
    title: '应用编码',
    componentType: 'input',
    listStyle: '',
  },
  {
    dataIndex: 'appType',
    title: '应用类别',
    componentType: 'radio',
    customRender: ({ record }) => {
      const staticOptions = [
        { key: 1, label: '表单', value: '0' },
        { key: 2, label: '桌面', value: '1' },
        { key: 3, label: '大屏', value: '2' },
        { key: 4, label: '其它', value: '3' },
      ];
      return staticOptions.filter((x) => x.value === record.appType)[0]?.label;
    },
    listStyle: undefined,
  },
  {
    dataIndex: 'appStoreTypeName',
    title: '应用商店分类',
    componentType: 'select',
    listStyle: undefined,
  },
  {
    dataIndex: 'appVersion',
    title: '应用版本',
    componentType: 'input',
    listStyle: '',
  },
  {
    dataIndex: 'appFormName',
    title: '表单数据',
    componentType: 'input',
    listStyle: undefined,
  },
  {
    dataIndex: 'appBiName',
    title: '大屏数据',
    componentType: 'input',
    listStyle: undefined,
  },
  {
    dataIndex: 'appDesktopName',
    title: '桌面数据',
    componentType: 'input',
    listStyle: undefined,
  },
  {
    dataIndex: 'appPicture',
    title: '应用图片',
    componentType: 'image',
    listStyle: '',
  },
  {
    dataIndex: 'appRemark',
    title: '应用描述',
    componentType: 'textarea',
    listStyle: undefined,
  },
];
//表单事件
export const formEventConfigs = {
  0: [
    {
      type: 'circle',
      color: '#2774ff',
      text: '开始节点',
      icon: '#icon-kaishi',
      bgcColor: '#D8E5FF',
      isUserDefined: false,
    },
    {
      color: '#F6AB01',
      icon: '#icon-chushihua',
      text: '初始化表单',
      bgcColor: '#f9f5ea',
      isUserDefined: false,
      nodeInfo: { processEvent: [] },
    },
  ],
  1: [
    {
      color: '#B36EDB',
      icon: '#icon-shujufenxi',
      text: '获取表单数据',
      detail: '(新增无此操作)',
      bgcColor: '#F8F2FC',
      isUserDefined: false,
      nodeInfo: { processEvent: [] },
    },
    {
      color: '#2774FF',
      icon: '#icon-yonghu-xianxing',
      text: '用户自定义节点',
      bgcColor: '#F5F8FA',
      isUserDefined: true,
      isLogRecord: false,
      nodeInfo: {
        processEvent: [
          {
            operateType: 'js',
            operateConfig:
              'let val=formModel.appType;formActionType.changeCompShow(schema,false,["appFormId","appDesktopId","appBiId","appPicture","appRemark"]);if(val==="0"){formActionType.changeCompShow(schema,true,["appFormId","appPicture","appRemark"])}else if(val==1){formActionType.changeCompShow(schema,true,["appDesktopId","appRemark"])}else if(val==2){formActionType.changeCompShow(schema,true,["appBiId","appRemark"])}else{formActionType.changeCompShow(schema,true,["appPicture","appRemark"])}',
            showValue: '已配置',
          },
        ],
      },
      isClick: true,
    },
  ],
  2: [
    {
      color: '#F8625C',
      icon: '#icon-jiazai',
      text: '加载表单',
      bgcColor: '#FFF1F1',
      isUserDefined: false,
      nodeInfo: { processEvent: [] },
    },
    {
      color: '#2774FF',
      icon: '#icon-yonghu-xianxing',
      text: '用户自定义节点',
      bgcColor: '#F5F8FA',
      isUserDefined: true,
      isLogRecord: false,
      nodeInfo: {
        processEvent: [
          {
            operateType: 'js',
            operateConfig:
              'formActionType.changeCompShow(schema,false,["appFormId","appDesktopId","appBiId"]);formActionType.changeCompShow(schema,true,["appFormId","appPicture","appRemark"])',
            showValue: '已配置',
          },
        ],
      },
      isClick: true,
    },
  ],
  3: [
    {
      color: '#6C6AE0',
      icon: '#icon-jsontijiao',
      text: '提交表单',
      bgcColor: '#F5F4FF',
      isUserDefined: false,
      nodeInfo: { processEvent: [] },
    },
  ],
  4: [
    {
      type: 'circle',
      color: '#F8625C',
      text: '结束节点',
      icon: '#icon-jieshuzhiliao',
      bgcColor: '#FFD6D6',
      isLast: true,
      isUserDefined: false,
    },
  ],
};
export const formProps: FormProps = {
  labelCol: { span: 24, offset: 0 },
  labelAlign: 'right',
  layout: 'vertical',
  size: 'default',
  schemas: [
    {
      key: 'c95e84017496457ca5b41fb2eb582d85',
      field: 'appCode',
      label: '应用编码',
      type: 'input',
      component: 'Input',
      colProps: { span: 24 },
      defaultValue: '',
      componentProps: {
        width: '100%',
        defaultValue: '',
        placeholder: '请输入应用编码',
        maxlength: null,
        prefix: '',
        suffix: '',
        addonBefore: '',
        addonAfter: '',
        disabled: false,
        allowClear: false,
        showLabel: true,
        required: true,
        rules: [],
        events: {},
        listStyle: '',
        isSave: false,
        isShow: true,
        scan: false,
        style: { width: '100%' },
      },
    },
    {
      key: '66eb6ab6ef264e96a368e36441b2b976',
      field: 'appName',
      label: '应用名称',
      type: 'input',
      component: 'Input',
      colProps: { span: 24 },
      defaultValue: '',
      componentProps: {
        width: '100%',
        defaultValue: '',
        placeholder: '请输入应用名称',
        maxlength: null,
        prefix: '',
        suffix: '',
        addonBefore: '',
        addonAfter: '',
        disabled: false,
        allowClear: false,
        showLabel: true,
        required: true,
        rules: [],
        events: {},
        listStyle: '',
        isSave: false,
        isShow: true,
        scan: false,
        style: { width: '100%' },
      },
    },
    {
      key: '7f99ecf4c4ee4706a401743bc7c04fd0',
      field: 'appType',
      label: '应用类别',
      type: 'radio',
      component: 'ApiRadioGroup',
      colProps: { span: 24 },
      componentProps: {
        showLabel: true,
        disabled: false,
        optionType: 'default',
        staticOptions: [
          { key: 1, label: '表单', value: '0' },
          { key: 2, label: '桌面', value: '1' },
          { key: 3, label: '大屏', value: '2' },
          { key: 4, label: '其它', value: '3' },
        ],
        datasourceType: 'staticData',
        labelField: 'label',
        valueField: 'value',
        defaultSelect: '0',
        apiConfig: {
          path: 'CodeGeneration/selection',
          method: 'GET',
          apiId: '93d735dcb7364a0f8102188ec4d77ac7',
        },
        dicOptions: [],
        required: false,
        rules: [],
        events: {
          change:
            "let val=formModel.appType;formActionType.changeCompShow(schema,false,['appFormId','appDesktopId','appBiId','appPicture','appRemark']);if(val==='0'){formActionType.changeCompShow(schema,true,['appFormId','appPicture','appRemark'])}else if(val==1){formActionType.changeCompShow(schema,true,['appDesktopId','appRemark'])}else if(val==2){formActionType.changeCompShow(schema,true,['appBiId','appRemark'])}else{formActionType.changeCompShow(schema,true,['appPicture','appRemark'])}",
        },
        isShow: true,
        params: null,
        style: {},
      },
    },
    {
      key: '12741b740daa47b5915bf89e86decfcc',
      field: 'appStoreType',
      label: '应用商店分类',
      type: 'select',
      component: 'XjrSelect',
      colProps: { span: 24 },
      componentProps: {
        width: '100%',
        span: '',
        placeholder: '请选择应用商店分类',
        showLabel: true,
        showSearch: false,
        isMultiple: false,
        clearable: false,
        disabled: false,
        staticOptions: [
          { key: 1, label: 'Option 1', value: 'Option 1' },
          { key: 2, label: 'Option 2', value: 'Option 2' },
          { key: 3, label: 'Option 3', value: 'Option 3' },
        ],
        defaultSelect: null,
        datasourceType: 'dic',
        params: { itemId: '1838783020800827394' },
        labelField: 'name',
        valueField: 'value',
        apiConfig: {
          path: 'CodeGeneration/selection',
          method: 'GET',
          apiId: '93d735dcb7364a0f8102188ec4d77ac7',
        },
        dicOptions: [],
        required: true,
        rules: [],
        events: {},
        isShow: true,
        itemId: '1419276800524423168',
        style: { width: '100%' },
      },
    },
    {
      key: '9e6340ac08f347d088deecbfd89ab561',
      field: 'appVersion',
      label: '应用版本',
      type: 'input',
      component: 'Input',
      colProps: { span: 24 },
      defaultValue: '',
      componentProps: {
        width: '100%',
        defaultValue: '',
        placeholder: '请输入应用版本',
        maxlength: null,
        prefix: '',
        suffix: '',
        addonBefore: '',
        addonAfter: '',
        disabled: false,
        allowClear: false,
        showLabel: true,
        required: true,
        rules: [],
        events: {},
        listStyle: '',
        isSave: false,
        isShow: true,
        scan: false,
        style: { width: '100%' },
      },
    },
    {
      key: 'e850958886b54ca88a5221bc359c714b',
      field: 'appFormId',
      label: '表单数据',
      type: 'select',
      component: 'SelectForm',
      colProps: { span: 24 },
      componentProps: {
        width: '100%',
        placeholder: '请选择自定义表单',
        showLabel: true,
        disabled: false,
        required: true,
        rules: [],
        events: {},
        isShow: true,
        suffix: 'ant-design:ellipsis-outlined',
        formType: 1,
        isSingle: true,
        defaultValue: '',
        style: { width: '100%' },
      },
    },
    {
      key: 'e850958886b54ca88a5221bc359c7140',
      field: 'appDesktopId',
      label: '桌面数据',
      type: 'select',
      component: 'SelectDesignList',
      colProps: { span: 24 },
      componentProps: {
        width: '100%',
        title: '桌面设计设置',
        placeholder: '请选择桌面设计',
        showLabel: true,
        disabled: false,
        suffix: 'ant-design:ellipsis-outlined',
        formType: AppDataType.DESKTOP,
        isSingle: true,
        defaultValue: '',
        required: true,
        rules: [],
        events: {},
        isShow: true,
        style: { width: '100%' },
      },
    },
    {
      key: 'e850958886b54ca88a5221bc359c714f',
      field: 'appBiId',
      label: '大屏数据',
      type: 'select',
      component: 'SelectDesignList',
      colProps: { span: 24 },
      componentProps: {
        width: '100%',
        title: '大屏设置',
        placeholder: '请选择大屏数据',
        showLabel: true,
        disabled: false,
        suffix: 'ant-design:ellipsis-outlined',
        formType: AppDataType.BI,
        isSingle: true,
        defaultValue: '',
        required: true,
        rules: [],
        events: {},
        isShow: true,
        style: { width: '100%' },
      },
    },
    {
      field: 'appPicture',
      label: '应用图片',
      type: 'image',
      component: 'Image',
      componentProps: {
        span: '',
        defaultValue: '',
        showLabel: true,
        isShow: true,
        isUpload: true,
        events: {},
      },
      colProps: { span: 24 },
      key: '0809976997b849a8bd28545e7b62c084',
    },
    {
      key: '4e16a29a0c0d496da57c21065639459c',
      field: 'appRemark',
      label: '应用描述',
      type: 'textarea',
      component: 'InputTextArea',
      colProps: { span: 24 },
      defaultValue: '',
      componentProps: {
        width: '100%',
        defaultValue: '',
        placeholder: '请输入应用描述',
        maxlength: null,
        rows: 4,
        autoSize: false,
        showCount: false,
        disabled: false,
        showLabel: true,
        allowClear: false,
        required: false,
        isShow: true,
        rules: [],
        events: {},
        style: { width: '100%' },
      },
    },
  ],
  showActionButtonGroup: false,
  buttonLocation: 'center',
  actionColOptions: { span: 24 },
  showResetButton: false,
  showSubmitButton: false,
  hiddenComponent: [],
};

//左侧树结构配置
export const treeConfig = {
  id: '',
  name: '',
  type: 1,
  configTip: '',
  config: [],
  isMultiple: false,
};
