import { buildOption } from '/@/utils/helper/designHelper';
import { getFormTemplate } from '/@/api/form/design';
import { FormTemplateModel } from '/@/api/form/design/model';
import { FormJson } from '/@/model/generator/codeGenerator';
import { SystemComponentConfig } from '/@/model/workflow/bpmnConfig';
export async function getSystemJson(formId: string) {
  try {
    const systemJson = await getFormTemplate(formId);
    const systemComponent = {
      functionalModule: systemJson.functionalModule,
      functionName: systemJson.functionName,
      functionFormName: 'Form',
    };
    return { ...systemJson, systemComponent };
  } catch (error) {
    return null;
  }
  // const file = importLocale(formId);
  // try {
  //   const result = await file;
  //   return result && result.formProps ? result.formProps : null;
  // } catch (error) {
  //   return null;
  // }
}
/*
系统表单工作流权限获取
*/
export function importWorkflowPermission(systemComponent: SystemComponentConfig) {
  return import(
    `./../../views/${systemComponent.functionalModule}/${systemComponent.functionName}/components/workflowPermission.ts`
  );
}

// export function importLocale(locale: string) {
//   return import(`./../../views/dev/${locale}/components/config.ts`);
// }

export async function getCustomJson(formId: string) {
  try {
    const res = await getFormTemplate(formId);
    const model = JSON.parse(res.formJson) as FormTemplateModel;
    const formJson = model.formJson as unknown as FormJson;
    return res.formJson ? buildOption(formJson, false) : null;
  } catch (error) {
    return null;
  }
}
