import prettier from 'prettier/standalone';
import parserHtml from 'prettier/parser-html';
import parserTs from 'prettier/parser-typescript';
import parserBabel from 'prettier/parser-babel';

export const formatCode = (code: string, type = 'typescript'): string => {
  return prettier.format(code, {
    semi: true,
    singleQuote: true,
    printWidth: 100,
    trailingComma: 'all',
    proseWrap: 'never',
    htmlWhitespaceSensitivity: 'strict',
    endOfLine: 'auto',
    paser: type,
    plugins: [parserTs, parserBabel, parserHtml],
    vueIndentScriptAndStyle: true,
  });
};
