import {
  AddOrRemoveType,
  MultipleInstancesType,
  InstanceCompletionConditions,
  LevelEnum,
  MemberType,
} from '/@/enums/workflowEnum';
import { ApiConfig } from '/@/components/ApiConfig/src/interface';
/**
 * 人员（权限）[岗位 角色  用户]
 */
export type MemberListConfig = {
  id: string;
  name: string;
  type: string;
};
// 节点
export type NodesConfig = {
  id: string;
  name: string;
  checked?: boolean;
};
//表单配置
export type FormFiledConfig = {
  key: string;
  title: string;
  children: Array<FormFiledConfig>;
  disabled: boolean;
  label?: string;
  buttons?: Array<FormFiledConfig>;
};

//表单配置
export type FormFiled = {
  key: string;
  title: string;
  children: Array<FormFiledConfig>;
  disabled: boolean;
  formId: string;
  formField: string;
  label?: string;
  options?: any;
};

/**
 * 上级领导配置
 */
interface LeaderConfig {
  nodeId: string;
  level: LevelEnum;
}
export interface MemberConfig {
  memberType: MemberType;
  id: string; //存储所选值Id
  name: string; //存储所选值name
  leaderConfig?: LeaderConfig; //上级领导配置
  formFieldConfig?: {
    //表单字段
    nodeId: string;
    formId: string;
    formField: string;
    formKey: string;
  };
  apiConfig?: ApiConfig;
  limit?: string[];
}
export interface CountersignMemberConfig {
  memberType: MemberType;
  id: string; //存储所选值Id
  name: string; //存储所选值name
  leaderConfig?: LeaderConfig; //上级领导配置
  formFieldConfig?: {
    //表单字段
    nodeId: string;
    formId: string;
    formField: string;
    formKey: string;
  };
  checked: boolean; //会签节点是否
}

export interface CountersignConfig {
  multipleInstancesType: MultipleInstancesType; //多实例类型
  addOrRemove: AddOrRemoveType; //加签 或者 减签
  finishType: InstanceCompletionConditions; //完成条件  多实例
  percentage: number;
  countersignList: Array<CountersignMemberConfig>; //会签人员
}
